$(document).ready(function() {

    // We initialize the modal
    ModalTraitement.initialisation( LancerTraitement.modal_id );

    if ( ModalTraitement.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        LancerTraitement.setClickActionBtn();
    }

    $('#form_traitement_unitaire_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_traitement_unitaire_btn_execute').click(function(){
        LancerTraitement.lancerTraitementUnitaire();
    });

});

// We create an instance of the OdeModal object
const ModalTraitement = Object.create(OdeModal);

if( typeof(LancerTraitement) == 'undefined' ){ var LancerTraitement = { modal_id: 'ode_modal_traitement', loaded: false }; }

// We initialize the onclick function
LancerTraitement.setClickActionBtn = function(){
    $('[role="ode-modal-traitement-unitaire-btn"]').off().on('click', function () {
        $('#form_traitement_unitaire_btn_terminer').text('Annuler');
        $('#form_traitement_unitaire_btn_execute').show();
        ModalTraitement.initialisation( LancerTraitement.modal_id );
        ModalTraitement.open();
        LancerTraitement.initialisationUnitaire();
    });
}


LancerTraitement.initialisationUnitaire = function(){ 

    ModalTraitement.route('loading');

    var loading = function(){
        ModalTraitement.loading.setMessage('Récupération du dossier');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalTraitement.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalTraitement.route('erreur',this.result.erreur);
            return; 
        }

        var message = `Récupération du dossier`;

        ModalTraitement.loading.setMessage(message);
        ModalTraitement.loading.setTotal(1);
        ModalTraitement.loading.increaseCurrent();

        setTimeout(() => {
            ModalTraitement.route('traitement');
            ModalTraitement.loading.reset();
            retourFunctionTraitement.initChoixUnitaire(this);
        }, 1000);

    };

    var dossier = getDataFunctionTraitement.initChoixUnitaire();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_type_traitement');
    query.setAction("initChoixUnitaire");
    query.setPostData( dossier );
    OdeAjax.getByAction( query, loading, callBack );

}






LancerTraitement.lancerTraitementUnitaire = function(){
    var traitement_id = $("#select_traitement").children("option:selected").attr("id");
    var flux_traitement_id = $("#select_flux_traitement").children("option:selected").attr("id");
    if( traitement_id !== undefined && flux_traitement_id !== undefined ){
        $("#tbody_resultat_traitement").empty(); 
        $("#small_select_traitement").hide();
        $("#select_traitement").css('border', '1px solid green');
        ModalTraitement.route('loading');

        var loading = function(){
            ModalTraitement.loading.setMessage('Lancement du traitement');
        };

        var callBack = function(){

            var message = `Lancement du traitement du dossier`;

            ModalTraitement.loading.setMessage(message);
            ModalTraitement.loading.setTotal(1);
            ModalTraitement.loading.increaseCurrent();

            setTimeout(() => {
                ModalTraitement.route('traitement');
                ModalTraitement.loading.reset();
                retourFunctionTraitement.lancerTraitementByDossier(this);
                $('#form_traitement_unitaire_btn_terminer').text('Fermer');
                $('#form_traitement_unitaire_btn_execute').hide();
            }, 1000);
            
        };

        var obj_json = { dossier_id: getIdDossier(), traitement_id: $("#select_traitement").children("option:selected").attr("id"), flux_traitement_id: $("#select_flux_traitement").children("option:selected").attr("id") };
        var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        var query = OdeQueries.getAjaxActionQuery();
        query.setModule('OPS_type_traitement');
        query.setAction("lancerTraitementByDossier");
        query.setPostData( data );
        OdeAjax.getByAction( query, loading, callBack );

        }else{
           if( traitement_id == undefined ){
                $("#small_select_traitement").text("Aucun type n'est séléctionné").show();
                $("#select_traitement").css('border', '1px solid red');
            }
            if( flux_traitement_id == undefined ){
                $("#small_select_flux_traitement").text("Aucun flux n'est séléctionné").show();
                $("#select_flux_traitement").css('border', '1px solid red');
            }
        }
}







var RoutingTraitement = {

	route: function (form_name, data) {

        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }

        this.initFormulaire(form_name, data);
        this.displayFormulaire();

        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "message_traitement":
                Traitement.initMessage(data);
                break;
            case "loading_traitement":
                Traitement.initLoading();
                break;
            case "progress_loading_traitement":
                Traitement.initProgressLoading();
                break;
            case "choix_traitement_unitaire":
                Traitement.initChoixUnitaire(data);
                break;
            case "resultat_traitement_unitaire":
                Traitement.initResultatUnitaire(data);
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
	
};







var Traitement = {

    initMessage: function (data) {
        console.log("initMessage :: data = ", data)
    },

    initLoading: function () {
        LoadingTraitement.addSpinner($('#modal_traitement_loading'));
        $("#form_traitement_btn_lancer").hide();
    },

    initProgressLoading: function () {
        ProgressBarTraitement.initBar("traitement_progress_bar");
        $("#form_traitement_btn_lancer").hide();
    },


    initChoixUnitaire: function (data) {
        $("#small_select_traitement").hide();
        $("#traitement_description").text("");
        $("#select_traitement").css('border', '');
        $("#select_traitement").empty();
        $("#select_traitement").append('<option value=""></option>');
        if ( Object.keys(data.traitement).length > 0 ) {
            modal_traitement = data.traitement;
            Object.keys(data.traitement).forEach(function(traitement_id) {
                $("#select_traitement").append('<option id="'+ traitement_id +'" data-is-lot="'+ data.traitement[traitement_id].is_lot +'" >'+ data.traitement[traitement_id].name +'</option>');
            });
        }

        $("#small_select_flux_traitement").hide();
        $("#select_flux_traitement").css('border', '');
        $("#select_flux_traitement").empty();
        $("#select_flux_traitement").append('<option value=""></option>');
        if ( Object.keys(data.flux).length > 0 ) {
            //modal_flux = data.flux;
            Object.keys(data.flux).forEach(function(flux_id) {
                $("#select_flux_traitement").append('<option id="'+ flux_id +'">'+ data.flux[flux_id].name +'</option>');
            });
        }



    },


    initResultatUnitaire: function (data) {
        var resultat = data.result;

        $("#tbody_resultat_traitement").empty(); 
        $html_dossier =  '<tr>';
        $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
        $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
        $html_dossier +=         ( data.statut === true ) ? '#003a6c;">' : 'red;">';
        $html_dossier +=         resultat.dossier_name + '</a>';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=        ( data.statut === true  ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=       resultat.data_retour;
        $html_dossier +=    '</td>';
        $html_dossier += '</tr>';
        $("#tbody_resultat_traitement").append($html_dossier);

    },

}






function onChangeTraitement(){

    $("#traitement_description").text("");
    var traitement_id = $("#select_traitement").children("option:selected").attr("id");
    if( traitement_id !== undefined && Object.keys(modal_traitement).length > 0 && modal_traitement.hasOwnProperty(traitement_id) ){
        $("#traitement_description").text( modal_traitement[traitement_id].description );
    }

}




var LoadingTraitement = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

function lancerTraitementByDossier( dossier_id, dossiers_length ){

    var loading = function(){
        ModalTraitement.loading.setMessage('Lancement du traitement');
    };

    var callBack = function(){

        var message = ( dossiers_length === 1 ) 
                    ? `Lancement du traitement du dossier séléctionné`
                    : `Lancement du traitement des ${dossiers_length} dossiers séléctionnés`;

        ModalTraitement.loading.setMessage(message);
        ModalTraitement.loading.setTotal(dossiers_length);

        retourlancerTraitementByDossier( this, dossiers_length )
    };

    var obj_json = { dossier_id: dossier_id, traitement_id: $("#select_traitement").children("option:selected").attr("id") };
    var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_type_traitement');
    query.setAction("lancerTraitementByDossier");
    query.setPostData( data );
    OdeAjax.getByAction( query, loading, callBack );
    
}

function retourlancerTraitementByDossier( reponse, dossiers_length ){

    var resultat = reponse.result;

    $html_dossier = '';
    $html_dossier += '<tr>';
    $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
    $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
    $html_dossier +=         ( reponse.statut === true ) ? '#003a6c;">' : 'red;">';
    $html_dossier +=         resultat.dossier_name + '</a>';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=        ( reponse.statut === true ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=       resultat.data_retour;
    $html_dossier +=    '</td>';
    $html_dossier += '</tr>';
    $("#tbody_resultat_traitement").append($html_dossier);

    ModalTraitement.loading.increaseCurrent();

    if( ModalTraitement.loading.total === dossiers_length ){
        time = 2000 + (dossiers_length * 1000);
        setTimeout(function (){
            ModalTraitement.route('traitement');
            RoutingTraitement.route("resultat_traitement", false);
            $('#form_traitement_btn_terminer').text('Fermer');
            $('#form_traitement_btn_execute').hide();
        }, time); 
    }

}



function getIdDossier(){
    var searchParams = new URLSearchParams(location.search);
    return ( searchParams.get("record") ) ? searchParams.get("record") : "";
}



var getDataFunctionTraitement = {

    initChoixUnitaire: function() {
        var dossier_id = getIdDossier();
        return ( typeof dossier_id === "string" ) ? {dossier_id : dossier_id} : false;
    },
    /*lancerTraitementByDossier: function() {
        var traitement_id = $("#select_traitement").children("option:selected").attr("id") 
        var flux_traitement_id = $("#select_flux_traitement").children("option:selected").attr("id") 

        if( traitement_id !== undefined && flux_traitement_id !== undefined){
            var obj_json = { 
                dossier_id: getIdDossier(),
                traitement_id: traitement_id,
                flux_traitement_id: flux_traitement_id
            };
            return ( isJson( JSON.stringify( obj_json ) ) ) ? "json=" + utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        }else{
            if( traitement_id == undefined ){
                $("#small_select_traitement").text("Aucun traitement n'est séléctionné").show();
                $("#select_traitement").css('border', '1px solid red');
            }
            if( flux_traitement_id == undefined ){
                $("#small_select_flux_traitement").text("Aucun flux n'est séléctionné").show();
                $("#select_flux_traitement").css('border', '1px solid red');
            }
            return false;
        }
    },*/
    
};
//var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionTraitement : Object.assign(getDataFunction, getDataFunctionTraitement);


// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionTraitement = {
    initChoixUnitaire: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingTraitement.route( "choix_traitement_unitaire", data.result );
            } else {
                RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation1", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation2", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerTraitementByDossier: function(data) {
        if(data){
            RoutingTraitement.route( "resultat_traitement_unitaire", data );
        }else{
            RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation3", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
};


var retourFunctionTraitement = {
    initChoixUnitaire: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingTraitement.route( "choix_traitement_unitaire", data.result );
            } else {
                RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation4", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation5", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerTraitementByDossier: function(data) {
        if(data){
            RoutingTraitement.route( "resultat_traitement_unitaire", data );
        }else{
            RoutingTraitement.route( "message_traitement", { statut: "err", titre: "Initialisation6", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
};



//var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionTraitement : Object.assign(retourFunction, retourFunctionTraitement);