<?php

class OPS_traitement extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_traitement';
    public $object_name = 'OPS_traitement';
    public $table_name = 'ops_traitement';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $statut;
    public $pause;
    public $termine;
    public $requete;
    public $label_externe;
    public $source;
	
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * @access public
     * @name getNumTraitement()
     * Fonction qui retourne le dernier name sinon 1
     * 
     *  @return int       $last_name : le dernier numéro traitement
     */
    public static function getNumTraitement()
    {

        global $db;
        $last_name = 0;
        $requete = 'SELECT name FROM ops_traitement WHERE deleted = 0 AND name != "" ORDER BY name DESC LIMIT 1';
        $resultat = $db->query($requete);

        if ($resultat) {
            if ($db->getRowCount($resultat) !== 0) {
                $traitement = $db->fetchByAssoc($resultat);
                if (!empty($traitement['name'])) {
                    $last_name = $traitement['name'];
                }
            }
        } else {
            $GLOBALS['log']->fatal(" OPS_traitement :: initNumTraitement => Erreur requete SQL = " . print_r($db->lastError(), true));
        }

        return ($last_name > 0) ? $last_name + 1 : 1;
    }
	
}