var pageInitialized = false; // Js déclenché 2 fois

jQuery(function ($) {

    if(pageInitialized) return;
    pageInitialized = true;
    
    addVariables(document.EditView.inserer_variable, 'individu');

    let textMax = $('#count-char').data('max-char');
    let textAreaElement = $('textarea#description');

    if ($('#count-char').length > 0) {
        count_character(textAreaElement, textMax);
        textAreaElement.keyup(function () {
            count_character($(this), textMax);
        });

        $('#insert_variable').click(function () {
            if (length_with_variable(textAreaElement, textMax) < textMax) {
                insert_variable(
                    document.EditView.variable_module.options[document.EditView.variable_module.selectedIndex].value,
                    document.EditView.inserer_variable.options[document.EditView.inserer_variable.selectedIndex].value
                );
                count_character(textAreaElement, textMax);
            }
        });
    }
});


function insert_variable(prefixe, champs) {
    variable = '$' + prefixe + '_' + champs;
    desc_element = document.getElementById('description');

    if (document.selection) {
        desc_element.focus();
        sel = document.selection.createRange();
        sel.text = variable;
    } else if (desc_element.selectionStart || desc_element.selectionStart == '0') {
        var startPos = desc_element.selectionStart;
        var endPos = desc_element.selectionEnd;
        desc_element.value = desc_element.value.substring(0, startPos) +
            variable +
            desc_element.value.substring(endPos, desc_element.value.length);
    } else {
        desc_element.value += variable;
    }
}

function addVariables(the_select, select_value) {
    the_select.options.length = 0;

    let liste_champ = new Array();
    liste_champ = SUGAR.language.get('app_list_strings', 'list_champs_' + select_value);

    let i = 0;
    for (key in liste_champ) {
        var new_option = document.createElement("option");
        new_option.value = key;
        new_option.text = liste_champ[key];
        the_select.options.add(new_option, i);
        i++;
    }
}

function count_character(element, textMax) {
    let textLength = length_with_variable(element, textMax);
    let textRemaining = textMax - textLength;

    $('#count-char-label').html(textRemaining);
}

function length_with_variable(element, textMax) {
    let textArea = element.val();
    let textLength = textArea.length;

    let countVariable = detect_all_variables(textArea, element, textMax);

    if (countVariable > 0) {
        textLength -= countVariable * 10;
    }

    return textLength;
}

function get_available_variable() {
    if (
        typeof (localStorage) !== 'undefined' &&
        localStorage.getItem('obs_ops_available_variable') !== null
    ) {
        return JSON.parse(localStorage.getItem('obs_ops_available_variable'));
    }

    let availableVariable = [];

    let listChampsIndividu = SUGAR.language.get('app_list_strings', 'list_champs_individu');
    let listChampsEntiteIndividu = SUGAR.language.get('app_list_strings', 'list_champs_entite_individu');
    let listChampsDossier = SUGAR.language.get('app_list_strings', 'list_champs_dossier');
    let listChampsEntite = SUGAR.language.get('app_list_strings', 'list_champs_entite');

    let availableAppListVariable = Object.assign({},
        listChampsIndividu,
        listChampsEntiteIndividu,
        listChampsDossier,
        listChampsEntite
    );

    let before_identifier = [
        'entite_individu',
        'individu',
        'dossier',
        'demandeur',
        'beneficiaire',
        'entite'
    ];

    for (let identifier in availableAppListVariable) {
        for (let key_identifier in before_identifier) {
            availableVariable.push(before_identifier[key_identifier] + '_' + identifier);
        }
    }

    if (typeof (localStorage) !== 'undefined') {
        localStorage.setItem('obs_ops_available_variable', JSON.stringify(availableVariable));
    }
    return availableVariable;
}

function detect_all_variables(textArea, element, textMax) {
    let regexDollar = null;
    let countVariable = 0;
    let maxLengthToAdd = 0;

    let available_variable = get_available_variable();

    for (let i in available_variable) {
        regexDollar = new RegExp("\\$" + available_variable[i], 'gm');
        if (textArea.match(regexDollar) !== null) {
            countVariable += textArea.match(regexDollar).length;
            maxLengthToAdd += available_variable[i].length - 9;
        }
    }
    element.attr('maxlength', textMax + maxLengthToAdd);

    return countVariable;
}