<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once 'include/MassUpdate.php';

class OPS_statutController extends SugarController
{

    //   $GLOBALS['log']->fatal(" action_addVersion :: data = ".print_r($data,true));

    /**
     * @access public
     * @name action_initFormulaireModifierStatut()
     * Fonction pour initialiser le formulaire de modification de statut
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
     */
    public function action_initFormulaireModifierStatut()
    {

        $resultat = array("erreur" => "", "dossiers" => array());

        $data_verified =  $this->getDossiers($_REQUEST);
        if ($data_verified['statut'] == 'ok') {

            $dossiers = $data_verified['data'];
            if (is_array($dossiers) && count($dossiers) > 0) {

                // On récupere le ou les dispositifs associés aux dossiers
                $dispositifs = $this->isValidDispositifs($dossiers);

                if (is_array($dispositifs) && count($dispositifs) === 1) {

                    foreach ($dossiers as $dossier_id) {

                        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                        if (!empty($obj_dossier->id)) {

                            // Récupération de la liste des statuts
                            $obj_statut = new OPS_statut();
                            $tab_statuts = $obj_statut->liste_statuts($obj_dossier);
                            unset($tab_statuts['']);

                            if (!array_key_exists($obj_dossier->ops_statut_id,  $resultat['dossiers'])) {
                                $resultat['dossiers'][$obj_dossier->ops_statut_id] = array(
                                    "dossier_id" => $obj_dossier->id,
                                    "dossier_num" => $obj_dossier->num_dossier,
                                    "statut_name" => $this->getStatutName($obj_dossier->ops_statut_id),
                                    "etape_name" => $this->getEtapeName($obj_dossier->ops_etape_id),
                                    "statut_suivant" => $tab_statuts
                                );
                            } else {
                                $resultat['dossiers'][$obj_dossier->ops_statut_id]['dossier_id'] .= "|" . $obj_dossier->id;
                                $resultat['dossiers'][$obj_dossier->ops_statut_id]['dossier_num'] .= "," . $obj_dossier->num_dossier;
                            }
                        }
                    }
                } else {

                    $resultat['erreur'] = "Les dossiers sélectionnés sont associés à plusieurs dispositifs.";
                    $html_message = '';
                    foreach ($dispositifs as $dispositif) {
                        $html_message .= '<div style=" margin-left: 12px; margin-top: 5px;"> - <strong> ' . $dispositif['count'] . ' </strong>';
                        $html_message .=    ($dispositif['count'] === 1) ? 'dossier sur le dispositif' : 'dossiers sur le dispositif';
                        $html_message .=    ' " <strong>' . $dispositif['name'] . '</strong> " ';
                        $html_message .= '</div>';
                    }
                    $html_message .= '<div style="font-weight: bold; margin-top: 20px;"> Pour modifier les statuts, veuillez sélectionner des dossiers d\'un même dispositif </div>';
                    $resultat['html_message'] = $html_message;
                }
            } else {
                $resultat['erreur'] = "Aucun dossier n'a été récupéré.";
            }
        } else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $resultat['length'] = count($dossiers);

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => array('resultat' => $resultat)) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * @name action_modifierStatut()
     * Fonction pour modifier les statuts des dossiers
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
     */
    public function action_modifierStatut()
    {

        $resultat = array("erreur" => "", "dossiers" => array());
        $champs = array("json" => true);

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $total_dossier = 0;
            $data_decode = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($data_decode);
            foreach ($donnees->data as $data) {
                $statut_id = $data->statut_id;
                $dossiers = (strpos($data->dossiers, '|') !== false) ? explode("|", $data->dossiers) : array(0 => $data->dossiers);
                if (is_array($dossiers) && count($dossiers) > 0) {
                    foreach ($dossiers as $dossier_id) {
                        $total_dossier++;
                        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                        if (!empty($obj_dossier->id)) {

                            $ancien_statut_id = $obj_dossier->ops_statut_id;
                            $ancienne_etape_id = $obj_dossier->ops_etape_id;

                            $obj_dossier->updateStatut($statut_id, "mass");

                            if (!array_key_exists($ancien_statut_id,  $resultat['dossiers'])) {
                                $resultat['dossiers'][$ancien_statut_id] = array(
                                    "dossier_id" => $obj_dossier->id,
                                    "dossier_num" => $obj_dossier->num_dossier,
                                    "ancien_statut_name" => $this->getStatutName($ancien_statut_id),
                                    "nouveau_statut_name" => $this->getStatutName($obj_dossier->ops_statut_id),
                                    "ancienne_etape_name" => $this->getEtapeName($ancienne_etape_id),
                                    "nouvelle_etape_name" => $this->getEtapeName($obj_dossier->ops_etape_id),
                                );
                            } else {
                                $resultat['dossiers'][$ancien_statut_id]['dossier_id'] .= "|" . $obj_dossier->id;
                                $resultat['dossiers'][$ancien_statut_id]['dossier_num'] .= "," . $obj_dossier->num_dossier;
                            }
                        } else {
                            $resultat['dossiers'][$dossier_id] = "Dossier introuvable";
                        }
                    }
                }
            }
        } else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $resultat['length'] = $total_dossier;

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => array('resultat' => $resultat)) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
    /**
     * @access public
     * @name isValidDispositifs()
     * Fonction pour retourne les dispositifs des dossiers séléctionnés
     * 
     *  @param array						    $dossiers : les ids des dossiers séléctionnés
     *  @return array				            $dispositifs : les dispositifs associés aux dossiers séléctionnés 
     */
    function isValidDispositifs($dossiers)
    {

        $dispositifs = array();
        if (is_array($dossiers) && count($dossiers) > 0) {
            foreach ($dossiers as $dossier_id) {
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                if (!empty($obj_dossier->id)) {
                    $liste_dispositif = $obj_dossier->get_linked_beans("ops_dispositif_ops_dossier", "OPS_dispositif");
                    if (is_array($liste_dispositif) && count($liste_dispositif) === 1) {
                        if (array_key_exists($liste_dispositif[0]->id, $dispositifs)  === false) {
                            $dispositifs[$liste_dispositif[0]->id] = array(
                                'name' =>  $liste_dispositif[0]->name,
                                'count' => 1
                            );
                        } else {
                            $dispositifs[$liste_dispositif[0]->id]['count']++;
                        }
                    }
                }
            }
        }
        return $dispositifs;
    }

    /**
     * @access public
     * @name getDossiers()
     * Fonction pour retourne les ids des dossiers séléctionnés 
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return array				            $data : array avec un statut ( ok/err ) + les données ou le libellé de l'erreur
     */
    private function getDossiers($request)
    {
        global $db;
        $libelle_erreur = '';
        $dossiers = [];

        do {
            $data_verified = OdeArrayHelper::isDataValid($request, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['dossiers']) && is_array($data['dossiers']) && count($data['dossiers']) > 0) {
                $dossiers = $data['dossiers'];
                break;
            }
            if (!empty($data['filtres'])) {
                $json = htmlentities(json_encode($data['filtres']), ENT_QUOTES, 'UTF-8');
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des dossiers + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_dossier', $json);
                $where_clause = $mass->where_clauses;
                $obj_dossier = new OPS_dossier();
                $query = $obj_dossier->create_export_query("", $where_clause);
                $queryExplode = explode('FROM',$query);
                $queryExplode[0] = 'SELECT ops_dossier.id';
                $query = implode(' FROM', $queryExplode);
                $query = OPS_dossier::cleanQueryActionLot($query,array('ops_sous_territoire','ops_dossier','ops_elu'));
                $result = $db->query($query);
                while ($dossier = $db->fetchByAssoc($result)) {
                    $dossiers[] = $dossier['id'];
                }
            }

            // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
            if (!is_array($dossiers) || count($dossiers) === 0) {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossiers) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }

    /**
     * @access public
     * @name getDispositifs()
     * Fonction pour retourne les dispositifs des dossiers séléctionnés
     * 
     *  @param array						    $dossiers : les ids des dossiers séléctionnés
     *  @return array				            $dispositifs : les dispositifs associés aux dossiers séléctionnés 
     */
    function getDispositifs($dossiers)
    {

        $dispositifs = array();
        if (is_array($dossiers) && count($dossiers) > 0) {
            foreach ($dossiers as $dossier_id) {
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                if (!empty($obj_dossier->id)) {
                    $liste_dispositif = $obj_dossier->get_linked_beans("ops_dispositif_ops_dossier", "OPS_dispositif");
                    if (is_array($liste_dispositif) && count($liste_dispositif) === 1) {
                        if (array_key_exists($liste_dispositif[0]->id, $dispositifs)  === false) {
                            $dispositifs[$liste_dispositif[0]->id] = array(
                                'name' =>  $liste_dispositif[0]->name,
                                'count' => 1
                            );
                        } else {
                            $dispositifs[$liste_dispositif[0]->id]['count']++;
                        }
                    }
                }
            }
        }
        return $dispositifs;
    }

    /**
     * @access private
     * @name getStatutName()
     * Fonction qui retourne le libellé d'un statut
     * 
     *  @param string						    $statut_id : L'id du statut
     *  @return string				            $statut_name : Le libellé du statut
     */
    function getStatutName($statut_id)
    {

        $obj_statut = BeanFactory::getBean('OPS_statut', $statut_id);
        return (!empty($obj_statut->id)) ? $obj_statut->name : "";
    }

    /**
     * @access private
     * @name getEtapeName()
     * Fonction qui retourne le libellé d'une étape
     * 
     *  @param string						    $etape_id : L'id de l'étape
     *  @return string				            $etape_name : Le libellé de l'étape
     */
    function getEtapeName($etape_id)
    {

        $obj_etape = BeanFactory::getBean('OPS_etape', $etape_id);
        return (!empty($obj_etape->id)) ? $obj_etape->name : "";
    }

    /**
     * @access private
     * @name getDispositifName()
     * Fonction qui retourne le libellé du dispositif
     * 
     *  @param bean						        $obj_dossier : Objet OPS_dossier
     *  @return string				            $dispositif_name : Le libellé du dispositif
     */
    private function getDispositifName($obj_dossier)
    {

        $dispositif_name = "";
        if (!empty($obj_dossier->id)) {
            $liste_dispositif = $obj_dossier->get_linked_beans("ops_dispositif_ops_dossier", "OPS_dispositif");
            if (is_array($liste_dispositif) && count($liste_dispositif) === 1) $dispositif_name = $liste_dispositif[0]->name;
        }
        return $dispositif_name;
    }
}
