<?php


class hook_personne_morale {

    function display_personne_morale (&$bean , $event, $arguments)
	{
		$bean->accroche = html_entity_decode($bean->accroche);
		$bean->description_annuaire = html_entity_decode($bean->description_annuaire);
		$bean->activites = html_entity_decode($bean->activites);
		$bean->tarifs = html_entity_decode($bean->tarifs);
		$bean->public_beneficiaire = html_entity_decode($bean->public_beneficiaire);
	}

    //
    // Fonction d'initialisation du numéro de la demande
    //
    function set_num_tiers(&$bean, $event, $arguments = null)
    {
        if($event != 'before_save'){
            return;
        }

        if (empty($bean->num_tiers)) {
            global $db;

            $sql_num = 'SELECT num_tiers FROM ops_personne_morale WHERE deleted = 0 AND num_tiers != "" ORDER BY num_tiers DESC LIMIT 1';

            $result_num = $db->query($sql_num);
            if(!$result_num) {
                return $db->lastError();
            }

            if ($db->getRowCount($result_num) == 0) {
                $bean->num_tiers=1;
            } else {
                $row_num = $db->fetchByAssoc($result_num) ;
                $bean->num_tiers=$row_num['num_tiers']+1;
            }


            // Vérification de l'unicité d'une personne morale
            $verif_unicite = $bean->verif_unicite();

            if( !empty($verif_unicite) ){

                SugarApplication::appendErrorMessage("Création impossible - : " . $verif_unicite );
                $params = array(
                    'module'             => $bean->module_name,
                    'action'             => 'EditView',
                    'CreateFromIndividu' => 'true',
                    'return_action'      => $_REQUEST['return_action'],
                    'return_module'      => $_REQUEST['return_module'],
                    'return_id'          => $_REQUEST['return_id'],
                );

                SugarApplication::redirect('index.php?'. http_build_query($params));

            }
        }
        
        $bean->name = mb_convert_case( ucwords( strtolower(html_entity_decode($bean->name) ) , "-, \t\r\n\f\v'" ) , MB_CASE_UPPER, "UTF-8");
    }

    function set_categorie_nature_juridique_pse(&$bean, $event, $arguments = null)
    {
        if($event != 'before_save'){
            return;
        }

    }

    function deleteRelation(&$bean, $event, $arguments = null ){

        // pas de suppression des relation sur un merge record car on veut potentiellement garder les relations
        if($event != 'before_delete' || $_REQUEST['module'] == "MergeRecords"){
            return;
        }

        global $sugar_config;

        $listeRelation = array();
        $listeRelation['ops_personne_morale_individu']  = $bean->get_linked_beans('ops_personne_morale_ops_personne_morale_individu','OPS_personne_morale_individu');
        $listeRelation['ops_justificatif']     = $bean->get_linked_beans("ops_personne_morale_ops_justificatif", "OPS_justificatif");
        $listeRelation['ops_domiciliation'] = $bean->get_linked_beans('ops_personne_morale_ops_domiciliation','OPS_domiciliation');
        $listeRelation['documents'] = $bean->get_linked_beans('ops_personne_morale_documents ','Documents');
        $listeRelation['ops_appairage'] = $bean->get_linked_beans('ops_personne_morale_ops_appairage','OPS_appairage');

        $objDossier = BeanFactory::newBean('OPS_dossier');

        $listeRelation['ops_dossier'] = $objDossier->get_full_list(
                                'name',
                                "ops_dossier.deleted = 0 AND ops_dossier.ops_personne_morale='".$bean->id."'"
                                );

        foreach (array_keys($listeRelation) as $i => $relationship) {
            // Suppression des relations entre OPS_personne_morale et OPS_{$relationship}
            foreach ($listeRelation[$relationship] as $relation) {
                $relation->mark_deleted($relation->id);
            }
        }
        $dir = $sugar_config['ops_justificatif']['chemin']."/".$bean->id;

        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object)){
                    rmdir($dir. DIRECTORY_SEPARATOR .$object);

                }
                else{

                    unlink($dir. DIRECTORY_SEPARATOR .$object);
                }
            }
        }
         rmdir($dir);
    }

    /**
     * Hook en before delete
     * Fusion des personnes morales avec la prise en compte des relations
     */
    function fusionPersonneMorale(&$personneMoraleBean, $event, $arguments = null){
        global $db;
        if($event != 'before_delete' || $_REQUEST['module'] != "MergeRecords"){
            return;
        }

        // personne morale qu'on conserve
        $personneMoraleBeanNonSupprime = BeanFactory::getBean("OPS_personne_morale", $_REQUEST['record']);

        // update de la personne morale sur les dossiers
        $sql = "UPDATE `ops_dossier` SET `ops_personne_morale`='".$personneMoraleBeanNonSupprime->id."' WHERE `ops_personne_morale` = '" . $personneMoraleBean->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);

    }
}

?>
