<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Calendar\OdeCalendar;

class OPS_personne_moraleController extends SugarController
{

    /**
     * Bean that is being handled by the Calendar's current action.
     * @var SugarBean $currentBean
     */
    protected $currentBean = null;

    function action_checkDossier(){
        if(!empty($_REQUEST['json'])){
            $data = json_decode( base64_decode($_REQUEST['json']),true );
            $dossierObj = BeanFactory::getBean('OPS_dossier');
            $dossiers = $dossierObj->get_full_list(
                'num_dossier DESC',
                'ops_dossier.deleted = 0 AND ops_dossier.name != "TEMP" AND ops_dossier.cloture = 0 AND ops_dossier.ops_personne_morale="'.$data['record'].'"',
            );
            if(!empty($dossiers)){
                $resultat['message'] = "Suppression impossible : il existe un(des) dossier(s) non clôturé(s) rattaché(s) à ce profil";

                foreach ($dossiers as $dossier) {
                    $dossierBean = BeanFactory::getBean('OPS_dossier',$dossier->id);
                    $objDispositif = BeanFactory::getBean('OPS_dispositif',$dossierBean->ops_dispositif_id);
                    $resultat['dossiers'][$dossier->id] = array(
                        "id" => $dossier->id,
                        "num_dossier" => $dossier->num_dossier,
                        "brouillon" => $dossier->brouillon,
                        "cloture" => $dossier->cloture,
                        "dispositif" => $objDispositif->name,
                    );
                }
                $resultat['length'] = count($dossiers);
                $resultat['cloture'] = 0;
            }else{
                $dossiers = $dossierObj->get_full_list(
                    'num_dossier DESC',
                    'ops_dossier.deleted = 0 AND ops_dossier.cloture = 1 AND ops_dossier.ops_personne_morale="'.$data['record'].'"',
                );
                $resultat['message'] = "J'ai compris que les dossiers indiqués ici seront supprimés";
                foreach ($dossiers as $dossier) {
                    $dossierBean = BeanFactory::getBean('OPS_dossier',$dossier->id);
                    $objDispositif = BeanFactory::getBean('OPS_dispositif',$dossierBean->ops_dispositif_id);
                    $resultat['dossiers'][$dossier->id] = array(
                        "id" => $dossier->id,
                        "num_dossier" => $dossier->num_dossier,
                        "brouillon" => $dossier->brouillon,
                        "cloture" => $dossier->cloture,
                        "dispositif" => $objDispositif->name,
                    );
                }
                $resultat['cloture'] = 1;
                $resultat['length'] = count($dossiers);
            }

            $data = array('statut' => 'ok', 'data' => array('resultat' => $resultat));

            ob_clean();
            echo json_encode($data);
            sugar_cleanup(true);
        }
    }

    public function action_CalendarView() {
        $this->view = 'calendar';
    }

    public function action_getEventCalendar() {
        $events = [];

        if(isset($_POST['id']) && !empty($_POST['id'])) {
            $calendar = new OdeCalendar(module: 'OPS_personne_morale', id: $_POST['id']);
            $events = $calendar->getEvents();
        }

        ob_clean();
        echo json_encode($events);
        sugar_cleanup(true);
    }


    public function action_getApiBan(){

        global $sugar_config;

        $apiBanDisabled = $sugar_config['opensocle']['disable_api_ban'] ?? false;
        
        ob_clean();
        echo json_encode(["apiBanDisabled" => $apiBanDisabled]);
        sugar_cleanup(true);
    }
}
