<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

class OPS_individuViewEdit extends ViewEdit {

    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }

    function display()
    {
        global $app_list_strings, $current_user;
        
        asort($app_list_strings['ops_canal_list']);
        $GLOBALS['app_list_strings']['ops_canal_list'] = $app_list_strings['ops_canal_list'];

        asort($app_list_strings['ops_statut_compte_list']);
        $GLOBALS['app_list_strings']['ops_statut_compte_list'] = $app_list_strings['ops_statut_compte_list'];

        if($current_user->isAdmin())
        {
            $habilitation_individu = base64_encode(json_encode(['admin' => true]));
        }
        else
        {
            $habilitation_individu = (!empty($_SESSION['habilitation_individu'])) ? base64_encode(json_encode($_SESSION['habilitation_individu'])) : '';
        }
        
        $this->ss->assign("habilitation_individu", $habilitation_individu);

        $this->ss->assign("last_name", strtoupper($this->bean->last_name));
        $this->ss->assign("nom_usage", strtoupper($this->bean->first_name));

        parent::display();
    }
}
