/** ------------------------------------------------------------------------- Drag & Drop ----------------------------------------------------------------------------------- */
var ODE_ROUTER;
var ODE_NAVIGATION;



// Application User Interface
if( typeof(AppUI) == 'undefined' ){ var AppUI = { loaded:false }; }





jQuery(document).ready(function($){
    console.log('Hello from jQuery!');

    ODE_ROUTER = new GenerateurRouting();
    ODE_NAVIGATION = new GenerateurNavigation();

    void AppUI.bindEventInterface();

    AppUI.loaded = true;

});





// Bind events and behaviors to the related UI components !
AppUI.bindEventInterface = function(){

    // Init normalisation 
    if( $('input#formulaire_nom').length > 0 ){
        $('input#formulaire_nom').off().on('change', function() { $(this).val( String($(this).val()).idify() ); });
    }

    // Init normalisation de la CLE « Edition de l'onglet »
    if( $('input#formulaire_onglet_libelle').length > 0 && $('input#formulaire_onglet_cle').length > 0 ){
        $('input#formulaire_onglet_libelle').off()
            .on('change paste blur', function() { $('input#formulaire_onglet_cle').val( String($(this).val()).idify() ); })
            .on('keypress', function(event) { 
                var chrcode = String.fromCharCode(event.which);
                _do = [ 13, 34, 38 ].indexOf( chrcode.charCodeAt(0) );
                if ( _do > 0 ) { event.preventDefault(); }
             });
    }

    // Init Drag n' Drop
    // ... Use jQ !

}





/** ------------------------------------------------------------------------ Fonction de navigation  ---------------------------------------------------------------  **/

function displayAvances(){ ODE_ROUTER.route("layout_panel_avances", false); }

function displayStandard(){ ODE_ROUTER.route("layout_panel_standards", false); }

/** ------------------------------------------------------------------------------------------------------------------------------------------------------  **/




/** Returns a string slug format. IE10fail **/
String.prototype.idify   = function() { var _string = this; _string = _string.toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, "").trim().replace( /['-.]|(\s)/g, "_" ).replace( /[^a-zA-Z0-9_]/g, "_" ).replace( /([_]+)/g, "_" ).replace( /(^[_]|[_]$)/g, "" ).toLowerCase(); return _string; };




document.body.ondrop = function (event) {
    event.preventDefault();
    event.stopPropagation();
}

function onDragStart(event) {
    if( event.target.parentNode.id == "layout_panel_standards" ){
        event.currentTarget.style.backgroundColor = '#B8DAEF';
    }
   /* event.dataTransfer.clearData('text/plain');*/
    event.dataTransfer.setData('text/plain', event.target.id);
}

function onDragOver(event) {
    event.preventDefault();
}

function onDragEnd(event){
    if(event.dataTransfer.dropEffect == "none"){
        var evt_src = event.toElement || event.target;
        if(document.getElementById(evt_src.id)){
            document.getElementById(evt_src.id).style.backgroundColor = "white";

        }
    }
}

// Fonction qui se déclenche quand l'élement est déposé 
function onDrop(event) {

    const id = event.dataTransfer.getData('text');
    const draggableElement = document.getElementById(id);
    const dropzone = event.target;

    draggableElement.style.backgroundColor = "white";

    // Zone drop = Champ panel "Standards"
    if( hasClass(event.target,'champ_panel') ) {
        draggableElement.childNodes[2].style.display = "none";
        draggableElement.childNodes[1].style.width = "100%";
        document.getElementById("layout_panel_standards").appendChild(draggableElement);
    }

    // Zone drop = titre d'un champ
    if ( event.target.id.indexOf('titre_champ_') > -1 ){
        draggableElement.childNodes[2].style.display = "none";
        draggableElement.childNodes[1].style.width = "100%";
        document.getElementById("layout_panel_standards").appendChild(draggableElement);
    }

    // Zone drop = div panels
    if(event.target.id == "div_panels"){
        draggableElement.childNodes[2].style.display = "none";
        draggableElement.childNodes[1].style.width = "100%";
        document.getElementById("layout_panel_standards").appendChild(draggableElement);
    }

    // Zone drop = panel "td_layout_panels"
    if(event.target.id == "td_layout_panels"){
        draggableElement.childNodes[1].style.display = "none";
        draggableElement.childNodes[1].style.width = "100%";
        document.getElementById("layout_panel_standards").appendChild(draggableElement);
    }

    // Zone drop = Champ panel "Standards"
    if(event.target.id == "layout_panel_standards"){
        draggableElement.childNodes[2].style.display = "none";
        draggableElement.childNodes[1].style.width = "100%";
        dropzone.appendChild(draggableElement);
    }

    // Zone drop = Lignes
    if( hasClass(event.target,'td_layout_onglet') ) { 
        if(dropzone.childNodes.length == 0){ 
            draggableElement.childNodes[2].style.display = "block";
            draggableElement.childNodes[1].style.width = "50%";
            dropzone.appendChild(draggableElement);
        }
    }

    event.dataTransfer.clearData();

}

/** -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */


// Fonction pour ouvrir le formulaire de modification d'un onglet
function openEditOnglet(event){
    event.stopPropagation();
    var element = ( event.target && event.target.parentNode ) ? event.target.parentNode : false;
    if(element !== false) {
        ODE_ROUTER.route("layout_panel_formulaire_onglet", { fonction: "edit", onglet: {id: element.getAttribute("data-id"), libelle: element.getAttribute("data-libelle"), cle: element.getAttribute("data-cle")} }); 
    }
}

// Fonction pour ouvrir le formulaire de création d'un onglet
function createOnglet(){
    ODE_ROUTER.route("layout_panel_formulaire_onglet", { fonction: "create", onglet: {id: "", libelle: "", cle: ""} }); 
}

// Fonction de navigation entre les onglets 
function displayOnglet( onglet_id ){
    ODE_NAVIGATION.route( onglet_id )
}

function getDataOnglets(){

    var data_onglets = {};
    var list_layout = getListLayoutOnglets();
    if( list_layout.length >0 ){
        Object.keys(list_layout).forEach(function(key) { 
            var id = list_layout[key].id;
            if (isStringValid(id)) {
                data_onglets[id] = getDataTbody("tbody_"+id);
            }
        });
    }
    return data_onglets;
}

function getDataTbody(id){

    var data_tbody = {};
    if (isStringValid(id)) {
        if(document.getElementById(id)){
            if( document.getElementById(id).childNodes.length > 0 ){
                var lignes = document.getElementById(id).childNodes;
                Object.keys(lignes).forEach(function(key) { 
                    var ligne = lignes[key];
                    if( ligne.length != 1 ){
                        if( ligne.cells.length == 3 ){
                            data_tbody[key] = {
                                1: getDataTd(ligne.cells[0].firstElementChild),
                                2: getDataTd(ligne.cells[1].firstElementChild)
                            };
                        }
                    }
                });
            }
        }
    }
    return data_tbody;
}

function getDataTd(element){
    var champ = new GenerateurChamp(element);
    return ( champ.elements !== false && champ.getData() !== false ) ? champ.getData() : {};
}


function getListLayoutOnglets(){

    var list_layouts = [];
    var groupe_btn_onglets = document.getElementById("div_groupe_layout_onglets");
    if(groupe_btn_onglets.getElementsByTagName("div").length > 1){
        var divs = groupe_btn_onglets.getElementsByTagName("div");
        Object.keys(divs).forEach(function(key) {
            var id = divs[key].id;
            if (isStringValid(id)) {
                if(id.indexOf('layout_onglet_') > -1 ){
                    list_layouts.push({
                        id: id,
                    });
                }
            }
        });
    }
    
    return list_layouts;
}


/**----------------- Fonctions pour cacher les messages d'erreur et d'information------------------ */
function hideAddChampErreur() {
    $('#formulaire_nom_small').hide();
    document.getElementById("formulaire_nom").style.border = "";
};



function hideAddOngletErreur() {
    changeElementDisplay("add_onglet_erreur", "none");
};

function hideEditChampErreur() {
    changeElementDisplay("edit_champ_erreur", "none");
    changeElementDisplay("edit_champ_message", "none");
};
function hideEditOngletErreur() {
    changeElementDisplay("edit_onglet_erreur", "none");
    changeElementDisplay("edit_onglet_message", "none");
};
/**------------------------------------------------------------------------------------------------- */


// Fonction qui affiche le span Delete 
function displaySpanDelete(tr) {
    if(tr.childNodes.length > 0){
        var elements = tr.childNodes;
        Object.keys(elements).forEach(function(key) { 
            if(elements[key].firstElementChild){
                if(elements[key].firstElementChild.className == "glyphicon glyphicon-trash span_delete_ligne"){
                    elements[key].firstElementChild.style.display = "block";
                }
            }
        });
    }
}

// Fonction qui cache le span Delete hors hover
function hideSpanDelete(tr) {
    if(tr.childNodes.length > 0){
        var elements = tr.childNodes;
        Object.keys(elements).forEach(function(key) { 
            if(elements[key].firstElementChild){
                if(elements[key].firstElementChild.className == "glyphicon glyphicon-trash span_delete_ligne"){
                    elements[key].firstElementChild.style.display = "none";
                }
            }
        });
    }
}

// Fonction pour supprimer la ligne d'un onglet, elle retourne les champs au layout standard
function deleteLigneOnglet(span){
    if(span.parentNode.parentNode.cells.length == 3){
        if(span.parentNode.parentNode.cells[0].firstElementChild !== null){
            span.parentNode.parentNode.cells[0].firstElementChild.childNodes[2].style.display = "none";
            document.getElementById("layout_panel_standards").appendChild(span.parentNode.parentNode.cells[0].firstElementChild);
        }
        if(span.parentNode.parentNode.cells[1].firstElementChild !== null){
            span.parentNode.parentNode.cells[1].firstElementChild.childNodes[2].style.display = "none";
            document.getElementById("layout_panel_standards").appendChild(span.parentNode.parentNode.cells[1].firstElementChild);
        }
    }
    span.parentNode.parentNode.remove();
}



function getLibelleTypeChamp(type){
    var array_type = { 
        "montant": "Montant",
        "checkbox": "Case à cocher",
        "text": "Text",
        "date": "Date",
        "liste": "Liste",
        "liste_choix_simple": "Liste",
        "pourcentage": "Pourcentage",
        "text_long": "Text long",
    };
    return ( array_type.hasOwnProperty(type) ) ? " ("+array_type[type]+") " : " (Indéfini) " ; 
}


// Fonction qui récupere l'id de la vue à partir de l'url
function getIdVue() {
    if ($_GET('id_generateur_vue')) {
        return $_GET('id_generateur_vue');
    } else {
        return false;
    }
}

function hideSaveListeMessage(){
    changeElementDisplay("edit_liste_message", "none");
}





/** ------------------------------------------------------------------------ Gestion des champs ---------------------------------------------------------------  **/

// Fonction qui initialise le formulaire de création d'un champ
function createChamp(_type){ 
    setInputValue("formulaire_fonction","create");
    var _params = ( _type === "liste_choix_simple" || _type === "liste_choix_multi") ? utf8_to_b64( JSON.stringify( { liste: {} } ) ) : "";
    var _defaut = ( _type === "checkbox" ) ? "0" : "";
    var data = {
        fonction: "create",
        champ: {
            name: "",
            libelle: "",
            type: _type,
            obligatoire: "0",
            ineditable: "0",
            aide: "",
            defaut: _defaut,
            description: "custom",
            params:  _params,
            modifiable: "1"
        }
    };
    ODE_ROUTER.route("layout_panel_formulaire", data); 
}

// Fonction qui déclenche une action Ajax pour créer le champ en BDD 
function ajouterChamp(){
    execute("addChamp", "OPS_generateur_referentiel");
}

// Teste l'existance d'un champ déjà présent
function isFieldExist(champ_referentiel){
    return ( ( $('#layout_panel_standards').find('[data-name="'+champ_referentiel+'"].champ_referentiel') || [] ).length > 0 )? true : false;
}

// Fonction qui initialise le formulaire pour la modification du champ
function openEditChamp(_this){ 
    setInputValue("formulaire_fonction","edit");
    var champ = new GenerateurChamp(_this);
    var champ_data = champ.getData();
    if ( champ_data !== false ){  ODE_ROUTER.route("layout_panel_formulaire", { fonction: "edit", champ: champ_data });  }
}

// Fonction qui modifie les propriétés du champ
function modifierChamp(){ 
    var data_formulaire = getDataFormulaire();
    if ( isStringValid( data_formulaire.name ) ) {
        if( document.getElementById("champ_"+data_formulaire.name) ){
            var champ = new GenerateurChamp( document.getElementById("champ_"+data_formulaire.name) );
            if (champ.setData(data_formulaire)) {
                data_layout = { statut: "ok", titre: "Edition du champ", message: "Le champ "+champ.getLibelle()+" a bien été modifié." };
            } else {
                data_layout = { statut: "err", titre: "Edition du champ", message: " [Fatal] Erreur de modification du champ" };
            }
        }else{
            data_layout = { statut: "err", titre: "Edition du champ", message: " [Fatal] Erreur de récupération du champ" };
        }
    }else{
        data_layout = { statut: "err", titre: "Edition du champ", message: " [Fatal] Erreur de récupération du champ" };
    }
    ODE_ROUTER.route("layout_panel_message",data_layout);
}

// Fonction qui retour le type d'action sur le formulaire, pour différencier si on est sur un edit ou une création
function getNameFonctionFormulaire(){
    return ( isStringValid( getInputValue("formulaire_fonction") ) && getInputValue("formulaire_fonction") === "edit" ) ? "edit" : "create";
}

// Fonction initialise le formulaire de modification d'une liste
function editListe(){ 
    ODE_ROUTER.route("layout_panel_edit_liste", { fonction: getNameFonctionFormulaire(),  champ: getDataFormulaire()} ); 
}

// Fonction pour ajouter une ligne au formulaire edit liste *** LIMITE 12  ***
function addLigneListe( cle, value ){
    var div_lignes = ( document.getElementById("div_ligne_edit_liste") ) ? document.getElementById("div_ligne_edit_liste") : false;
    if ( div_lignes !== false && div_lignes.childNodes.length < 12 ) {
        var ligne_html  = '<div style="padding: 2%;">';
        ligne_html      +=    '<input type="text" placeholder="Clé" value="'+ cle +'" style="height: 10%;width: 25%;margin-right: 2%;">';
        ligne_html      +=    '<input type="text" placeholder="Valeur" value="'+ value +'" style="height: 10%;width: 65%;">';
        ligne_html      +=    '<span onclick="deleteLigneListe(this)" class="glyphicon glyphicon-trash" style="margin-left: 5px;color: red;cursor: pointer;"></span>';
        ligne_html      += '</div>';
        $("#div_ligne_edit_liste").append(ligne_html);
    }
}

// Fonction pour supprimer une ligne du formulaire edit liste 
function deleteLigneListe(element){
    element.parentNode.remove();
}

// Fonction pour sauvegarder la liste dans les params du champ 
function saveEditListe(){

    var data_champ_b64 = getInputValue("edit_liste_hidden");
    var data_champ = ( isStringValid(data_champ_b64) ) ? JSON.parse( b64_to_utf8( data_champ_b64) ) : {} ;
    var elements = getDataFormEditListe();
    if( Object.size(data_champ) > 0 && data_champ.hasOwnProperty("fonction")){
        if ( data_champ.hasOwnProperty("champ") && data_champ.champ.hasOwnProperty("params")){
            var params_b64 = utf8_to_b64( JSON.stringify( { "liste": elements } ) )
            data_champ.champ.params = params_b64; 
            setInputValue( "formulaire_params", params_b64 );
        }
        ODE_ROUTER.route("layout_panel_formulaire", data_champ);
    }

}

// Fonction retour au champ en cours d'édition
function terminerEditListe(){
    var data_champ_b64 = getInputValue("edit_liste_hidden");
    var data_champ = ( isStringValid(data_champ_b64) ) ? JSON.parse( b64_to_utf8( data_champ_b64) ) : {} ;
    if( Object.size(data_champ) > 0 && data_champ.hasOwnProperty("fonction") ){
        ODE_ROUTER.route("layout_panel_formulaire", data_champ); 
    }
}

// Fonction qui converti les lignes du formulaire edition de liste en object
function getDataFormEditListe(){
    var elements = {};
    var div_lignes = ( document.getElementById("div_ligne_edit_liste") ) ? document.getElementById("div_ligne_edit_liste") : false;
    if ( div_lignes !== false ) {
        var lignes = div_lignes.childNodes;
        Object.keys(lignes).forEach(function(key) {
            var ligne = lignes[key];
            if( ligne.childElementCount == 3 ){
                if( isStringValid(ligne.childNodes[0].value) && isStringValid(ligne.childNodes[1].value) ){
                    elements[ligne.childNodes[0].value] = ligne.childNodes[1].value;
                }
            }
        });
    }
    return elements;
}

// Fonction qui retourne les données du formulaire de création / modification d'un champ
function getDataFormulaire(){

    var champ_nom =  getInputValue("formulaire_nom");
    var champ_libelle =  getInputValue("formulaire_libelle");
    var champ_type =  getInputValue("formulaire_type");
    var champ_obligatoire = getCheckBoxValue("formulaire_obligatoire");
    var champ_ineditable =  getCheckBoxValue("formulaire_ineditable");
    var champ_aide =  getInputValue("formulaire_aide");
    if( champ_type === "checkbox" ){
        var champ_defaut = ( getCheckBoxValue("formulaire_defaut") === true ) ? "1" : "0" ;
    }else{
        var champ_defaut = getInputValue("formulaire_defaut")
    }
    var champ_description =  getInputValue("formulaire_description");
    var champ_params =  getInputValue("formulaire_params");
    var champ_modifiable =  getInputValue("formulaire_modifable");

    return data = {
        name: ( isStringValid(champ_nom) ) ? champ_nom : "",
        libelle: ( isStringValid(champ_libelle) ) ? champ_libelle : "",
        type: ( isStringValid(champ_type) ) ? champ_type : "",
        obligatoire: ( champ_obligatoire === true ) ? '1' : '0',
        ineditable: ( champ_ineditable === true ) ? '1' : '0',
        aide: ( isStringValid(champ_aide) ) ? champ_aide : "",
        defaut: ( isStringValid(champ_defaut) ) ? champ_defaut : "",
        description: ( isStringValid(champ_description) ) ? champ_description : "",
        params: ( isStringValid(champ_params) ) ? champ_params : "",
        modifiable: ( champ_modifiable === '0' ) ? '0' : '1',
    }

}


function getDataFormulaireOnglet(){

    var vue_id = getIdVue();
    var onglet_id =  getInputValue("formulaire_onglet_id");
    var onglet_libelle =  getInputValue("formulaire_onglet_libelle");
    var onglet_cle =  getInputValue("formulaire_onglet_cle");

    return {
        vue_id: ( isStringValid(vue_id) ) ? vue_id : "",
        id: ( isStringValid(onglet_id) ) ? onglet_id : "",
        libelle: ( isStringValid(onglet_libelle) ) ? onglet_libelle : "",
        cle: ( isStringValid(onglet_cle) ) ? onglet_cle : ""
    }

}


/** ------------------------------------------------------------------------------------------------------------------------------------------------------  **/



function hideErreurFormulaireOnglet(){
    changeElementDisplay("formulaire_onglet_libelle_small", "none");
    document.getElementById("formulaire_onglet_libelle").style.border = "none";
}

function addLigneOnglet( onglet_id ){
    
    ligne_html =    '<tr onmouseover="displaySpanDelete(this)" onmouseout="hideSpanDelete(this)">';
    ligne_html +=       '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);"></td>';
    ligne_html +=       '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);"></td>';
    ligne_html +=       '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span onclick="deleteLigneOnglet(this)" class="glyphicon glyphicon-trash span_delete_ligne" style="display: none;"></span></td>';
    ligne_html +=   '</tr>';
    $("#tbody_layout_onglet_" + onglet_id).append(ligne_html);

}

/**------------------------------------------------------------------------- Fonctions Ajax  ------------------------------------------------------------------- */


// Cette variable regroupe les differentes fonctions de récupération des données à envoyer au PHP
var getDataFunctionGenerer = {

    addOnglet: function() {

        var data = false;
        var data_formulaire = getDataFormulaireOnglet();
        if ( isStringValid(data_formulaire.libelle) && isJson( JSON.stringify(data_formulaire) ) ){
            data = "json=" + utf8_to_b64( JSON.stringify(data_formulaire) );
        }else{
            $('#formulaire_onglet_libelle_small').show();
            $('#formulaire_onglet_libelle').css( 'border' , '1px red solid' );
        }
        return data;

    },

    editOnglet: function() { 

        var data = false;
        var data_formulaire = getDataFormulaireOnglet();
        if ( isStringValid(data_formulaire.libelle) && isJson( JSON.stringify(data_formulaire) ) ){
            data = "json=" + utf8_to_b64( JSON.stringify(data_formulaire) );
        }else{
            $('#formulaire_onglet_libelle_small').show();
            $('#formulaire_onglet_libelle').css( 'border' , '1px red solid' );
        }
        return data;

    },

    deleteOnglet: function() {

        var data = false;
        var data_formulaire = getDataFormulaireOnglet();
        if ( isStringValid(data_formulaire.id) && isJson( JSON.stringify(data_formulaire) ) ){
            data = "json=" + utf8_to_b64( JSON.stringify(data_formulaire) );
        }else{
            console.log("Erreur de récupération de l'id de l'onglet")
        }
        return data;

    },

    editVue: function() {
        var vue_id = getIdVue();
        var data_vue = getDataOnglets();
        var json = JSON.stringify(data_vue);
        return (isJson(json) && isStringValid(vue_id)) ? "vue_id=" + vue_id + "&json=" + utf8_to_b64(json) : false;
    },

    addVersion: function() {
        var vue_id = getIdVue();
        var version =  getSelectValue("select_version_save");
        var commentaire =  getInputValue("commentaire_version_save");
        var data = (version != "" && isStringValid(vue_id) ) ? "vue_id=" + vue_id + "&version=" + version  +"&commentaire=" + commentaire : false;
        return data;
    },

    addChamp: function() {
        var data = false;
        var data_formulaire = getDataFormulaire();
        data_formulaire.name = String(data_formulaire.name).idify(); 
        var field_id = isStringValid(data_formulaire.name);


        if ( field_id ){
            if( !isFieldExist( field_id ) ){
                if( isJson(JSON.stringify(data_formulaire)) )
                {
                    data = "json=" + utf8_to_b64( JSON.stringify(data_formulaire) );
                    $('#formulaire_nom').css( 'border' , 'none' );
                }
            }else{
                $('#formulaire_nom_small').html("Ce nom est déjà utilisé !").show();
            }
        }else{
            $('#formulaire_nom_small').html("Le nom est obligatoire").show();
            $('#formulaire_nom').css( 'border' , '1px red solid' );
        } 
        return data;
    },

};

var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionGenerer : Object.assign(getDataFunction, getDataFunctionGenerer);
// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionGenerer = {

    addOnglet: function() {
        if(document.getElementById('formulaire_onglet_ajouter')){
            document.getElementById('formulaire_onglet_ajouter').childNodes[1].style.display = "block";
        }
    },

    editOnglet: function() { 
        if(document.getElementById('formulaire_onglet_modifier')){
            document.getElementById('formulaire_onglet_modifier').childNodes[1].style.display = "block";
        }
    },

    deleteOnglet: function() {
        if(document.getElementById('formulaire_onglet_supprimer')){
            document.getElementById('formulaire_onglet_supprimer').childNodes[1].style.display = "block";
        }
    },

    editVue: function() {
        changeElementDisplay("span_loading_btn_sauvegarder", "inline-block");
    },

    addVersion: function() {
        changeElementDisplay("span_loading_btn_sauvegarder", "inline-block");
    },

    addChamp: function() {
        if(document.getElementById('formulaire_btn_ajouter')){
            document.getElementById('formulaire_btn_ajouter').childNodes[1].style.display = "block";
        }
    },
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionGenerer : Object.assign(loadingFunction, loadingFunctionGenerer);

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionGenerer = {

    addOnglet: function(data) {

        if (data) {
            if ( data['statut'] == "ok" ) {
                
                this.createOnglet( data.data.onglet );
                data_layout = { statut: "ok", titre: "Création Onglet", message: " L'onglet " + data.data.onglet.libelle + " a bien été créé. " };

            } else { data_layout = { statut: "err", titre: "Création Onglet", message: " [Fatal] " + data['data'] }; }

        } else { data_layout = { statut: "err", titre: "Création Onglet", message: " [Fatal] format de retour différent de JSON" }; }

        ODE_ROUTER.route("layout_panel_message",data_layout);
    },

    createOnglet( data_onglet ){

        var onglet_id = ( isStringValid( data_onglet.id ) ) ? data_onglet.id : "" ;
        var onglet_libelle = ( isStringValid( data_onglet.libelle ) ) ? data_onglet.libelle : "" ;
        var onglet_cle = ( isStringValid( data_onglet.cle ) ) ? data_onglet.cle : "" ;

        bouton_onglet = '<div class="div_button_onglet">';
        bouton_onglet +=    '<div role="onglet" id="btn_onglet_' + onglet_id + '" data-id="' + onglet_id + '" data-libelle="' + onglet_libelle + '" title="' + onglet_libelle + '" ';
        bouton_onglet +=    'data-cle="' + onglet_cle + '" onclick="displayOnglet(\'' + onglet_id + '\')" class="btn_onglet btn_onglet_not_selected" data-selected="0">';
        bouton_onglet +=        '<div class="div_libelle_button_onglet" id="titre_onglet_'+onglet_id+'">';
        bouton_onglet +=             onglet_libelle;
        bouton_onglet +=        '</div>';
        bouton_onglet +=           '<span id="span_' + onglet_id + '" class="glyphicon glyphicon-pencil span_edit_onglet" onclick="openEditOnglet(event)" style="display:none;"></span>';
        bouton_onglet +=    '</div>';
        bouton_onglet += '</div>';
        $("#div_groupe_btn_onglets").append(bouton_onglet);

        layout_onglet = '<div id="layout_onglet_' + onglet_id + '" class="div_layout_onglet" style="display:none;">';
        layout_onglet +=    '<table class="table_layout_onglet">';
        layout_onglet +=        '<tbody id="tbody_layout_onglet_' + onglet_id + '">';
        layout_onglet +=            '<tr onmouseover="displaySpanDelete(this)" onmouseout="hideSpanDelete(this)">';
        layout_onglet +=                '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);"></td>';
        layout_onglet +=                '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);"></td>';
        layout_onglet +=                '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span onclick="deleteLigneOnglet(this)" class="glyphicon glyphicon-trash span_delete_ligne"></span></td>';
        layout_onglet +=            '</tr>';
        layout_onglet +=        '</tbody>';
        layout_onglet +=    '</table>';
        layout_onglet +=    '<a class="btn_add_new_ligne" onclick="addLigneOnglet(\'' + onglet_id + '\')">';
        layout_onglet +=        '<span class="glyphicon glyphicon-plus" style="color: white;"></span>';
        layout_onglet +=    '</a>';
        layout_onglet += '</div>';
        $("#div_groupe_layout_onglets").append(layout_onglet);

    },

    editOnglet: function(data) { 

        if (data) {
            if (data['statut'] == "ok") {

                this.modifierOnglet( data.data.onglet );
                data_layout = { statut: "ok", titre: "Modification Onglet", message: " L'onglet " + data.data.onglet.libelle + " a bien été modifié. " };

            } else { data_layout = { statut: "err", titre: "Modification Onglet", message: " [Fatal] " + data['data'] }; }

        } else { data_layout = { statut: "err", titre: "Modification Onglet", message: " [Fatal] format de retour différent de JSON" }; } 

        ODE_ROUTER.route("layout_panel_message",data_layout);

    },

    modifierOnglet( data_onglet ){

        var onglet_id = ( isStringValid( data_onglet.id ) ) ? data_onglet.id : "" ;
        var onglet_libelle = ( isStringValid( data_onglet.libelle ) ) ? data_onglet.libelle : "" ;
        var onglet_cle = ( isStringValid( data_onglet.cle ) ) ? data_onglet.cle : "" ;

        setElementAttribute( "btn_onglet_" + onglet_id, "data-libelle", onglet_libelle );
        setElementAttribute( "btn_onglet_" + onglet_id, "data-cle", onglet_cle );

        if(document.getElementById( "titre_onglet_" + onglet_id )){
            viderElement("titre_onglet_" + onglet_id);
            document.getElementById( "titre_onglet_" + onglet_id ).appendChild(document.createTextNode( onglet_libelle ) );
        }
     
    },

    deleteOnglet: function(data) {

        if (data) {
            if (data['statut'] == "ok") {

                this.supprimerOnglet( data.data.onglet );
                data_layout = { statut: "ok", titre: "Suppression d'onglet", message: " L'onglet " + data.data.onglet.libelle + " a bien été supprimé. " };
                
            } else { data_layout = { statut: "err", titre: "Suppression Onglet", message: " [Fatal] " + data['data'] }; }

        } else { data_layout = { statut: "err", titre: "Suppression Onglet", message: " [Fatal] format de retour différent de JSON" }; } 

        ODE_ROUTER.route("layout_panel_message",data_layout);
    },

    supprimerOnglet( data_onglet ){

        var onglet_id = ( isStringValid( data_onglet.id ) ) ? data_onglet.id : "" ;

        if(document.getElementById('layout_onglet_'+onglet_id)){
            if(document.getElementById( 'layout_onglet_' + onglet_id ).getElementsByTagName("tbody").length == 1){
                var tbody = document.getElementById( 'layout_onglet_' + onglet_id ).getElementsByTagName("tbody")[0];
                if(tbody.childNodes.length > 0){
                    var champs = [];
                    var lignes = tbody.childNodes;
                    if(lignes.length > 0){
                        for (let index = 0; index < lignes.length; index++) {
                            var ligne = lignes[index];
                            if(ligne.cells){
                                if(ligne.cells.length == 3){
                                    if(ligne.cells[0].firstElementChild !== null){
                                        champs.push(ligne.cells[0].firstElementChild);
                                    }
                                    if(ligne.cells[1].firstElementChild !== null){
                                        champs.push(ligne.cells[1].firstElementChild);
                                    }
                                }
                            }
                        }
                        if(this.handelChampsAfterDelete(champs) === true){
                            document.getElementById( 'layout_onglet_'+ onglet_id ).remove();
                            document.getElementById( 'btn_onglet_'+ onglet_id ).parentNode.remove();
                            // Select first onglet 
                            ODE_NAVIGATION.route( false );
                        }
                    }
                }
            }
        }
         
    },

    handelChampsAfterDelete: function(champs) {
        champs.forEach(champ => {
            if( champ.childNodes.length === 3 ){
                champ.childNodes[2].style.display = "none";
            }
            document.getElementById("layout_panel_standards").appendChild(champ);
        });
        return true;
    },

    editVue: function(data) {
        if (data) {
            if (data['statut'] == "ok") {
                changeElementDisplay("div_message_sauvegarde_vue","block");
                changeElementDisplay("btn_modal_save_sauvegarder","none");
                changeElementDisplay("btn_modal_save_terminer","inline-block");
                if( document.getElementById("radio_version_oui") ){
                    if( document.getElementById("radio_version_oui").getAttribute("checked") == 'true' ){
                        execute("addVersion","OPS_generateur_vue"); 
                    }
                }
            } else {
                console.log("editVue() => Erreur =", data['data'])
            }
        } else {
            console.log(" editVue() => format de retour différent de JSON ")
        }
    },

    addVersion: function(data) {
        if (data) {
            if (data['statut'] == "ok") {
                if( document.getElementById("div_message_sauvegarde_version") ){
                    viderElement("span_message_sauvegarde_version");
                    document.getElementById("span_message_sauvegarde_version").appendChild(document.createTextNode("v"+data['data']['version']));
                    changeElementDisplay("div_message_sauvegarde_version","block");
                }
                document.getElementById("btn_modal_save_terminer").setAttribute("load","true");
            } else {
                console.log("addVersion() => Erreur =", data['data'])
            }
        } else {
            console.log(" addVersion() => format de retour différent de JSON ")
        }
    },

    addChamp: function(data) {
        if (data) {
            if (data['statut'] == "ok") {
                var champ = new GenerateurChamp();
                champ.createElement(getDataFormulaire()); 
                if( champ.element !== false ){
                    data_layout = { statut: "ok", titre: "Création du champ", message: "Le champ "+champ.getLibelle()+" a bien été créé et ajouté à la liste des champs disponibles." };
                }else{
                    data_layout = { statut: "err", titre: "Création du champ", message: "[Warning] Le champ a bien été créé, veuillez actualiser la page." };
                }
            } else {
                data_layout = { statut: "err", titre: "Création du champ", message: data['data'] };
            }
        } else {
            data_layout = { statut: "err", titre: "Création du champ", message: " [Fatal] Format de retour différent de JSON" };
        }
        ODE_ROUTER.route("layout_panel_message",data_layout);
    }

};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionGenerer : Object.assign(retourFunction, retourFunctionGenerer);

/** ------------------------------------------------------------------------- Modal Save ------------------------------------------------------------------------------ */

// Fonction qui ouvert la modal de sauvegarde  
function saveVue() {

    initModalSave();

    // Modal responsive 
    var modal_width = window.innerWidth / 3;
    var modal_height = window.innerHeight / 3;

    // Génération de la popup 
    $(function() {
        $('#div_modal_save').dialog({
            resizable: false,
            height: modal_height,
            width: modal_width,
            modal: true,
            dialogClass: "no-close",
            draggable: false,
            buttons: [ 
                {
                    text: "Sauvegarder",
                    class: "btn_modal ld-ext-right",
                    id: "btn_modal_save_sauvegarder",
                    click: function() {
                        sauvegarderModalSave();
                    }
                },
                {
                     text: "Annuler",
                     class: "btn_modal",
                     id: "btn_modal_save_annuler",
                     click: function() {
                        $(this).dialog("close");
                     }
                },
                {
                     text: "Terminer",
                     class: "btn_modal",
                     id: "btn_modal_save_terminer",
                     click: function() {
                        (document.getElementById("btn_modal_save_terminer").getAttribute("load")) ? window.location.reload() : $(this).dialog("close");
                     }
                }
             ]
         });
    });

    // Cacher le container titre de la modal
    if (document.getElementsByClassName("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix")[2]){
        document.getElementsByClassName("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix")[2].style.display = "none";
    }
    if (document.getElementById("div_modal_save")){
        document.getElementById("div_modal_save").style = "min-height: 215px;";
    }
    changeElementDisplay("btn_modal_save_terminer", "none");

    if (document.getElementById("btn_modal_save_sauvegarder")){
        var btn_terminer = document.getElementById("btn_modal_save_sauvegarder");
        btn_terminer.firstChild.setAttribute("style",  "display: inline-block; padding-right: 3px;margin-right: 10px;");
        var div_loading = document.createElement("div"); 
        div_loading.setAttribute("id", "span_loading_btn_sauvegarder");
        div_loading.setAttribute("class", "ld ld-ring ld-spin");
        div_loading.setAttribute("style",  "margin-right: 7px;margin-left: -9px; display:none;");
        btn_terminer.appendChild(div_loading);
    }

}

function changeChoiceSave(radio){
    if (isStringValid(radio.value)){
        if( document.getElementById("div_version_choice") ){
            if(radio.value == "oui"){
                radio.setAttribute("checked",'true');
                document.getElementById("div_version_choice").style.display = "block";
                removeElementAttribute("radio_version_non","checked");
            }
            if(radio.value == "non"){
                radio.setAttribute("checked",'true');
                document.getElementById("div_version_choice").style.display = "none";
                removeElementAttribute("radio_version_oui","checked");
            }
        } 
    }
}

function initModalSave(){

    // Radio => Non checked = true
    document.getElementById("radio_version_non").checked = true;
    // Radio => Oui checked = false
    removeElementAttribute("radio_version_oui","checked");
    // Hide div Choice
    changeElementDisplay("div_version_choice", "none");
    // Select => first select_version_save
    if( document.getElementById("select_version_save") ){
        document.getElementById("select_version_save").options.selectedIndex = 0
    }
    // Commentaire empty commentaire_version_save
    setInputValue("commentaire_version_save","")

    if(document.getElementById("label_yes_no_radio")){
        document.getElementById("label_yes_no_radio").style.opacity = 1;
    }
    removeElementAttribute("radio_version_oui","disabled");
    removeElementAttribute("radio_version_non","disabled");

    changeElementDisplay("span_loading_btn_sauvegarder", "none");

    changeElementDisplay("div_message_sauvegarde_version", "none");
    changeElementDisplay("div_message_sauvegarde_vue", "none");
}

function sauvegarderModalSave(){

    var data_vue = getDataOnglets();

    if( isValidVue( data_vue ) ){
        setElementAttribute("radio_version_oui","disabled","true")
        setElementAttribute("radio_version_non","disabled","true")
    
        // Hide div Choice
        changeElementDisplay("div_version_choice", "none");
    
        if(document.getElementById("label_yes_no_radio")){
            document.getElementById("label_yes_no_radio").style.opacity = 0.5;
        }
    
        changeElementDisplay("btn_modal_save_annuler", "none");
        //changeElementDisplay("btn_modal_save_terminer", "inline-block");
    
        execute("editVue","OPS_generateur_vue");

    }else{
        alert("Les champs 'demandeur' et 'dispositif' sont obligatoires pour la sauvegarde de la vue.")
    }

}

function isValidVue( data_vue ) {
    var demandeur = false;
    var dispositif = false;
    if( Object.size(data_vue) > 0 ){
        Object.keys(data_vue).forEach(function(onglet_id) {
            const onglet = data_vue[onglet_id];
            if( Object.size(onglet) > 0 ){
                Object.keys(onglet).forEach(function(ligne_num) {
                    const ligne = onglet[ligne_num];
                    if( Object.size(ligne) > 0 ){
                        Object.keys(ligne).forEach(function(champ_num) {
                            const champ = ligne[champ_num];
                            if( champ.hasOwnProperty("name") && isStringValid( champ['name'] )){
                                if( champ['name'] === "demandeur" ) demandeur = true;
                                if( champ['name'] === "dispositif" ) dispositif = true;
                            }
                        }.bind(this));
                    }
                }.bind(this));
            }
        }.bind(this));
    }
    return ( demandeur === true && dispositif === true ) ? true : false;
}
/**-------------------------------------------------------------------------------------------------------------------------------------------------------- */

