
<?php

use ODE\Helper\OdeArrayHelper;
use ODE\Model\GenerateurVueModel;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


class OPS_generateur_vueController extends SugarController
{


    /**---------------------------------------------------------------------------------------------------------------------------------------------------------------- */
    /**------------------------------------------------------------------------- Vue ---------------------------------------------------------------------------------- */
    /**---------------------------------------------------------------------------------------------------------------------------------------------------------------- */

    /**
     * @access public
     * action_editVue()
     * Fonction qui sauvegarde les modifications de la vue
     *
     * @return json     $data
     */
    function action_editVue()
    {

        $count_erreur = 0;
        $libelle_erreur = '';

        $champs = array(
            "vue_id" => true,
            "json" => true,
        );

        // Vérification des champs recu dans $_REQUEST
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $onglets = $data_verified['data']['json_array'];
            foreach ($onglets as $id_layout_onglet => $lignes_onglet) {

                // On récupere l'objet onglet 
                $obj_onglet = BeanFactory::getBean('OPS_generateur_onglet', str_replace("layout_onglet_", "", $id_layout_onglet));
                if (!empty($obj_onglet->id)) {

                    // On supprime les anciens champs rattaché à l'onglet
                    $liste_champs = $obj_onglet->get_linked_beans("ops_generateur_onglet_ops_generateur_champ", "OPS_generateur_champ");
                    foreach ($liste_champs as $key => $champ) {
                        $champ->mark_deleted($champ->id);
                    }

                    // On boucle sur les lignes de l'onglet pour créer les champs 
                    foreach ($lignes_onglet as $ligne => $champs) {

                        $retour_1 = $this->addChampOnglet($obj_onglet, $ligne, 1, $champs[1]);
                        $retour_2 = $this->addChampOnglet($obj_onglet, $ligne, 2, $champs[2]);

                        // Si on a une erreur on incrémente la variable count_erreur
                        if ($retour_1 === false) $count_erreur++;
                        if ($retour_2 === false) $count_erreur++;
                    }
                } else {
                    $libelle_erreur = "l'onglet ( id = " . str_replace("layout_onglet_", "", $id_layout_onglet) . ") est inconnu .";
                    $count_erreur++;
                    $GLOBALS['log']->fatal(" OPS_generateur_vueController :: action_editVue   => l'onglet ( id = " . str_replace("layout_onglet_", "", $id_layout_onglet) . ") est inconnu .");
                }
            }
        } else {
            // On retourne les erreurs de vérification
            $libelle_erreur = $data_verified['data'];
            $count_erreur++;
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = ($count_erreur == 0) ? array('statut' => 'ok', 'data' => $data_verified['data']) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_replace()
     * Fonction qui 
     *
     * @return json     $data
     */
    function action_replace()
    {

        $libelle_erreur = '';

        // Vérification des champs recu dans $_REQUEST
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, ["json" => true]);
        if ($data_verified['statut'] == 'ok') {

            $donnees = $data_verified['data']['json_array'];
            if (!empty($donnees["id"])) {
                GenerateurVueModel::deleteOnglets($donnees["id"]);
                if (is_array($donnees["data"]) && count($donnees["data"]) > 0) {
                    foreach ($donnees["data"] as $onglet) {
                        // create onglet
                        $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $donnees["id"]);
                        $obj_onglet = BeanFactory::newBean('OPS_generateur_onglet');
                        $obj_onglet->name = strtolower(str_replace(" ", "_", $onglet['libelle']));
                        $obj_onglet->libelle = $onglet['libelle'];
                        $obj_onglet->cle = $onglet['cle'];
                        $obj_onglet->ordre = $onglet['ordre'];
                        $obj_onglet->conditions = $onglet['conditions'];
                        $obj_onglet->save(false);

                        // add relation onglet - vue 
                        $obj_generateur_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
                        $obj_generateur_vue->ops_generateur_vue_ops_generateur_onglet->add($obj_onglet->id);

                        // create lignes
                        if (is_array($onglet["lignes"]) && count($onglet["lignes"]) > 0) {
                            $obj_onglet->createLignes($onglet["lignes"]);
                        }
                    }
                } else {
                    $libelle_erreur = "Erreur de récupération de la vue source";
                }
            } else {
                $libelle_erreur = "La vue n'a pas pu etre récupéré";
            }
        } else {
            // On retourne les erreurs de vérification
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $donnees) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * addChampOnglet()
     * Fonction qui crée un champ est l'ajoute à l'onglet
     * 
     * @param bean                  $onglet: l'object OPS_generateur_onglet initialisé en amont
     * @param integer               $ligne: le numéro de la ligne
     * @param integer               $ordre: le numéro de la colonne 
     * @param array                 $champ: tableau avec les valeurs nécessaires pour la création d'un champ
     * @return boolean              $created: true ou false
     */
    function addChampOnglet($onglet, $ligne, $ordre, $champ)
    {

        $created = false;
        $obj_champ = new OPS_generateur_champ;

        if (is_array($champ) && count($champ) > 0) {

            $obj_champ->name = $champ['name'];
            $obj_champ->libelle = $champ['libelle'];
            $obj_champ->type = $champ['type'];
            $obj_champ->obligatoire = $champ['obligatoire'];
            $obj_champ->ineditable = $champ['ineditable'];
            $obj_champ->aide = $champ['aide'];
            $obj_champ->defaut = $champ['defaut'];
            $obj_champ->description = $champ['description'];
            $obj_champ->params = $champ['params'];
            $obj_champ->ligne = $ligne;
            $obj_champ->ordre = $ordre;
            $obj_champ->modifiable = $champ['modifiable'];
        } else {
            $obj_champ->name = "";
            $obj_champ->type = "vide";
            $obj_champ->ligne = $ligne;
            $obj_champ->ordre = $ordre;
        }

        $id = $obj_champ->save(false);
        if (!empty($id)) {
            $onglet->load_relationship('ops_generateur_onglet_ops_generateur_champ');
            $onglet->ops_generateur_onglet_ops_generateur_champ->add($id);
            $created = true;
        }

        return $created;
    }

    /**---------------------------------------------------------------------------------------------------------------------------------------------------------------- */
    /**---------------------------------------------------------------------- Version --------------------------------------------------------------------------------- */
    /**---------------------------------------------------------------------------------------------------------------------------------------------------------------- */

    /**
     * @access public
     * action_editVue()
     * Fonction qui crée une version et la rattache à la vue
     *
     */
    function action_addVersion()
    {

        $data = array(
            'statut' => 'err',
            'data' => '',
        );
        $champs = array(
            "vue_id" => true,
            "version" => true,
            "commentaire" => false,
        );

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $data_verified['data']['vue_id']);
            $vue_json = (!empty($obj_generateur_vue->id)) ? json_encode($obj_generateur_vue->getArrayFormat()) : json_encode(array());

            $obj_version = new OPS_generateur_version;
            $obj_version->name = $data_verified['data']['version'];
            $obj_version->description = $data_verified['data']['commentaire'];
            $obj_version->vue_json = base64_encode($vue_json);
            $id = $obj_version->save(false);

            if (!empty($obj_generateur_vue->id)) {
                $obj_generateur_vue->load_relationship('ops_generateur_version_ops_generateur_vue');
                $obj_generateur_vue->ops_generateur_version_ops_generateur_vue->add($id);
                if (!empty($id)) {
                    $data = array(
                        'statut' => 'ok',
                        'data' => array(
                            'id' => $id,
                            'version' => $obj_version->name,
                            'options' =>  $obj_version->getVersionOptions($obj_generateur_vue->id, "array"),
                            'message' => $obj_version->getVersionMessage($obj_generateur_vue->id, "array"),
                        ),
                    );
                } else {
                    $data['data'] = "Echéc de la création de l'onglet";
                }
            }
        } else {
            $data['data'] = $data_verified['data'];
        }

        //   $GLOBALS['log']->fatal(" action_addVersion :: data = ".print_r($data,true));

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * getOnglet()
     * Fonction qui retourne les données de l'onglet
     * 
     *
     */
    function getOnglet($id)
    {

        $onglet = false;

        if (!empty($id)) {
            $obj_onglet = new OPS_generateur_onglet;
            $obj_onglet->retrieve($id);
            if (!empty($obj_onglet->id)) {
                $onglet = array(
                    'name' => $obj_onglet->name,
                    'libelle' => $obj_onglet->libelle,
                    'cle' => $obj_onglet->cle,
                    'ordre' => $obj_onglet->ordre,
                );
            }
        }

        return $onglet;
    }

}
