<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class ViewImporter extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Generateur vue');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        $smarty = new Sugar_Smarty();
        $current_template = "modules/OPS_generateur_referentiel/tpls/importer.tpl";
        $this->importerJson();
        $smarty->display($current_template);
    }

    /**
     * @access private
     * @name importerJson()
     * Fonction qui 
     * 
     *  @param array            $xxxxx: xxxx
     *  @return string          $xxxx : xxxxx
     */
    function importerJson()
    {
        $generateur_referentiel = new OPS_generateur_referentiel();
        $champs_referentiel = $generateur_referentiel->getListReferentiel();
        $strJsonFileContents = file_get_contents("modules/OPS_generateur_vue/js/core.json");
        $retour_json_to_array = OdeArrayHelper::jsonToArray($strJsonFileContents);
        if ($retour_json_to_array['statut'] == "ok") {
            $tableau_champs_file = $retour_json_to_array['data'];
        }
        foreach ($tableau_champs_file as $key => $champ) {
            $search_path = OdeArrayHelper::searchForId($champ['name'], $champs_referentiel, array());
            if (!empty($search_path)) {
                $tab = explode("->", $search_path);
                $this->updateChampReferentiel($champs_referentiel[$tab[0]]['id'], $champ);
            } else {
                $this->createChampReferentiel($champ);
            }
        }
    }

    /**
     * @access private
     * @name createChampReferentiel()
     * Fonction qui crée des champs dans le réferentiel
     * 
     *  @param array            $champ: Tableau des données du champ à créer
     *  @return void   
     */
    private function createChampReferentiel($champ)
    {

        $obj_referentiel = new OPS_generateur_referentiel;
        $obj_referentiel->name = $champ['name'];
        $obj_referentiel->description = $champ['description'];
        $obj_referentiel->libelle = $champ['libelle'];
        $obj_referentiel->type = $champ['type'];
        $obj_referentiel->obligatoire = $champ['obligatoire'];
        $obj_referentiel->ineditable = $champ['ineditable'];
        $obj_referentiel->defaut = $champ['defaut'];
        $obj_referentiel->aide = $champ['aide'];
        $obj_referentiel->modifiable = $champ['modifiable'];
        $obj_referentiel->params = (is_array($champ['params']) && count($champ['params']) > 0) ? base64_encode(json_encode($champ['params'])) : base64_encode($champ['params']);
        $obj_referentiel->save();
    }

    /**
     * @access private
     * @name updateChampReferentiel()
     * Fonction qui met à jour un champ du réferentiel
     * 
     *  @param array            $champ: Tableau des données du champ à créer
     *  @return void   
     */
    private function updateChampReferentiel($id_champ_referentiel, $champ)
    {

        $obj_referentiel = new OPS_generateur_referentiel;
        $obj_referentiel->retrieve($id_champ_referentiel);
        if (!empty($obj_referentiel->id)) {
            if ($obj_referentiel->name == $champ['name']) {
                $obj_referentiel->description = $champ['description'];
                $obj_referentiel->libelle = $champ['libelle'];
                $obj_referentiel->type = $champ['type'];
                $obj_referentiel->obligatoire = $champ['obligatoire'];
                $obj_referentiel->ineditable = $champ['ineditable'];
                $obj_referentiel->defaut = $champ['defaut'];
                $obj_referentiel->aide = $champ['aide'];
                $obj_referentiel->modifiable = $champ['modifiable'];
                $obj_referentiel->params = (is_array($champ['params']) && count($champ['params']) > 0) ? base64_encode(json_encode($champ['params'])) : base64_encode($champ['params']);
                $obj_referentiel->save();
            }
        }
    }

    // $GLOBALS['log']->fatal(" updateChampReferentiel :: champ = ".print_r($champ,true));

}
