<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.edit.php');
use ODE\Model\GenerateurReferentielModel;

class OPS_generateur_formulaireViewEdit extends ViewEdit
{
    
    function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }
    
    public function preDisplay()
    {
        global $current_user;
        parent::preDisplay();
        $this->bean->author    = $current_user->name;
        $this->bean->user_id_c = $current_user->id;
    }
    
    function display()
    {
        global $mod_strings, $app_strings, $app_list_strings, $beanFiles, $current_user;
        
        echo '<link href="modules/OPS_generateur_formulaire/css/tiny.css" rel="stylesheet">';
        // Initialisation de la liste des objets
        $dropdown = '';
        foreach ($app_list_strings['base_module_object'] as $key => $value) {
                $dropdown .= "<option value='" . $key . "'>" . $value . "</option>";
        }
        
        $this->ss->assign("LIST_OBJECT", $dropdown);
        
        // Ajout des champs non présent dans le référentiel 
        $array_champs = $mod_strings['CHAMPS_SUPPLEMENTAIRE'];

        $array_champs_exclus = array('created_by','modified_user_id');

        $obj_dossier = new OPS_dossier(); 
        $mods_strings_dossier = return_module_language("fr", "OPS_dossier");
        
        $dossier_custom_fields = GenerateurReferentielModel::getCustomFieldListe();

        foreach( $obj_dossier->field_defs as $field ) {

            if( $field['type'] != "link"  && $field['type'] != "relate" && !in_array($field['name'], $array_champs_exclus)){

                if( !empty( $mod_strings[$field['vname']] ) || !empty( $mods_strings_dossier[$field['vname']] ) ){

                    if( !empty( $mod_strings[$field['vname']] ) ){
                        $array_champs[$field['name']] = html_entity_decode( $mod_strings[$field['vname']] , ENT_QUOTES , 'UTF-8') ;
                    }
                    else{
                        $array_champs[$field['name']] = html_entity_decode($mods_strings_dossier[$field['vname']], ENT_QUOTES , 'UTF-8') ;
                    }
                }
            }

        }  
        $all_champs = array_merge( $array_champs, $dossier_custom_fields);
        
        asort($all_champs);

        $this->ss->assign("LIST_REFERENTIEL",base64_encode(json_encode($all_champs)) );


        parent::display();
        $this->displayTMCE();
    }
    
    
    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;
        
        $tiny    = new SugarTinyMCE();
        $tinyMCE = '';// $tiny->getConfig();
        
        $js = <<<JS
        <!-- Customized Tiny -->
       <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        let wysiwyg_id = 'description';

        try{ 
            tinymce.execCommand('mceRemoveControl', true, wysiwyg_id);
        }
        catch(Exception){ /**/ }


        tinyMCE.init({
            theme : "advanced",
            theme_advanced_toolbar_align : "left",
            mode: "exact",
            elements : wysiwyg_id,
            theme_advanced_toolbar_location : "top",
            theme_advanced_buttons1: "code,separator,bold,italic,underline,strikethrough,separator,justifyleft,justifycenter,justifyright,justifyfull,separator,undo,redo,separator,forecolor,backcolor,separator,styleprops,styleselect,formatselect,fontselect,fontsizeselect,separator,insertdate,table,cell_props",
            theme_advanced_buttons2 : "",
            theme_advanced_buttons3 : "",
            theme_advanced_buttons3_add : "tablecontrols",
            theme_advanced_fonts:"Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Helvetica Neu=helveticaneue,sans-serif;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats",
            plugins : "advhr,insertdatetime,table,paste,searchreplace,directionality,style,",
            width: "100%",
            inline_styles : true,
            directionality : "ltr",
            entity_encoding: 'raw',
            cleanup_on_startup : true,
            strict_loading_mode : true,
            convert_urls : false,
            remove_redundant_brs : true,
            plugin_insertdate_dateFormat : '{DATE '+df+'}',
            extended_valid_elements : "textblock,barcode[*]",
            custom_elements: "textblock",
            content_css: "/modules/OPS_generateur_formulaire/css/cover.custom_content.css",

            table_col_limit : 2,
            table_row_limit : 15,
            table_default_styles: {},
            table_sizing_mode: 'auto',
            table_responsive_width: false,
            table_default_styles: { width: '', height: '', },

            /*
            table_styles : "Table flottante ¼=gru-dossier-cover-25;Table flottante ⅓=gru-dossier-cover-33;Table flottante ½=gru-dossier-cover-50;Table flottante ⅔=gru-dossier-cover-66;Table flottante ¾=gru-dossier-cover-75;Table flottante ⇿=gru-dossier-cover",
            /**/

            table_class_list: "Table flottante ¼=gru-dossier-cover-25;Table flottante ⅓=gru-dossier-cover-33;Table flottante ½=gru-dossier-cover-50;Table flottante ⅔=gru-dossier-cover-66;Table flottante ¾=gru-dossier-cover-75;Table flottante ⇿=gru-dossier-cover",
            table_cell_styles : "Section Dossier=dossier;Section Profil=profil;Section Demandeur=demandeur;Section Bénéficiaire=beneficiaire;Section Documents=documents;Section Justificatifs=justificatifs",

            /*table_inline_editing : true,/**/

        });
        </script>

JS;
        echo $js;
    }
}

?> 