<?php


class OPS_etape extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_etape';
    public $object_name = 'OPS_etape';
    public $table_name = 'ops_etape';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $etape_precedente;
    public $retour_arriere;
    public $ops_etape_id;
    public $ordre;
	
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    public function getListeStatuts() {

        $statuts = array();
        $tab_statuts = array();

        if ( !empty($this->id) ) {

            $liste_statuts = $this->get_linked_beans('ops_etape_ops_statut', 'OPS_statut', '', 0, -1, 0, "ops_statut.visible_agent = '1'");
            foreach ($liste_statuts as $statut) {
                $tab_statuts[$statut->ordre] = array(
                    "id" => $statut->id,
                    "name" => $statut->name
                );
            }

            ksort($tab_statuts);
            
            //Formatage du tableau 
            foreach ($tab_statuts as $status) {
                $statuts[$status['id']] = $status['name'];
            }

        }

        return $statuts;
    }
    
    public function getEtapeSuivante() {

        $etape_suivante = false;
        
        if ( !empty($this->id) ) {

            //Récupération du guide d'instruction de l'étape courante
            $liste_guides = $this->get_linked_beans('ops_guide_instruction_ops_etape', 'OPS_guide_instruction');
            $guide = ( is_array($liste_guides) && count($liste_guides) > 0 ) ? $liste_guides[0] : false;

            // Récupération de toutes les étapes du guide pour récupérer l'étape suivante
            $liste_etapes = ( $guide !== false ) ? $guide->get_linked_beans('ops_guide_instruction_ops_etape', 'OPS_etape') : array();
            foreach ( $liste_etapes as $etape ) {
                if ( $etape->ops_etape_id === $this->id ){
                    $etape_suivante = $etape;
                }
            }

        }

        return $etape_suivante;
    }

    static function html_modal()
    {
        $modale_html = '<link href="modules/OPS_etape/css/modal_instruction.css" rel="stylesheet" type="text/css">';
        $modale_html .= '<script type="text/javascript" charset="UTF-8" src="modules/OPS_etape/js/modal_instruction.js?='.time().'"></script>';
        $modale_html .= '<div id="modal-instruction-etape" class="modal" tabindex="-1" role="dialog">';
        $modale_html .=     '<div class="modal-dialog" style="max-width: 800px;">';
        $modale_html .=         '<div class="modal-content">';
        $modale_html .=             '<div class="modal-header">';
        $modale_html .=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modale_html .=                 '<h4 class="modal-title" id="titre-modal-instruction-etape">Aide à l\'instruction : <label style="font-weight: inherit;"></label></h4>';
        $modale_html .=                 '</button>';
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-instruction-etape-body" class="modal-body">';
        $modale_html .=             '</div>';
        $modale_html .=             '<div class="modal-footer">';
        $modale_html .=                 '<button type="button" class="button button-modal" data-dismiss="modal" id="annuler_modal">Fermer</button>';
        $modale_html .=             '</div>';
        $modale_html .=         '</div>';
        $modale_html .=     '</div>';
        $modale_html .= '</div>';

        return $modale_html;
    }

}