<?php

$dictionary['OPS_elu'] = array(
    'table' => 'ops_elu',
    'audited' => true,
    'inline_edit' => true,
    'duplicate_merge' => true,
    'fields' => array (

        'salutation' => array(
            'name' => 'salutation',
            'vname' => 'LBL_SALUTATION',
            'type' => 'enum',
            'options' => 'salutation_dom',
            'massupdate' => false,
            'len' => '255',
            'audited' => true,
        ),
        'first_name' => array(
            'name' => 'first_name',
            'vname' => 'LBL_FIRST_NAME',
            'type' => 'varchar',
            'len' => '100',
            'unified_search' => true,
            'full_text_search' => array('boost' => 3),
            'merge_filter' => 'selected',
            'audited' => true,
        ),
        'last_name' => array(
            'name' => 'last_name',
            'vname' => 'LBL_LAST_NAME',
            'type' => 'varchar',
            'len' => '100',
            'unified_search' => true,
            'full_text_search' => array('boost' => 3),
            'merge_filter' => 'selected',
            'required' => true,
            'importable' => 'required',
            'audited' => true,
        ),
        'nom_usage' => array(
            'required' => false,
            'name' => 'nom_usage',
            'vname' => 'LBL_NOM_USAGE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'lieu_naissance' => array(
            'required' => false,
            'name' => 'lieu_naissance',
            'vname' => 'LBL_LIEU_NAISSANCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'pays_naissance' => array(
            'required' => false,
            'name' => 'pays_naissance',
            'vname' => 'LBL_PAYS_NAISSANCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'date_naissance' => array(
            'required' => false,
            'name' => 'date_naissance',
            'vname' => 'LBL_DATE_NAISSANCE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'phone_home' => array(
            'name' => 'phone_home',
            'vname' => 'LBL_HOME_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
            'audited' => true,
        ),
        'phone_mobile' => array(
            'name' => 'phone_mobile',
            'vname' => 'LBL_MOBILE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
            'audited' => true,
        ),
        'phone_work' => array(
            'name' => 'phone_work',
            'vname' => 'LBL_OFFICE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'audited' => true,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
        ),
        'email'=>
        array(
             'name' => 'email',
             'type' => 'email',
             'query_type' => 'default',
             'source' => 'non-db',
             'operator' => 'subquery',
             'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
             'db_field' => array(
                     'id',
             ),
             'vname' =>'LBL_ANY_EMAIL',
             'studio' => array('visible'=>false, 'searchview'=>true),
             'importable' => false,
        ), 
        'email1' => 
        array(
            'name'      => 'email1',
            'vname'     => 'LBL_EMAIL_ADDRESS',
            'type'      => 'varchar',
            'unified_search' => true,
            'function'  => array(
                    'name'  => 'getEmailAddressWidget',
                    'returns'   => 'html'),
            'source'    => 'non-db',
            'group'=>'email1',
            'merge_filter' => 'enabled',
            'full_text_search' => array('boost' => 3, 'analyzer' => 'whitespace'), //bug 54567
            'audited' => true,
        ),
        'primary_address_number' => array(
            'name' => 'primary_address_number',
            'vname' => 'LBL_PRIMARY_ADDRESS_NUMBER',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'audited' => true,
        ),
        'primary_address_street' => array(
            'name' => 'primary_address_street',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'audited' => true
        ),
        'primary_address_postalcode' => array(
            'name' => 'primary_address_postalcode',
            'vname' => 'LBL_PRIMARY_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '10',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'massupdate' => true,
            'audited' => true
        ),
        'primary_address_city' => array(
            'name' => 'primary_address_city',
            'vname' => 'LBL_PRIMARY_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '30',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'massupdate' => true,
            'audited' => true
        ),
        'primary_address_complement_batiment' => array(
            'name' => 'primary_address_complement_batiment',
            'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_BATIMENT',
            'type' => 'varchar',
            'merge_filter' => 'enabled',
            'audited' => true,
            'len' => '100'
        ),
        'primary_address_complement_lieu' => array(
            'name' => 'primary_address_complement_lieu',
            'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_LIEU',
            'type' => 'varchar',
            'merge_filter' => 'enabled',
            'audited' => true,
            'len' => '100'
        ),
        'situation_familiale' => array(
            'required' => false,
            'name' => 'situation_familiale',
            'vname' => 'LBL_SITUATION_FAMILIALE',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_situation_familiale_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'nationalite' => array(
            'required' => false,
            'name' => 'nationalite',
            'vname' => 'LBL_NATIONALITE',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_nationalite_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'accepte_mail' => array(
            'required' => false,
            'name' => 'accepte_mail',
            'vname' => 'LBL_ACCEPTE_MAIL',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'accepte_sms' => array(
            'required' => false,
            'name' => 'accepte_sms',
            'vname' => 'LBL_ACCEPTE_SMS',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'lawful_basis' => array(
            'name' => 'lawful_basis',
            'vname' => 'LBL_LAWFUL_BASIS',
            'type' => 'multienum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'inline_edit' => true,
            'reportable' => true,
            'merge_filter' => 'enabled',
            'len' => 100,
            'size' => '20',
            'options' => 'lawful_basis_dom',
            'audited' => false,
            'importable' => true,
        ),
        'date_reviewed' => array(
            'name' => 'date_reviewed',
            'vname' => 'LBL_DATE_REVIEWED',
            'type' => 'date',
            'massupdate' => false,
            'audited' => false,
            'importable' => true,
        ),
        'lawful_basis_source' => array(
            'name' => 'lawful_basis_source',
            'vname' => 'LBL_LAWFUL_BASIS_SOURCE',
            'type' => 'enum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'inline_edit' => true,
            'reportable' => true,
            'merge_filter' => 'enabled',
            'len' => 100,
            'size' => '20',
            'options' => 'lawful_basis_source_dom',
            'audited' => false,
            'importable' => true,
        ),
        'do_not_call' => array(
            'name' => 'do_not_call',
            'vname' => 'LBL_DO_NOT_CALL',
            'type' => 'bool',
            'massupdate' => false,
            'default' => '0',
            'audited' => false,
        ),
        'assigned_user_id' => array(
            'name' => 'assigned_user_id',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_ID',
            'group' => 'assigned_user_name',
            'massupdate' => false,
            'type' => 'relate',
            'table' => 'users',
            'module' => 'Users',
            'reportable' => true,
            'isnull' => 'false',
            'dbType' => 'id',
            'audited' => false,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled'
        ),

      'actif' => 
      array (
        'required' => false,
        'name' => 'actif',
        'vname' => 'LBL_ACTIF',
        'type' => 'bool',
        'massupdate' => true,
        'default' => true,
        'no_default' => false,
        'comments' => '',
        'help' => '',
        'importable' => 'true',
        'duplicate_merge' => 'disabled',
        'duplicate_merge_dom_value' => '0',
        'audited' => false,
        'inline_edit' => true,
        'reportable' => true,
        'unified_search' => true,
        'merge_filter' => 'disabled',
        'len' => '255',
        'size' => '20',
      ),
    ),
    'relationships' => array (
),
    'optimistic_locking' => true,
    'unified_search' => true,
);
if (!class_exists('VardefManager')) {
        require_once('include/SugarObjects/VardefManager.php');
}
VardefManager::createVardef('OPS_elu', 'OPS_elu', array('basic','assignable','security_groups','person'));