<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Helper\OdeArrayHelper;

class ViewModifier extends SugarView
{

    private $dossier;

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Modifier dossier');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        $smarty = new Sugar_Smarty();
        $current_template = "modules/OPS_dossier/tpls/modifier.tpl";

        // Initialisation de la vue séléctionnée
        $this->dossier = new OPS_dossier;
        $this->dossier->retrieve($_REQUEST['id_dossier']);

        $smarty->assign("dossier_titre",  $this->dossier->name);
        $smarty->assign("dossier_id",  $this->dossier->id);

        $onglets = $this->dossier->getOnglets();

        // Génération des bouttons onglets 
        if ($onglets !== false) {
            // Initialisation des boutons onglets 
            $smarty->assign("BOUTONS_ONGLETS", $this->getInitBoutonsOnglets($onglets));
            // Initialisation des layout onglets 
            $smarty->assign("LAYOUTS_ONGLETS", $this->getInitLayoutsOnglets($onglets));
        }

        $smarty->display($current_template);
    }

    /**
     * @access private
     * @name getInitBoutonsOnglets()
     * Fonction qui génére les boutons d'onglets 
     * 
     *  @param array            $onglets : la liste des onglets rattaché à la vue
     *  @return string          $btn_onglets_html : code html , les boutons sont groupés dans une div
     */
    private function getInitBoutonsOnglets($onglets)
    {

        $btn_onglets_html = "";
        $count = 0;
        foreach ($onglets as $ordre => $onglet) {
            $btn_onglets_html .= '<div class="div_button_onglet" >';
            $btn_onglets_html .=    '<div role="onglet" id="btn_onglet_' . $onglet['id'] . '" title="' . $onglet['libelle'] . '" data-id="' . $onglet['id'] . '" data-libelle="' . $onglet['libelle'] . '" data-cle="' . $onglet['cle'] . '" onclick="displayOnglet(\'' . $onglet['id'] . '\')" ';
            $btn_onglets_html .=    ($count == 0) ? 'class="btn_onglet btn_onglet_selected" data-selected="1" >' : 'class="btn_onglet btn_onglet_not_selected" data-selected="0" >';
            $btn_onglets_html .=        '<div class="div_libelle_button_onglet" id="titre_onglet_' . $onglet['id'] . '">';
            $btn_onglets_html .=           $onglet['libelle'];
            $btn_onglets_html .=        '</div>';
            $btn_onglets_html .=    '</div>';
            $btn_onglets_html .= '</div>';
            $count++;
        }
        return $btn_onglets_html;
    }

    /**
     * @access private
     * @name getInitLayoutsOnglets()
     * Fonction qui génére les layouts d'onglets, en d'autre terme le container qui contient les lignes  
     * 
     *  @param array            $onglets : la liste des onglets rattaché à la vue
     *  @return string          $layout_onglets_html : code html , une div par layout, le premier est affiché par défaut
     */
    private function getInitLayoutsOnglets($onglets)
    {
        $layout_onglets_html = "";
        $count = 0;
        foreach ($onglets as $ordre => $onglet) {
            $layout_onglets_html .= '<div id="layout_onglet_' . $onglet['id'] . '" class="div_layout_onglet" ';
            if ($count == 0) {
                $layout_onglets_html .= 'style="display:block;" >';
            } else {
                $layout_onglets_html .= 'style="display:none;" >';
            }
            $layout_onglets_html .= $this->getLignesOnglet($onglet);
            $layout_onglets_html .= '</div>';
            $count++;
        }
        return $layout_onglets_html;
    }

    /**
     * @access private
     * @name getLignesOnglet()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string          $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLignesOnglet($onglet)
    {

        $lignes = '';
        if (is_array($onglet['champs']) && count($onglet['champs']) > 0) {
            foreach ($onglet['champs'] as $num_ligne => $ligne) {
                if (is_array($ligne)) {
                    ksort($ligne);
                }
                $lignes .= '<div class="row" style="background: white; margin: 0px; padding: 5px;">';
                foreach ($ligne as $pos => $champ) {
                    if ($this->isValidChamp($champ) === true) {
                        $lignes .= '<div id="champ_' . $champ['name'] . '" class="col-md-6 champ_referentiel champ_panel"';
                        $lignes .= ($champ['type'] != "relation") ? 'style="padding-right: 4%;">' : '>';
                        if ($champ['type'] != "vide") {
                            $lignes .= '<div id="titre_champ_' . $champ['name'] . '" style="white-space: initial; padding-top: 15px;"';
                            $lignes .= (!empty($champ['aide'])) ? 'title="' . $champ['aide'] . '"' : '';
                            $lignes .= 'class="col-md-4">' . $champ['libelle'] . ':';
                            $lignes .= ($champ['obligatoire'] == 1) ? '<span style="color:red;">*</span>' : '';
                            $lignes .= (!empty($champ['aide'])) ? ' <i class="fa fa-info-circle" style="color: #35B3C5;"></i>' : '';
                            if ($champ['type'] === "relation") {
                                $json_params = base64_decode($champ['params']);
                                $retour_json_to_array = OdeArrayHelper::jsonToArray($json_params);
                                if ($retour_json_to_array['statut'] == "ok") {
                                    $params = $retour_json_to_array['data'];
                                    if ($params['unique'] === "multi") {
                                        $lignes .= '<i class="fa fa-plus" style="background: #35B3C5;color: white;border-radius: 16px;padding: 4px;margin-left: 9px;cursor: pointer;" onclick="addLigneRelation(\'' . $champ['name'] . '\',\'' . $params['module_name'] . '\',\'' . $params['type'] . '\',\'' . $params['unique'] . '\',\'' . $params['condition'] . '\')"></i>';
                                    }
                                }
                            }
                            $lignes .= '<small style="color:red;display:none;">Message d\'erreur</small>';
                            $lignes .= '</div>';
                            $lignes .= $this->getChampHtml($champ);
                        }
                        $lignes .= '</div>';
                    }
                }
                $lignes .= '</div>';
            }
        }

        return $lignes;
    }

    /**
     * @access private
     * @name getChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string          $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getChampHtml($champ)
    {

        $html = false;
        $default_html = '<input type="text" value="Cas « ' . $champ['type'] . ' » non traité !" style="display: block;color: #f08377;background: #f8f8f8 !important;border: 1px solid red;" class="ode_input_hidden col-md-8" />';

        if ($champ['name'] == "thematique") {
            // Récupération du dispositif lié au dossier 
            $dispositifs = $this->dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
            $dispositif = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;
            $liste = (!empty($dispositif->id)) ? json_decode(base64_decode(OPS_dispositif::getListeThematique($dispositif->thematique)), true) : false;
            $required = ($champ['obligatoire'] == 1) ? 'required="true"' : '';
            $value = $this->dossier->thematique;
            if (is_array($liste) && count($liste) > 0) {
                $champ_thematique_html = '<select class="col-md-8" ' . $required . ' id="value_champ_' . $champ['name'] . '">';
                foreach ($liste as $index => $valeur) {
                    $selected = ($index == $value) ? " selected" : "";
                    $champ_thematique_html .= '<option value="' . $index . '"  ' . $selected . '>' . $valeur . '</option>';
                }
                $champ_thematique_html .= '</select>';
            }
            $html = (!empty($champ_thematique_html)) ? $champ_thematique_html : false;
        } else {
            $fieldFactory = new OdeFieldFactory($this->dossier, true);
            return $fieldFactory->getHtml($champ);
        }

        if ($html === false) {
            $GLOBALS['log']->fatal(" modules/OPS_dossier/views/view.modifier.php :: getChampHtml() => Erreur de récupération pour le champ " . $champ['name']);
        }

        return ($html !== false) ? $html : $default_html;
    }

    
    /**
     * @access private
     * @name isValidChamp()
     * Fonction qui vérifie si un champ est valide
     *
     *  @return boolean               - $valid : true si le champ est valide, false si le champ est vide ou incomplet 
     */
    private function isValidChamp($champ)
    {
        return (is_array($champ) && count($champ) > 0 && !empty($champ['name']) && !empty($champ['libelle']) && !empty($champ['type'])) ? true : false;
    }
}
