<?php
use ODE\CustomBlock\OdeCustomBlock;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');



class OPS_dossierViewGestion extends ViewList
{

    
    public function preDisplay() 
    { 
        $_REQUEST['orderBy'] = strtoupper('num_dossier');            
        $_REQUEST['sortOrder'] = 'DESC'; 
        parent::preDisplay(); 


    }

    /**
     * Display View
     */
    public function display()
    {

        global $current_user; 
        
        // Vérification si 'l'utilisateur a accès a la liste de dossiers 
        $req_where = $_SESSION['ops_requete_dossier'];
        if ( !$current_user->isAdmin() && $req_where == false ) 
        {
            SugarApplication::appendErrorMessage("Vous n'avez pas accès à cette zone, veuillez contacter votre administrateur");
            SugarApplication::redirect('index.php');

        }
        else
        {
            $this->listViewPrepare();

            $this->gestionColonnes();
            $this->listViewProcess();

            $this->gestionContainers();
        }
    }

    public function gestionContainers(){
        
        $customBlocks = new OdeCustomBlock($this->module, $this->action);
        $blocks = $customBlocks->getBlocks();
        foreach($blocks as $block){
            $smarty = new Sugar_Smarty();

            $styles= [];
            foreach($block['css'] as $css){
                $styles[] = $css;
            }

            $smarty->assign("STYLES", $styles);

            $scripts= [];
            foreach($block['js'] as $js){
                $scripts[] = $js;
            }


            $smarty->assign("SCRIPTS", $scripts);

            $contenu = [];
            foreach($block['php_controllers'] as $controller){
                $element = $controller->fetch();
                $contenu[] = $element;
            
                $smarty->assign("contenu", $contenu);
            }


            $smarty->display($block['tpl_container']);

        }

    }


    public function gestionColonnes(){
        // recuperation du dispositif id    
        $dispositifId = OPS_dossier::getParamRequestToArray("gestion_dossier", "REQUEST")['filtres_simples']['ops_dispositif_id']['valeurs'] ?? -1;
        if($dispositifId == -1) return;

        // recuperation des colonnes a afficher
        $beanDispositif = BeanFactory::getBean("OPS_dispositif", $dispositifId);
        if(empty($beanDispositif->colonnes_gestion_dossiers)) return;
        $choixColonnes = explode(",",$beanDispositif->colonnes_gestion_dossiers);

        // ce require va permettre de recuperer le parametrage exact des champs d'une vue liste
        require('modules/OPS_dossier/metadata/listviewdefs.php');
        // pour les customs eventuels
        if(file_exists('custom/modules/OPS_dossier/metadata/listviewdefs.php'))
            require('custom/modules/OPS_dossier/metadata/listviewdefs.php');




        
        $bean = BeanFactory::getBean('OPS_dossier');
        // pour verifier que la definition des champs existe
        $field_defs = $bean->getFieldDefinitions();
        $this->lv->displayColumns = [];

        foreach($choixColonnes as $col){
            $colUpperCase = strtoupper($col);
            if(!isset($field_defs[$col])) continue;
            if($col=="demandeur") $colUpperCase="OPS_INDIVIDU_OPS_DOSSIER_NAME";
            $data = $listViewDefs['OPS_dossier'][$colUpperCase] ?? -1;
            if($data==-1) continue;
            $this->lv->displayColumns[$colUpperCase] = $data;
        }


    }

}
