<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
    
    //ini_set('display_errors', '1');
class ViewChoix_demandeur extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Generateur vue');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        global $app_list_strings;

        $smarty = new Sugar_Smarty();
        $current_template = "modules/OPS_dossier/tpls/choix_demandeur.tpl";

        if (!empty($_REQUEST["demandeur_id"]) && !empty($_REQUEST["demandeur_type"]) && !empty($_REQUEST["dispositif_id"])) {
            SugarApplication::redirect("index.php?module=OPS_dossier&action=create&dispositif_id=" . $_REQUEST["dispositif_id"] . "&demandeur_id=" . $_REQUEST["demandeur_id"] . "&demandeur_type=" . $_REQUEST["demandeur_type"]);
        }

        if (!empty($_REQUEST["dispositif_id"])) {
            $smarty->assign('dispositif_id', $_REQUEST["dispositif_id"]);
        }

        $objDispositif = BeanFactory::getBean('OPS_dispositif', $_REQUEST["dispositif_id"]);

        if($objDispositif->anonyme){
            $typeDemandeur = 'OPS_individu';
            $objIndividu = BeanFactory::getBean('OPS_individu',$objDispositif->ops_individu_anonyme_id);
            if(!empty($objIndividu->id)){
                $anonyme = $objIndividu->id;
            }else{
                $smarty->assign('erreur_anonyme', "Le demandeur anonyme n'a pas été trouvé");
            }
        }

        if (!empty($_REQUEST["dispositif_id"]) && !empty($typeDemandeur) && !empty($anonyme)) {
            SugarApplication::redirect("index.php?module=OPS_dossier&action=create&dispositif_id=" . $_REQUEST["dispositif_id"] . "&demandeur_id=" . $anonyme . "&demandeur_type=" . $typeDemandeur);
        }
        
        $personne_morale_type = false;
        $individu_type = false;
        
        $individu        = boolval(intval($objDispositif->individu));
        $personne_morale = boolval(intval($objDispositif->personne_morale));

        $type_beneficiare = [];
        if($individu)
        {
            $type_beneficiare[] = 'individu';
        }

        if($personne_morale)
        {
            $type_beneficiare[] = 'personne_morale';
        }

        $type_individu = str_replace('^', "", $objDispositif->type_beneficiaire);


        $type_tier = explode(',',str_replace('^','',$objDispositif->type_tier));


        $disposifiParam = array(
            'type_beneficiare' => $type_beneficiare,
            'type_individu'    => $type_individu,
            'type_tier'        => $type_tier,
            'beneficiaire'     => $objDispositif->beneficiaire,
            'dispositif_id'    => $_REQUEST["dispositif_id"],
        );

        $liste_type_profil = array(); 
        if($personne_morale)
        {
            $where = "ops_type_personne.id IN (" . str_replace('^', '\'', $objDispositif->type_tier) . ")";
            $array_type = get_bean_select_array(true, 'OPS_type_personne', "name", $where, 'name');
            $select_list_type = get_select_options_with_id($array_type, '');
            $personne_morale_type = true;
    
            $i = 0 ; 

            $visible_siret = false ; 
            $visible_rna = false ; 
            $visible_rne = false ; 
            
            foreach ($type_tier as $key => $type_profil) {
                    
                $obj_type_profil = BeanFactory::getBean('OPS_type_personne', $type_profil);

                if( !empty($obj_type_profil->id) ){

                    array_push($liste_type_profil,  $obj_type_profil->name  );

                    if( $obj_type_profil->siret != "hidden" ){
                        $visible_siret = true;
                    }

                    if( $obj_type_profil->numero_rna != "hidden" ){
                        $visible_rna = true;
                    }

                    if( $obj_type_profil->numero_rne != "hidden" ){
                        $visible_rne = true;
                    }
                }
            }
        }

        if($individu)
        {
            $individu_type = true;
            array_push($liste_type_profil, "Particulier");
        }

        $optionTypeIndividu = '';
        $optionSalutation = '';
        $optionSexe = '';

        foreach ($app_list_strings['ops_type_individu_list'] as $key => $value) {
            $optionTypeIndividu .= '<option value="'.$key.'">'.$value.'</option>';
        }
        
        foreach ($app_list_strings['salutation_dom'] as $key => $value) {
            $optionSalutation .= '<option value="'.$key.'">'.$value.'</option>';
        }

        foreach ($app_list_strings['ops_sexe_list'] as $key => $value) {
            $optionSexe .= '<option value="'.$key.'">'.$value.'</option>';
        }

        sort($liste_type_profil);
        $profils_eligibles = implode(", ", $liste_type_profil);
        $smarty->assign('disposifiParam',base64_encode(json_encode($disposifiParam)));
        $smarty->assign('select_list_type', $select_list_type);
        $smarty->assign('liste_type_profil', $profils_eligibles);
        $smarty->assign('beneficiaire', boolval(intval($objDispositif->beneficiaire)));
        $smarty->assign('type_individu', $type_individu);
        $smarty->assign('personne_morale', $personne_morale_type);
        $smarty->assign('individu', $individu_type);
        $smarty->assign('dispositif_name', $objDispositif->name);

        $smarty->assign('visible_siret', $visible_siret);
        $smarty->assign('visible_rna', $visible_rna);
        $smarty->assign('visible_rne', $visible_rne);

        $smarty->assign('optionSalutation', $optionSalutation);
        $smarty->assign('optionSexe', $optionSexe);
        $smarty->assign('optionTypeIndividu', $optionTypeIndividu);

        $smarty->display($current_template); 
    }

}