String.prototype.b64ToUtf8 = function() {
    return decodeURIComponent(escape(window.atob( this )));
};

if (!Object.prototype.forEach) {
    Object.defineProperty(Object.prototype, 'forEachCondition', {
        value: function (callback, thisArg) {
            if (this == null) {
                throw new TypeError('Not an object');
            }
            thisArg = thisArg || window;
            for (var key in this) {
                if (this.hasOwnProperty(key)) {
                    callback.call(thisArg, this[key], key, this);
                }
            }
        }
    });
}

Object.defineProperties(Array.prototype, {
    count: {
        value: function(query) {
            var count = 0;
            for(let i=0; i<this.length; i++)
                if (this[i]==query)
                    count++;
            return count;
        }
    }
});

var OdeCondition = (function ($) {

    var CONDITIONS = {};
    var EXECUTEONGLET = {};
    var URLS = URL;

    return {
        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        init: function() {
         
            const self = this;
            var params = (new URLS(document.location)).searchParams;
            var action = params.get('action');
            var noOnglet = params.get('onglet');
            var ongletId = '';

            const actionStatut = $('#action_statut_onglet').children();

            CONDITIONS = ($('#conditions').val())?JSON.parse(atob($('#conditions').val())):'';

            if(noOnglet !== null && noOnglet > 0){
                var ongletActif = $('#onglet-boutons li a:visible')[noOnglet - 1];
                ongletId = ($(ongletActif).attr('id') && $(ongletActif).attr('id').length > 0)?$(ongletActif).attr('id').split('_'):'';
            }else{
                var ongletActif = $('#onglet-boutons li a:visible')[0];
                ongletId = ($(ongletActif).attr('id') && $(ongletActif).attr('id').length > 0)?$(ongletActif).attr('id').split('_'):'';
            }

            $.each(CONDITIONS, function(indexOnglet, element) {
                $.each(element, function(indexChamp, champ) {
                    if(champ !== false && !champ.type_profil){
                        if(action == "EditView" || action == "create")
                        {
                            if ($(`[data-name=${indexChamp}]`).attr('data-type-field') == 'checkboxmulti')
                            {
                                var id = $(`[data-name=${indexChamp}]`).attr('id');
                                var container = $('#' + id + '_container');
                                $(container).find('input[type=checkbox]').on('change' , function(event) {
                                    self.executeConditions(indexChamp,false,indexOnglet);
                                } );
                            }
                            else
                            {
                                $(`[data-name=${indexChamp}]`).on('change focus blur paste' , function(event) {
                                    self.executeConditions(indexChamp,false,indexOnglet);
                                } ).on( 'keypress' , function(event) {
                                    if (event.keyCode == '13' ) { 
                                        self.executeConditions(indexChamp,false,indexOnglet); 
                                    }
                                } );
                            }
                        }
                        if(indexOnglet === ongletId[1] && ongletId[1].length > 0){
                            self.executeConditions(indexChamp,false,indexOnglet); 
                            EXECUTEONGLET[indexOnglet] = true;
                        }
                    }else if ( champ !== false && champ.type_profil ){
                        self.executeConditions(indexChamp,true,indexOnglet);
                    }
                });
                
                $("#bouton_"+indexOnglet).parent().click(function(){
                    var tabId = $(this).children().attr('id').split('_');
                    if(tabId[1] && tabId[1].length > 0 && EXECUTEONGLET.hasOwnProperty(tabId[1]) === false){
                        $.each(CONDITIONS[tabId[1]], function(indexChamp, champ) {
                            var flagProfil = (champ.type_profil)?true:false;
                            self.executeConditions(indexChamp,flagProfil,tabId[1]); 
                        });
                        EXECUTEONGLET[tabId[1]] = true;
                    }
                });
            });
            const onglets = this.getOnglets();
            onglets.forEachCondition(function ( data, onglet_id ) {
                if ( data !== false && data.conditions.length > 0 ) {
                    var onglet = $(`#${onglet_id}`);
                    data.conditions.forEachCondition(function ( condition ) {

                        if ( CONDITIONS.hasOwnProperty(condition.champ) === false ) {
                            CONDITIONS[condition.champ] = [];
                        }
                        CONDITIONS[condition.champ].push({ onglet: onglet, data: data});
         
                        if(action == "EditView" || action == "create"){
                            $(`[data-name=${condition.champ}]`).on('change focus blur paste' , function(event) {
                                self.executeConditions(condition.champ);
                            } ).on( 'keypress' , function(event) {
                                if (event.keyCode == '13' ) { 
                                    self.executeConditions(condition.champ); 
                                }
                            } );
                        }
                        self.executeConditions(condition.champ);
                    });
                }else if ( data !== false && data.type_profil && data.type_profil.length > 0 && $("#ops_type_personne").val() != '' ){
                    var onglet = $(`#${onglet_id}`);
                    var id = 'type_profil_'+onglet_id;
                    if ( CONDITIONS.hasOwnProperty('type_profil') === false ) {
                        CONDITIONS[id] = [];
                    }
                    CONDITIONS[id].push({ onglet: onglet, data: data});
                    self.executeConditions(id,true);
                }
            });

            if(actionStatut.length > 0){
                self.executeAction(actionStatut);
            }

            $('.visible_modifiable_onglet').each(function(){
                if ($(this).attr('done') != 'done') {
                    self.executeAction($(this));
                }
            });
        },

        /**
         * Fonction qui execute les condtions des champs pas encore lancé
         * 
         * @return {void} 
        */
        executeConditionsChamp: function() {
            var ongletConditions = ($('#conditions').val())?JSON.parse(atob($('#conditions').val())):'';
            $.each(ongletConditions, function(indexOnglet, element) {
                if(EXECUTEONGLET.hasOwnProperty(indexOnglet) === false){
                    $.each(CONDITIONS[indexOnglet], function(indexChamp, champ) {
                        OdeCondition.executeConditions(indexChamp,false,indexOnglet); 
                    });
                }
            });
        },

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        removeDisabledChamp: function( champ ) {
            console.log("removeDisabledChamp:: champ = ", champ);
            champ.removeAttr("disabled");
            champ.css("background","#c3e7fd");
        },

        executeConditions: function( id, type_profil = false, onglet_id = "" ) {
            const self = this;
            if ( CONDITIONS.hasOwnProperty(id) || ($.trim(onglet_id) && CONDITIONS[onglet_id].hasOwnProperty(id)) ) {

                var conditionTab = ($.trim(onglet_id) && CONDITIONS[onglet_id].hasOwnProperty(id))?CONDITIONS[onglet_id][id]:CONDITIONS[id];

                conditionTab.forEachCondition(function ( field_data ) {

                    if(typeof field_data === "object"){
                        var conditions = field_data.data.conditions;
                        var verifications = [];
                        var execute = false;

                        if(!type_profil){
                            conditions.forEachCondition(function ( condition ) {

                                var champ_value = (condition.champ === "ops_statut_id") ? $("#ops_statut_id").val() : self.getValue($(`[data-name=${condition.champ}]`));

                                if($(`[data-name=${condition.champ}]`).attr('data-champ-condition')){
                                    var champ_condition = $(`[data-name=${condition.champ}]`).attr('data-champ-condition');
                                    champ_value = self.getValue($(`[data-name=${champ_condition}]`));
                                }

                                switch (condition.operator) {
                                    case ">":
                                        if( $(`[data-name=${condition.champ}]`).get(0) !== undefined && (($(`[data-name=${condition.champ}]`).get(0).tagName === "SELECT" && $(`[data-name=${condition.champ}]`).get(0).multiple) || $(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti') ){
                                           let champs_list = [];
                                            if($(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti'){
                                                champs_list =  champ_value.replaceAll('^', '').split(',');
                                            }else{
                                                if(Array.isArray(champ_value)){
                                                    champs_list = champ_value;
                                                }else{
                                                    champs_list.push(champ_value);
                                                }
                                            }

                                            let is_valid_condition = false;
                                            for (let i = 0; i < champs_list.length; i++){
                                                if(champs_list[i] !== "" && champs_list[i] > condition.value){
                                                    is_valid_condition = true;
                                                    return false;
                                                }
                                            }
                                            verifications.push(is_valid_condition);
                                        }else{
                                            if(typeof champ_value !== 'number' && champ_value !== undefined){
                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== ""){
                                                    champ_value = champ_value.replaceAll($(`[data-name=${condition.champ}]`).attr('data-separateur'), "");
                                                }else{
                                                    champ_value = champ_value.replaceAll(" ", "");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal'), ".");
                                                }else{
                                                    champ_value = champ_value.replace(",", ".");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-currency') !== null && $(`[data-name=${condition.champ}]`).attr('data-currency') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-currency') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-currency'), "");
                                                }else{
                                                    champ_value = champ_value.replace("€", "");
                                                }
                                            }
                                            ( parseFloat(champ_value) > parseFloat(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                        }
                                        break;
                                    case ">=":
                                        if( $(`[data-name=${condition.champ}]`).get(0) !== undefined && (($(`[data-name=${condition.champ}]`).get(0).tagName === "SELECT" && $(`[data-name=${condition.champ}]`).get(0).multiple) || $(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti')){
                                            let champs_list = [];
                                            if($(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti'){
                                                champs_list =  champ_value.replaceAll('^', '').split(',');
                                            }else{
                                                if(Array.isArray(champ_value)){
                                                    champs_list = champ_value;
                                                }else{
                                                    champs_list.push(champ_value);
                                                }
                                            }

                                            let is_valid_condition = false;
                                            for (let i = 0; i < champs_list.length; i++){
                                                if(champs_list[i] !== "" && champs_list[i] >= condition.value){
                                                    is_valid_condition = true;
                                                    return false;
                                                }
                                            }
                                            verifications.push(is_valid_condition);
                                        }else{
                                            if(typeof champ_value !== 'number' && champ_value !== undefined){
                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== ""){
                                                    champ_value = champ_value.replaceAll($(`[data-name=${condition.champ}]`).attr('data-separateur'), "");
                                                }else{
                                                    champ_value = champ_value.replaceAll(" ", "");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal'), ".");
                                                }else{
                                                    champ_value = champ_value.replace(",", ".");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-currency') !== null && $(`[data-name=${condition.champ}]`).attr('data-currency') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-currency') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-currency'), "");
                                                }else{
                                                    champ_value = champ_value.replace("€", "");
                                                }
                                            }
                                            ( parseFloat(champ_value) >= parseFloat(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                        }
                                        break;
                                    case "=":
                                        if($(`[data-name=${condition.champ}]`).get(0) !== undefined && ($(`[data-name=${condition.champ}]`).get(0).tagName === "SELECT" || $(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti') ){
                                            let champs_list = [];
                                            if($(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti'){
                                                champs_list = champ_value.replaceAll('^', '').split(',');
                                            }else{
                                                if(Array.isArray(champ_value)){
                                                    champs_list = champ_value;
                                                }else{
                                                    champs_list.push(champ_value);
                                                }
                                            }

                                            let is_valid_condition = false;
                                            for (let i = 0; i < champs_list.length; i++){
                                                if(champs_list[i] !== "" && champs_list[i] == condition.value) 
                                                {
                                                    is_valid_condition = true;
                                                    return false;
                                                }
                                            }
                                            verifications.push(is_valid_condition);
                                        }else if($(`[data-name=${condition.champ}]`).attr('type') === "number" || $(`[data-name=${condition.champ}]`).attr('data-type') === "number"){
                                            if(typeof champ_value !== 'number' && champ_value !== undefined){
                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== ""){
                                                    champ_value = champ_value.replaceAll($(`[data-name=${condition.champ}]`).attr('data-separateur'), "");
                                                }else{
                                                    champ_value = champ_value.replaceAll(" ", "");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal'), ".");
                                                }else{
                                                    champ_value = champ_value.replace(",", ".");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-currency') !== null && $(`[data-name=${condition.champ}]`).attr('data-currency') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-currency') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-currency'), "");
                                                }else{
                                                    champ_value = champ_value.replace("€", "");
                                                }
                                            }
                                            ( parseFloat(champ_value) == parseFloat(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                        }else{
                                            // Permet aux checkboxs d'accepter la valeur "1" ou "true"
                                            if($(`[data-name=${condition.champ}]`).attr('type') == 'checkbox')
                                            {
                                                if( String(champ_value) == String(condition.value) ) {
                                                    verifications.push(true);
                                                }
                                                else if ( (String(condition.value) == '1' || String(condition.value) == 'true') && (String(champ_value) == '1' || String(champ_value) == 'true')) {
                                                    verifications.push(true);
                                                }
                                                else
                                                {
                                                    verifications.push(false);
                                                }
                                            }
                                            else
                                            {
                                                ( String(champ_value) == String(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                            }
                                        }
                                        break;
                                    case "<":
                                        if( $(`[data-name=${condition.champ}]`).get(0) !== undefined && (($(`[data-name=${condition.champ}]`).get(0).tagName === "SELECT" && $(`[data-name=${condition.champ}]`).get(0).multiple) || $(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti')){
                                            let champs_list = [];
                                            if($(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti'){
                                                champs_list =  champ_value.replaceAll('^', '').split(',');
                                            }else{
                                                if(Array.isArray(champ_value)){
                                                    champs_list = champ_value;
                                                }else{
                                                    champs_list.push(champ_value);
                                                }
                                            }

                                            let is_valid_condition = false;
                                            for (let i = 0; i < champs_list.length; i++){
                                                if(champs_list[i] !== "" && champs_list[i] < condition.value){
                                                    is_valid_condition = true;
                                                    return false;
                                                }
                                            }
                                            verifications.push(is_valid_condition);
                                        }else{
                                            if(typeof champ_value !== 'number' && champ_value !== undefined){
                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== ""){
                                                    champ_value = champ_value.replaceAll($(`[data-name=${condition.champ}]`).attr('data-separateur'), "");
                                                }else{
                                                    champ_value = champ_value.replaceAll(" ", "");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal'), ".");
                                                }else{
                                                    champ_value = champ_value.replace(",", ".");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-currency') !== null && $(`[data-name=${condition.champ}]`).attr('data-currency') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-currency') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-currency'), "");
                                                }else{
                                                    champ_value = champ_value.replace("€", "");
                                                }
                                            }
                                            ( parseFloat(champ_value) < parseFloat(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                        }
                                        break;
                                    case "<=":
                                        if( $(`[data-name=${condition.champ}]`).get(0) !== undefined && (($(`[data-name=${condition.champ}]`).get(0).tagName === "SELECT" && $(`[data-name=${condition.champ}]`).get(0).multiple) || $(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti')){
                                            let champs_list = [];
                                            if($(`[data-name=${condition.champ}]`).attr('data-type-field') == 'checkboxmulti'){
                                                champs_list =  champ_value.replaceAll('^', '').split(',');
                                            }else{
                                                if(Array.isArray(champ_value)){
                                                    champs_list = champ_value;
                                                }else{
                                                    champs_list.push(champ_value);
                                                }
                                            }

                                            let is_valid_condition = false;
                                            for (let i = 0; i < champs_list.length; i++){
                                                if(champs_list[i] !== "" && champs_list[i] <= condition.value){
                                                    is_valid_condition = true;
                                                    return false;
                                                }
                                            }
                                            verifications.push(is_valid_condition);
                                        }else{
                                            if(typeof champ_value !== 'number' && champ_value !== undefined){
                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur') !== ""){
                                                    champ_value = champ_value.replaceAll($(`[data-name=${condition.champ}]`).attr('data-separateur'), "");
                                                }else{
                                                    champ_value = champ_value.replaceAll(" ", "");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== null && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-separateur-decimal') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-separateur-decimal'), ".");
                                                }else{
                                                    champ_value = champ_value.replace(",", ".");
                                                }

                                                if($(`[data-name=${condition.champ}]`).attr('data-currency') !== null && $(`[data-name=${condition.champ}]`).attr('data-currency') !== undefined && $(`[data-name=${condition.champ}]`).attr('data-currency') !== ""){
                                                    champ_value = champ_value.replace($(`[data-name=${condition.champ}]`).attr('data-currency'), "");
                                                }else{
                                                    champ_value = champ_value.replace("€", "");
                                                }
                                            }
                                            ( parseFloat(champ_value) <= parseFloat(condition.value) ) ? verifications.push(true) : verifications.push(false);
                                        }
                                        break;
                                }
                            });
                        }

                        var verified = field_data.data.verified;
                        var visible = field_data.data.visible;
        
                        if ( verified === "all" && !type_profil) {
                            var execute = ( verifications.length === verifications.count(true)) ? true : false;
                        } else if ( verified === "one" && !type_profil){
                            var execute = ( verifications.count(true) > 0) ? true : false;
                        }else if(type_profil && field_data.data.type_profil != undefined && $("#ops_type_personne").val() != ''){
                            isTypePersonne = false;
                            $.each(field_data.data.type_profil, function(key, tab) {
                                $.each(tab, function(id, value) {
                                    if(id == $("#ops_type_personne").val() ){
                                        isTypePersonne = true;
                                        return false;
                                    } 
                                });
                            });
                            if(isTypePersonne){
                                verified = 1;
                                visible = 1;
                            }else{
                                verified = 0;
                                visible = 0;
                            }
                            var execute = true;
                        }

                        var params = (new URLS(document.location)).searchParams;
                        var action = params.get('action');
                        if ( field_data.hasOwnProperty("champ") ) {
                            var modifiable =  field_data.data.modifiable;
                            field_data.champ = ($.trim(onglet_id) && typeof field_data.champ === 'string')?$('[data-name="' + field_data.champ + '"]'):field_data.champ;
                            if((field_data.champ.length === 1 && field_data.champ.attr("data-unique") === undefined) || field_data.champ.attr("type") == 'file'){
                                var champ = field_data.champ;
                                if($(champ).attr('rel') == 'section'){
                                    if ( execute === true ) {
                                        if( visible === 1 ){
                                            $(champ).show();
                                        }else{
                                            $(champ).hide();
                                        }
                                    } else {
                                        if( visible === 1 ){
                                            $(champ).hide();
                                        }else{
                                            $(champ).show();
                                        }
                                    }
                                }
                                else if ( execute !== undefined ) {
                                    if ( execute === true ) {
                                        if( visible === 1 ){
                                            champ.parent().parent().show()
                                            champ.parent().parent().addClass("d-flex");
                                            if(champ.attr('data-required') == 'required'){
                                                champ.prop("required", "required");
                                                champ.removeAttr('data-required');
                                            }
                                            champ.removeAttr('data-visible');

                                            if(champ.attr('type') == 'hidden')
                                            {
                                                $(champ.parent().find('input')).each(function() {
                                                    $(this).removeAttr('data-visible', 'masque');
                                                });
                                            }
                                        }else{
                                            champ.parent().parent().hide(); 
                                            champ.parent().parent().removeClass("d-flex");
                                            if(champ.attr('required') == 'required'){
                                                champ.removeAttr("required");
                                                champ.attr('data-required', 'required');
                                            }
                                            champ.attr('data-visible', 'masque');

                                            if(champ.attr('type') == 'hidden')
                                            {
                                                $(champ.parent().find('input')).each(function() {
                                                    $(this).attr('data-visible', 'masque');
                                                });
                                            }
                                        }
                                        if ( champ.attr("data-disabled") !== "oui" && (action == "EditView" || action == "create") ) {
                                            ( modifiable === 1 ) ? champ.removeAttr("disabled") : champ.prop("disabled","disabled");
                                        }
                                    } else {
                                        if( visible === 1 ){
                                            champ.parent().parent().hide(); 
                                            champ.parent().parent().removeClass("d-flex");
                                            if(champ.attr('required') == 'required'){
                                                champ.removeAttr("required");
                                                champ.attr('data-required', 'required');
                                            }
                                            champ.attr('data-visible', 'masque');

                                            if(champ.attr('type') == 'hidden')
                                            {
                                                $(champ.parent().find('input')).each(function() {
                                                    $(this).attr('data-visible', 'masque');
                                                });
                                            }
                                        }else{
                                            champ.parent().parent().show();
                                            champ.parent().parent().addClass("d-flex");
                                            if(champ.attr('data-required') == 'required'){
                                                champ.prop("required", "required");
                                                champ.removeAttr('data-required');
                                            }
                                            champ.removeAttr('data-visible');

                                            if(champ.attr('type') == 'hidden')
                                            {
                                                $(champ.parent().find('input')).each(function() {
                                                    $(this).removeAttr('data-visible', 'masque');
                                                });
                                            }
                                        }
                                        if(action == "EditView" || action == "create"){
                                            if ( champ.attr("data-disabled") !== "oui" ) {
                                                ( modifiable === 1 ) ? champ.prop("disabled","disabled") : champ.removeAttr("disabled");
                                            }
                                        }
                                    }
                                }
                            }else if (field_data.champ.attr("data-unique") !== undefined) {
                                var champ = field_data.champ;
                                    if ( execute !== undefined ) {
                                        if ( execute === true ) {
                                            if( visible === 1 ){
                                                champ.parent().show();
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');
                                            }else{
                                                champ.parent().hide(); 
                                                champ.parent().removeClass("d-flex");
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');
                                            }
                                            if ( champ.attr("data-disabled") !== "oui" && (action == "EditView" || action == "create") ) {
                                                var button = $(`[data-name=${champ.attr("data-name")}]`).parent().find("button");
                                                ( modifiable === 1 ) ? button.removeAttr("disabled") : button.prop("disabled","disabled");
                                                (field_data.champ.attr("data-unique") == "multi" && modifiable === 0 && (action == "EditView" || action == "create"))? champ.parent().find('i').hide(): champ.parent().find('i').show();
                                            }
                                        }else {
                                            if( visible === 1 ){
                                                champ.parent().hide(); 
                                                champ.parent().removeClass("d-flex");
                                                champ.parent().find('i').hide();
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');
                                            }else{
                                                champ.parent().show();
                                                champ.parent().find('i').show();
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');
                                            }
                                            if(action == "EditView" || action == "create"){
                                                if ( champ.attr("data-disabled") !== "oui" ) {
                                                    var button = $(`[data-name=${champ.attr("data-name")}]`).parent().find("button");
                                                    ( modifiable === 1 ) ? button.prop("disabled","disabled") : button.removeAttr("disabled");
                                                }
                                            }
                                        }
                                    }
                            }
                            else if(field_data.champ.length > 1 && ($(field_data.champ[0]).is("select") === true || $(field_data.champ[0]).is("text") === true) ){
                                for( i = 0; i < field_data.champ.length; i++ ){
                                    var champ = $(field_data.champ[i]);
                                    if($(champ).attr('rel') == 'section'){
                                        if ( execute === true ) {
                                            if( visible === 1 ){
                                                $(champ).show();
                                            }else{
                                                $(champ).hide();
                                            }
                                        } else {
                                            if( visible === 1 ){
                                                $(champ).hide();
                                            }else{
                                                $(champ).show();
                                            }
                                        }
                                    }
                                    else if ( execute !== undefined ) {
                                        if ( execute === true ) {
                                            if( visible === 1 ){
                                                champ.parent().parent().show()
                                                champ.parent().parent().addClass("d-flex");
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');

                                                if(champ.attr('type') == 'hidden')
                                                {
                                                    $(champ.parent().find('input')).each(function() {
                                                        $(this).removeAttr('data-visible', 'masque');
                                                    });
                                                }
                                            }else{
                                                champ.parent().parent().hide(); 
                                                champ.parent().parent().removeClass("d-flex");
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');

                                                if(champ.attr('type') == 'hidden')
                                                {
                                                    $(champ.parent().find('input')).each(function() {
                                                        $(this).attr('data-visible', 'masque');
                                                    });
                                                }
                                            }
                                            if ( champ.attr("data-disabled") !== "oui" && (action == "EditView" || action == "create") ) {
                                                ( modifiable === 1 && i == 0) ? champ.removeAttr("disabled") : champ.prop("disabled","disabled");
                                            }
                                        } else {
                                            if( visible === 1 ){
                                                champ.parent().parent().hide(); 
                                                champ.parent().parent().removeClass("d-flex");
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');

                                                if(champ.attr('type') == 'hidden')
                                                {
                                                    $(champ.parent().find('input')).each(function() {
                                                        $(this).attr('data-visible', 'masque');
                                                    });
                                                }
                                            }else{
                                                champ.parent().parent().show();
                                                champ.parent().parent().addClass("d-flex");
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');

                                                if(champ.attr('type') == 'hidden')
                                                {
                                                    $(champ.parent().find('input')).each(function() {
                                                        $(this).removeAttr('data-visible', 'masque');
                                                    });
                                                }
                                            }
                                            if(action == "EditView" || action == "create"){
                                                if ( champ.attr("data-disabled") !== "oui" ) {
                                                    ( modifiable === 1 ) ? champ.prop("disabled","disabled") : champ.removeAttr("disabled");
                                                }
                                            }
                                        }
                                    }
                                }
                            }else{
                                for( i = 0; i < field_data.champ.length; i++ ){
                                    var champ = $(`#${field_data.champ[i].id}`);
                                    if ( execute !== undefined ) {
                                        if ( execute === true ) {
                                            if( visible === 1 ){
                                                champ.parent().parent().parent().show()
                                                champ.parent().parent().parent().addClass("d-flex");
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');
                                            }else{
                                                champ.parent().parent().parent().hide(); 
                                                champ.parent().parent().parent().removeClass("d-flex");
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');
                                            }
                                            if ( champ.attr("data-disabled") !== "oui" && (action == "EditView" || action == "create") ) {
                                                ( modifiable === 1 ) ? champ.removeAttr("disabled") : champ.prop("disabled","disabled");
                                            }
                                        } else {
                                            if( visible === 1 ){
                                                champ.parent().parent().parent().hide(); 
                                                champ.parent().parent().parent().removeClass("d-flex");
                                                if(champ.attr('required') == 'required'){
                                                    champ.removeAttr("required");
                                                    champ.attr('data-required', 'required');
                                                }
                                                champ.attr('data-visible', 'masque');
                                            }else{
                                                champ.parent().parent().parent().show();
                                                champ.parent().parent().parent().addClass("d-flex");
                                                if(champ.attr('data-required') == 'required'){
                                                    champ.prop("required", "required");
                                                    champ.removeAttr('data-required');
                                                }
                                                champ.removeAttr('data-visible');
                                            }
                                            if(action == "EditView" || action == "create"){
                                                if ( champ.attr("data-disabled") !== "oui" ) {
                                                ( modifiable === 1 ) ? champ.prop("disabled","disabled") : champ.removeAttr("disabled");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            var onglet = field_data.onglet;
                            var modifiable =  field_data.data.modifiable;
                            var bouton = onglet.attr("id").replace('onglet', 'bouton');
                            var champs = self.getChampsByid(onglet.attr("id"));
                            if( ( execute === true && visible === 1 ) || ( execute !== true && visible === 0 ) ){
                                $(`#${bouton}`).show();
                                champs.forEachCondition(function ( data, champ ) {
                                    var _field_data = $(`[data-name=${champ}]`);
                                    if(_field_data.attr('data-required') == 'required'){
                                        _field_data.prop("required", "required");
                                        _field_data.removeAttr('data-required');
                                    }
                                    _field_data.removeAttr('data-visible');
                                });
                            }else if( ( execute === true && visible === 0 ) || ( execute !== true && visible === 1 ) ){
                                $(`#${bouton}`).hide();
                                champs.forEachCondition(function ( data, champ ) {
                                    var _field_data = $(`[data-name=${champ}]`);

                                    if( $( _field_data ).closest('.onglet-layout').attr('id') == onglet.attr('id'))
                                    {
                                        if(_field_data.attr('required') == 'required'){
                                            _field_data.removeAttr("required");
                                            _field_data.attr('data-required', 'required');
                                        }
                                        _field_data.attr('data-visible', 'masque');
                                    }
                                });
                            }else{
                                $(`#${bouton}`).show();
                            }
                        }
                    }
                });
            }
        },

        executeAction: function(actionStatut){
            actionStatut.each(function(index, element){

                var onglets = $(element).val().split(",");
                var visible = $(element).attr("data-visible");
                var modifiable = $(element).attr("data-modifiable");

                onglets.forEachCondition(function ( ongletId ) {

                    $('.visible_modifiable_onglet').each(function(){
                        if ($(this).val() == ongletId)
                        $(this).attr('done','done');
                    });
                    
                    var champs = OdeCondition.getChampsByid("onglet_"+ongletId);
                    var params = (new URLS(document.location)).searchParams;
                    var action = params.get('action');

                    $("#bouton_"+ongletId).removeAttr("data-conditions");

                    if(visible == 'off'){
                        $("#bouton_"+ongletId).remove();
                        champs.forEachCondition(function ( data, champ ) {
                            var _field_data = $('#onglet_' + ongletId).find( $(`[data-name=${champ}]`) );
                            if(_field_data.attr('required') == 'required'){
                                _field_data.removeAttr("required");
                                _field_data.attr('data-required', 'required');
                            }
                            _field_data.attr("data-conditions", "");
                            _field_data.attr('data-visible', 'masque');
                        });
                    }
                    if(modifiable == 'off' && (action == "EditView" || action == "create") ){
                        champs.forEachCondition(function ( data, champ ) {

                            var _field_data = $('#onglet_' + ongletId).find( $(`[data-name=${champ}]`) );
                            var champ = _field_data;

                            if(_field_data.length === 1 && _field_data.attr("data-unique") === undefined)
                            {
                                if( champ.attr('data-type-field') =="wysiwyg" )
                                {
                                    $(champ).closest('div').css('opacity', '0.5');
                                    $(champ).closest('div').css('pointer-events', 'none');
                                }
                                champ.prop("disabled","disabled");

                                if( champ.attr("data-type-field") === 'checkboxmulti' )
                                {
                                    $(champ).closest('div').find('div').each(function() {
                                        $(this).find('input').prop("disabled","disabled");
                                    });
                                }

                                if( champ.attr("data-type-field") === 'tableau' )
                                {
                                    // On attend le chargement complet pour pouvoir supprimer le bouton d'ajout de ligne quand l'étape est non modifiable
                                    $( document ).ready(function() {
                                        $(champ).children('div').remove();
                                    });
                                    $(champ).children("table").children("tbody").find('input').each(function() {
                                        $(this).prop("disabled","disabled");
                                    });
                                }
                            }
                            else if (_field_data.attr("data-unique") !== undefined) 
                            {
                                var button = $(`[data-name=${champ.attr("data-name")}]`).parent().find("button");
                                button.prop("disabled","disabled");
                                if(champ.attr("data-unique") == "multi"){
                                    champ.parent().find('i').hide();
                                }
                            }
                            else
                            {
                                for( i = 0; i < _field_data.length; i++ )
                                {
                                    var champ = $(_field_data[i]);

                                    champ.prop("disabled","disabled");
                                }
                            }
                        });
                    }
                });
            })
        },

        /**
        * Fonction qui 
        * 
        * @return {void} 
        */
        getOnglets: function() { 
            var onglets = {};
            $("[role=onglet-formulaire]").each(function() {
                if ( $(this).attr("data-conditions") !== "" ) {
                    onglets[$(this).attr("id")] = JSON.parse($(this).attr("data-conditions").b64ToUtf8());
                } else {
                    if ( onglets.hasOwnProperty($(this).attr("id")) === false ) {
                        onglets[$(this).attr("id")] = false;
                    }
                }
            });
            return onglets;
        },

        /**
        * Fonction qui 
        * 
        * @return {void} 
        */
        getChampsByid: function(id) { 
            var champs = {};

            $(`#${id}`).find('[role=champ-formulaire]').each(function() {
                if ( $(this).attr("data-conditions") !== "" && $(this).attr("data-conditions") != undefined ) {
                    champs[$(this).attr("data-name")] = JSON.parse($(this).attr("data-conditions").b64ToUtf8());
                } else {
                    if ( champs.hasOwnProperty($(this).attr("id")) === false ) {
                        champs[$(this).attr("data-name")] = false;
                    }
                }
            });
            return champs;
        },
  
        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
        getValue: function( field ) { 
            var field_value = "";

            if ( field.length !== 0 ) {
                var field_tag = field.get(0).tagName;
                var field_type = field.attr("type");
                if ( field_tag === "INPUT" ){
                    if ($(field).attr('data-type-field') == 'checkboxmulti')
                    {
                        var id = $(field).attr('id');

                        var container = $('#' + id + '_container');

                        var checkedBoxes = [];
                        $(container).find('input[type=checkbox]:checked').each(function(){
                            checkedBoxes.push("^" + $(this).attr('name') + "^");
                        });

                        var checkbox_liste = checkedBoxes.join(",");

                        field_value = checkbox_liste;
                    }
                    else if ( field_type === "text" || field_type === "hidden" ){
                        if(field.attr("data-value") && !field.attr("data-value").isEmpty()){
                            field_value = field.attr("data-value");
                        }else{
                            field_value = ( !field.val().isEmpty() ) ? field.val() : "";
                        }
                    } else if ( field_type === "checkbox" ) {
                        field_value = ( field.prop("checked") === true ) ? "true" : "false";
                    } else if ( field_type === "number" ) { 
                        field_value = ( field.val() > 0 ) ? field.val() : 0;  
                    } else if(field_type === "radio"){
                        field_value = $(`input[name=${field[0].name}]:checked`).val();
                    }else{
                        console.log("Type champ input non géré");
                    }
                } else if ( field_tag === "SELECT" ){
                    field_value = (field.find("option:selected").val() !== undefined)?field.val():'';
                } else if ( field_tag === "TEXTAREA" ){
                    field_value = ( !field.val().isEmpty() ) ? field.val() : "";
                }else {
                    console.log("Tag champ non géré");
                }
            }
            return field_value;
        },
    }
  })(jQuery);