<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/Dashlets/DashletGeneric.php');
require_once('modules/OPS_dossier/OPS_dossier.php');

class OPS_dossierDashlet extends DashletGeneric 
{
    function __construct($id, $def = null)
    {
        global $current_user, $app_strings;
        require('modules/OPS_dossier/metadata/dashletviewdefs.php');

        parent::__construct($id, $def);

        if (empty($def['title'])) {
            $this->title = translate('LBL_HOMEPAGE_TITLE', 'OPS_dossier');
        }

        $this->searchFields = $dashletData['OPS_dossierDashlet']['searchFields'];
        $this->columns = $dashletData['OPS_dossierDashlet']['columns'];

        $this->seedBean = new OPS_dossier();        
    }

    public function process($lvsParams = array(), $id = null)
    {

        parent::process($lvsParams, $id);

        if (isset($this->filters) || $this->myItemsOnly) {
            $whereArray = $this->buildWhere();
        }

        $where = '';
        if (!empty($whereArray)) {
            $where = '(' . implode(') AND (', $whereArray) . ') ';
        }

        foreach($this->filters as $filter => $params)
        {
            $widgetDef = $this->seedBean->field_defs[$filter];

            if(empty($params))
            {
                if($widgetDef['type'] != 'relate' || $filter == 'assigned_user_id')
                {
                    if(!empty($where))
                    {
                        $where .= ' AND ';
                    }
                    $where .= '(ops_dossier.' . $filter . ' = "" OR ops_dossier.' . $filter . ' IS NULL)';
                }
            }
        }

        # Surchage des filtres pour le cas des flags justificatifs en étude et réétude
        # On supprime la génération automatique de suiteCRM, pour ensuite créer notre requête afin d'y mettre un OR entre les deux flags
        if(strpos($where, "flag_justificatif_etude='1'") && strpos($where, "flag_justificatif_reetude='1'"))
        {
            # Supprime la partie flag_justificatif_etude
            if (preg_match('/AND \(\(ops_dossier.flag_justificatif_etude[^)]*\)[^)]*\)/', $where, $matches)) 
            {
                $result = $matches[0];
    
                $where = str_replace($result, '', $where);
            }
            
            # Supprime la partie flag_justificatif_etude
            if (preg_match('/\(\(ops_dossier.flag_justificatif_etude[^)]*\)[^)]*\)/', $where, $matches)) 
            {
                $result = $matches[0];
    
                $where = str_replace($result, '', $where);
            }
    
            # Supprime la partie flag_justificatif_reetude
            if (preg_match('/AND \(\(ops_dossier.flag_justificatif_reetude[^)]*\)[^)]*\)/', $where, $matches)) 
            {
                $result = $matches[0];
    
                $where = str_replace($result, '', $where);
            }

            if (preg_match('/\(\(ops_dossier.flag_justificatif_reetude[^)]*\)[^)]*\)/', $where, $matches)) 
            {
                $result = $matches[0];
    
                $where = str_replace($result, '', $where);
            }

            if(!preg_match('/^\s+$/', $where))
            {
                $where .= ' AND ';
            }

            if(strtok(trim($where), ' ') == 'AND')
            {
                $where = substr(strstr($where,"AND"), 3);
            }
            
            $where .= " (((ops_dossier.flag_justificatif_etude LIKE 'on' OR ops_dossier.flag_justificatif_etude='1')) OR 
            ((ops_dossier.flag_justificatif_reetude LIKE 'on' OR ops_dossier.flag_justificatif_reetude='1'))) "; 
        }

        $this->lvs->setup($this->seedBean, $this->displayTpl, $where, $lvsParams, 0, $this->displayRows/*, $filterFields*/, array(), 'id', $id);
    }

}
