<?php

class OPS_dispositif extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_dispositif';
    public $object_name = 'OPS_dispositif';
    public $table_name = 'ops_dispositif';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $attribution_auto;
    public $cle;
    public $thematique;
    
    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }


    /**
     * @access private 
     * @name getDispositifs()
     * Fonction qui renvoie la liste des dispositifs de la plateforme    => OPS_dispositif
     * 
     *  @return array          $tab_dispositifs : Tableau de dispositif
     */
    public static function getDispositifs()
    {

        $tab_dispositifs = array();

        $obj_dispo = new OPS_dispositif;
        $dispositifs = $obj_dispo->get_full_list_create(); // Vérifier les habilitations

        foreach ($dispositifs as $dispositif) {

            $erreurs = OPS_dispositif::isValidDispositif($dispositif);
            $statut = (count($erreurs) == 0) ? "ok" : "err";
            $libelle_erreurs = (count($erreurs) != 0) ? implode(", ", $erreurs) : "";
            $lock = false; 
            $saison = false;


            // Gestion des saisons 
            if( $dispositif->saison == true  ){
                
                $dateTime = new DateTime('NOW');
                $today = $dateTime->format('Y-m-d');

                $saison_affichage_date_debut = $dispositif->saison_affichage_date_debut;
                $saison_affichage_date_fin = $dispositif->saison_affichage_date_fin;
                $saison_date_debut = $dispositif->saison_date_debut;
                $saison_date_fin = $dispositif->saison_date_fin;

                // Affichage du dispositif ? 
                if( $saison_affichage_date_debut <= $today  && $today <= $saison_affichage_date_fin ){

                    $lock = true ; 
                    $date_fin = new DateTime($saison_date_fin);
                    $date_fin = $date_fin->format('d/m/Y');

                    $date_debut = new DateTime($saison_date_debut);
                    $date_debut = $date_debut->format('d/m/Y');

                    // Dispositif ouvert ? 
                    if( $saison_date_debut <= $today  && $today <= $saison_date_fin ){

                        $date_fin = new DateTime($saison_date_fin);
                        $date_fin = $date_fin->format('d/m/Y');

                        $lock = false ; 
                        $saison = "Ouvert jusqu'au ".$date_fin." inclus";
                    }
                    else{

                        // Le dispositif va bientôt ouvrir 
                        if(  $saison_date_debut >= $today )
                        {
                            $saison = "Ouvrira le ".$date_debut;

                        }
                        else{
                            $saison = "Fermé depuis le ".$date_fin ; 
                        }

                    }

                }
                else{
                    continue ; 
                }

            }
            $tab_dispositifs[$dispositif->id] = array(
                "name" => $dispositif->name,
                "cle" => $dispositif->cle,
                "icon" => (!empty($dispositif->icone) ) ?  $dispositif->icone : "archive",
                "color" => (!empty($dispositif->couleur) ) ?  $dispositif->couleur : "#6A747E",
                "aide" => $dispositif->description,
                "saison" => $saison,
                "statut" => $statut,
                "erreurs" => $libelle_erreurs,
                "locked" => $lock,
            );
        }

        return $tab_dispositifs;
    }

    /**
     * @access private
     * @name isValidDispositif()
     * Fonction qui vérifie si le dispositif est valid, elle revoie la liste des erreurs.
     * 
     *  @param bean             $dispositif: Bean module OPS_dispositif
     *  @return array           $erreurs : tableau d'erreurs
     */
    private static function isValidDispositif($dispositif)
    {

        $erreurs = array();

        // On vérifie que le dispositif est liée à une unique vue 
        $liste_formulaires =  $dispositif->get_linked_beans('ops_generateur_formulaire_ops_dispositif', 'OPS_generateur_formulaire');
        $formulaire = (is_array($liste_formulaires) && count($liste_formulaires) > 0) ?  $liste_formulaires[0] : false;
        $agent_vue_id = ($formulaire !== false &&  !empty($formulaire->agent_vue_id)) ? $formulaire->agent_vue_id : false;
        $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $agent_vue_id);

        if (!empty($obj_vue->id)) {
            // On vérifie que la vue a bien des onglets et champs 
            $liste_onglets = $obj_vue->get_linked_beans('ops_generateur_vue_ops_generateur_onglet', 'OPS_generateur_onglet');
            if (!is_array($liste_onglets) || count($liste_onglets) == 0) {
                $erreurs[] = "Aucun onglet n'a été configuré sur ce dispositif";
            }
        } else {
            $erreurs[] = "Aucun modèle de dossier n'est associé à ce dispositif";
        }

        // On vérifie que le dispositif est rattaché à un guide d'instruction
        $liste_guide_instruction =  $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction');
        $guide_instruction = (is_array($liste_guide_instruction) && count($liste_guide_instruction) == 1) ? $liste_guide_instruction[0] : false;
        if ($guide_instruction === false) $erreurs[] = "Aucun guide d'instruction n'est associé à ce dispositif";

        // On vérifie que le guide d'instruction dispose d'un statut initial
        if ($guide_instruction !== false) {
            if (empty($guide_instruction->ops_statut_id)) $erreurs[] = "Le statut initial n'est pas renseigné sur le guide d'instruction";
        }

        // Vérifier que dans la vue dispose des champs obligatoires 
        if (is_array($liste_onglets) && count($liste_onglets) > 0) {
            $verification_champs = false;
            foreach ($liste_onglets as $onglet) {
                $liste_champs = $onglet->get_linked_beans('ops_generateur_onglet_ops_generateur_champ', 'OPS_generateur_champ');
                if (count($liste_champs) > 0) $verification_champs = true;
            }
            if ($verification_champs === false) $erreurs[] = "Les champs obligatoires sont absents du formulaire";
        }


        return $erreurs;
    }

    // Ajout des habilitations sur les vues listes dispositifs 
    function create_new_list_query($order_by, $where, $filter = array(), $params = array(), $show_deleted = 0, $join_type = '', $return_array = false, $parentbean = null, $singleSelect = false, $ifListForExport = false)
    {
        global $beanFiles, $current_user;

        $return_array = parent::create_new_list_query($order_by, $where, $filter, $params, $show_deleted, $join_type, $return_array, $parentbean, $singleSelect, $ifListForExport);

        // Préparation de la requete pour bloquer l'affichage des dispositifs 
        $req_where = $_SESSION['ops_requete_dispositif'];

        // On a joute le filtre pour la gestion des habilitation
        if (!empty($req_where) && !$current_user->isAdmin()) {
            if (is_array($return_array)) {
                $return_array['where'] .= ' AND ' . $req_where;
            }
        }

        if (is_array($return_array) && empty($return_array['order_by'])) {
            $return_array['order_by'] =  " ORDER BY " . strtoupper('name') . ' ASC';
        }

        return $return_array;
    }

    function recup_thematique()
    {

        if (!empty($this->id)) // Vérification d'un objet passé en paramètre
        {

            return $this->thematique;
        }
    }

    /**
     * @access public 
     * @name getListeThematique()
     * Fonction qui renvoie la liste des dispositifs de la plateforme    => OPS_dispositif
     * 
     *  @return array|false          $liste_thematique : Liste thématique
     */
    public function getListeThematique($thematique)
    {

        global $app_list_strings;

        $liste_thematique = array();
        $tab_thematique = explode(",", str_replace("^", "", $thematique));
        $liste_complete = $app_list_strings["ops_thematique_list"];

        if (is_array($liste_complete) && count($liste_complete) > 0 && is_array($tab_thematique) && count($tab_thematique) > 0) {
            foreach ($liste_complete as $key => $value) {
                if (in_array($key, $tab_thematique)) {
                    $liste_thematique[$key] = $value;
                }
            }
        }

        return (count($liste_thematique) > 0) ? base64_encode(json_encode($liste_thematique)) : false;
    }


    // Méthode de récupréation des dispositifs en fonction des habilitations dispositifs => édition
    public function get_full_list_create()
    {

        global $current_user;

        $list_dispo = $_SESSION['habilitation_dispositif'];

        $tab_dispositif;

        $dispositifs = $this->get_full_list("name");

        if (!is_admin($current_user)) {

            foreach ($dispositifs as $key => $obj_dispo) {

                foreach ($list_dispo as $key => $dispo_ok) {

                    if ($obj_dispo->id == $key && $dispo_ok['edition'] == 1) {

                        $tab_dispositif[] = $obj_dispo;
                    }
                }
            }
        } else {

            $tab_dispositif = $dispositifs;
        }

        return $tab_dispositif;
    }
}
