<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class OPS_dashlet_ongletViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }

    function display()
    {
        global $mod_strings;

        // LANTEAS - 04/2019 - Pour palier au problème d'affichage des champs de sélection, on répare les fichiers de cache du module
        require_once("modules/Administration/QuickRepairAndRebuild.php");
        $repair = new RepairAndClear();
        $repair->repairAndClearAll(array('clearThemeCache'), array('OPS_dashlet_onglet'), true, false);

        //
        // Afin d'éviter les reconfigurations "étranges" on empeche de modifier les champs des Onglets & Dashlet si il y a une valeur initialisée
        //        
        if (!empty($this->bean->ops_dashlet_onglet_ops_dashletops_dashlet_ida) || (!empty($_REQUEST['return_id']) && ($_REQUEST['return_module'] == 'OPS_dashlet'))) {
            $this->ev->defs['panels']['default'][0][1]['type'] = 'readonly';
            if (empty($this->bean->ops_dashlet_onglet_ops_dashletops_dashlet_ida)) {
                $this->bean->ops_dashlet_onglet_ops_dashletops_dashlet_ida = $_REQUEST['return_id'];
            }
            if (empty($this->bean->ops_dashlet_onglet_ops_dashlet_name)) {
                global $beanFiles;
                require_once($beanFiles[$_REQUEST['return_module']]);
                $dashlet = new $_REQUEST['return_module']();
                $dashlet->retrieve($_REQUEST['return_id']);
                $this->bean->ops_dashlet_onglet_ops_dashlet_name = $dashlet->name;
            }
        }
        if (!empty($this->bean->ops_dashlet_onglet_ops_ongletops_onglet_ida) || (!empty($_REQUEST['return_id']) && ($_REQUEST['return_module'] == 'OPS_onglet'))) {
            $this->ev->defs['panels']['default'][0][0]['type'] = 'readonly';
            if (empty($this->bean->ops_dashlet_onglet_ops_ongletops_onglet_ida)) {
                $this->bean->ops_dashlet_onglet_ops_ongletops_onglet_ida = $_REQUEST['return_id'];
            }
            if (empty($this->bean->ops_dashlet_onglet_ops_onglet_name)) {
                global $beanFiles;
                require_once($beanFiles['OPS_onglet']);
                $onglet = new OPS_onglet();
                $onglet->retrieve($_REQUEST['return_id']);

                $this->bean->ops_dashlet_onglet_ops_onglet_name = $onglet->name;
            }
        }
        $this->ss->assign("MOD", $mod_strings);

        parent::display();
    }
}
