$(document).ready(function () {
    /* On ajoute la div des filtres du module Taches dans le panel "Filtres" */
    let div_filtres = document.getElementById('filtres-container');
    let div_filtres_taches = document.getElementById('filtres_taches');
    div_filtres.append(div_filtres_taches);

    /* On ajoute avant le champ "Description" les sélecteurs de colonnes à afficher */
    add_colonne_field('display_tabs_tasks_div');

    /* On déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné  */
    on_objet_change_tasks();

    /* Si l'objet est modifié, on déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné */
    $('#dashlet_objet').change(function () {
        on_objet_change_tasks()
    });

    /* On déclenche le resize des select des colonnes affichées / masquées au déplacement d'une colonne */
    var div_tabs_tasks = document.getElementById('display_tabs_tasks_div');
    var chooser_display_tabs_left_arrow = $('#chooser_display_tabs_left_arrow', div_tabs_tasks)[0];
    var chooser_display_tabs_left_to_right = $('#chooser_display_tabs_left_to_right', div_tabs_tasks)[0];

    chooser_display_tabs_left_arrow.addEventListener("click", () => {
        $('#display_tabs_ta').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_ta', 'display_tabs_ta')
    }, false);

    chooser_display_tabs_left_to_right.addEventListener("click", () => {
        $('#display_tabs_ta').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_ta', 'display_tabs_ta')
    }, false);

    jQuery('#filtres_taches div[id^="checkboxes_"] input[type=checkbox]').each(function () {
        if (this.checked) {
            $('#' + this.id).prop("checked", true);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        } else {
            $('#' + this.id).prop("checked", false);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        }
    });
});

/**
 * Fonction vérifiant le type d'objet sélectionné pour afficher les filtres et le sélecteur de colonnes correspondants
 * 
 * @return {void}
 */
var on_objet_change_tasks = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet == 'Tasks') {
        $('#display_tabs_tasks').parent().show();
        $('#display_tabs_ta').prop('disabled', false);
        $('#filtres_taches').show();
        $('#filtres_taches *').prop('disabled', false);
        $('#li-filtres').show()
    } else {
        $('#display_tabs_tasks').parent().hide();
        $('#display_tabs_ta').prop('disabled', true);
        $('#filtres_taches').hide();
        $('#filtres_taches *').prop('disabled', true);
    }
}