<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.detail.php');

/** 
 * Classe appelée par le view.detail.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_dossier"
 */
class TasksDetail
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres)
    {
        global $app_list_strings;

        $liste_priority = array();
        $liste_status = array();

        if ($filtres['priority']) {
            for ($i = 0; $i < count($filtres['priority']); $i++) { // Filtre sur la thématique
                if ($filtres['priority'][$i] != "") {
                    $key = $filtres['priority'][$i];
                    $liste_priority[$i] = $app_list_strings['task_priority_dom'][$key];
                }
            }
        }
        $this->ss->assign('LISTE_PRIORITEES_AFFICHEES', $liste_priority);

        if ($filtres['status']) {
            for ($i = 0; $i < count($filtres['status']); $i++) { // Filtre sur la thématique
                if ($filtres['status'][$i] != "") {
                    $key = $filtres['status'][$i];
                    $liste_status[$i] = $app_list_strings['task_status_dom'][$key];
                }
            }
        }
        $this->ss->assign('LISTE_STATUS_AFFICHEES', $liste_status);
    }
}
