$(document).ready(function () {
    /* On déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné  */
    on_objet_change_rapports();

    /* On ajoute avant le champ "Description" les sélecteurs de colonnes à afficher */
    add_colonne_field('display_tabs_rapport_div');

    /* On déclenche le resize des select des colonnes affichées / masquées au déplacement d'une colonne */
    var div_tabs_rapport = document.getElementById('display_tabs_rapport_div');
    var chooser_display_tabs_left_arrow = $('#chooser_display_tabs_left_arrow', div_tabs_rapport)[0];
    var chooser_display_tabs_left_to_right = $('#chooser_display_tabs_left_to_right', div_tabs_rapport)[0];

    chooser_display_tabs_left_arrow.addEventListener("click", () => {
        $('#display_tabs_rap').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_rap', 'display_tabs_rap')
    }, false);

    chooser_display_tabs_left_to_right.addEventListener("click", () => {
        $('#display_tabs_rap').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_rap', 'display_tabs_rap')
    }, false);

    /* Si l'objet est modifié, on déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné */
    $('#dashlet_objet').change(function () {
        on_objet_change_rapports()
    });
});

/**
 * Fonction vérifiant le type d'objet sélectionné pour afficher les filtres et le sélecteur de colonnes correspondants
 * 
 * @return {void}
 */
var on_objet_change_rapports = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet == 'OPS_rapport') {
        $('#display_tabs_rapport').parent().show();
        $('#display_tabs_rap').prop('disabled', false);
        $('#li-filtres').hide();        
    } else {
        $('#display_tabs_rapport').parent().hide();
        $('#display_tabs_rap').prop('disabled', true);
    }
}