<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.edit.php');

/**
 * Classe appelée par le view.edit.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_dossier"
 */
class OPS_dossierEdit
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres = array())
    {
        global $app_list_strings;

        $liste_dispositifs = array();
        $liste_statuts = array();
        $liste_thematiques = array();

        /*
         * Récupération de la liste des dispositifs pour les filtres
         */
        $bean_dispositif = BeanFactory::newBean('OPS_dispositif');
        $dispositif_list = $bean_dispositif->get_full_list(
            'name',
            'ops_dispositif.deleted = 0',
        );

        // Récupération de la liste des dispositifs pour filtrage sur des dispositifs spécifiques
        foreach ($dispositif_list as $dispositif) {
            $liste_dispositifs[$dispositif->id] = $dispositif->name;
        }
        $this->ss->assign('DOSSIER_FILTRES_DISPOSITIF', $liste_dispositifs);

        /*
         * Récupération de la liste des statuts pour les filtres en prenant le guide d'instruction pour permettre l'affichage par guide d'instruction dans la liste
         */
        $bean_guide = BeanFactory::newBean('OPS_guide_instruction');
        $bean_guide_list = $bean_guide->get_full_list(
            'name',
            'ops_guide_instruction.deleted = 0'
        );

        foreach ($bean_guide_list as $key => $obj_guide) {
            // Récupération des étapes
            $etapes = $obj_guide->get_linked_beans('ops_guide_instruction_ops_etape', 'OPS_etape');

            foreach ($etapes as $key => $obj_etape) {
                // Récupération des statuts
                $statuts = $obj_etape->get_linked_beans('ops_etape_ops_statut', 'OPS_statut', 'name');

                // Création du tableau de récupération des statuts
                foreach ($statuts as $statut) {
                    // Pour chaque statut, on récupère le guide d'instruction associé pour permettre de trier la liste des statuts par guide d'instruction
                    $liste_statuts[$obj_guide->name][$statut->id] = $obj_etape->name . ": " . $statut->name;
                    asort($liste_statuts[$obj_guide->name]);
                }
            }
        }
        $this->ss->assign('DASHLET_DOSSIER_FILTRES_STATUTS', $liste_statuts);

        $bean_type_territoire = BeanFactory::newBean('OPS_type_territoire');
        $bean_type_territoire_list = $bean_type_territoire->get_full_list(
            'name',
            'ops_type_territoire.deleted = 0'
        );

        $liste_territoires = [];
        foreach ($bean_type_territoire_list as $key => $obj_type_territoire) {
            // Récupération des territoires
            $territoires = $obj_type_territoire->get_linked_beans('ops_territoire_ops_type_territoire', 'OPS_territoire');

            foreach ($territoires as $key => $obj_territoire) {
                $liste_territoires[$obj_type_territoire->name][$obj_territoire->id] = $obj_territoire->name;
                asort($liste_territoires[$obj_type_territoire->name]);
            }
        }

        $this->ss->assign('DASHLET_DOSSIER_FILTRES_TERRITOIRES', $liste_territoires);

        // Filtre sur les thématiques de dossiers
        unset($app_list_strings['ops_thematique_list']['']);
        $liste_thematiques = $app_list_strings['ops_thematique_list'];
        asort($liste_thematiques);
        $this->ss->assign('DASHLET_DOSSIER_FILTRES_THEMATIQUE', $liste_thematiques);

        // Filtre sur les canaux de saisies (CRM, Internet, ...)
        $this->ss->assign('DASHLET_DOSSIER_FILTRES_CANAL', $app_list_strings['ops_canal_list']);

        if ($this->bean->filtre_metadonnees) {
            $array_value_metadata = explode("\n", $this->bean->filtre_metadonnees);
            foreach ($array_value_metadata as $value) {
                $key = explode(';', $value)[0];
                $array_values_metadata[$key] = explode(';', $value)[1];
            }
        }
        $liste_champs_tri = $this->sortArrayByArray($app_list_strings['list_champs_dossier'], $app_list_strings['list_champs_dossier_defaut']);
        $this->ss->assign("DASHLET_CHAMPS_DOSSIER_LISTE", $liste_champs_tri);
        $this->ss->assign("DASHLET_CHAMPS_DOSSIER_LISTE_DEFAUT", $app_list_strings['list_champs_dossier_defaut']);

        // On extrait les valeurs saisies dans les filtres (dans le cas d'une édition)
        $this->ss->assign('FILTRE_STATUT_DOSSIER', $filtres['statut']);
        $this->ss->assign('FILTRE_DISPOSITIF_DOSSIER', $filtres['ops_dispositif_ops_dossier_name']);
        $this->ss->assign('FILTRE_THEMATIQUE', $filtres['thematique']);
        $this->ss->assign('FILTRE_CANAL_DOSSIER', $filtres['canal']);
        $this->ss->assign('FILTRE_TERRITOIRE_DOSSIER', $filtres['territoire']);
        $this->ss->assign('FILTRE_JUSTIFICATIFS_ETUDE', $filtres['flag_justificatif_etude']);
        $this->ss->assign('FILTRE_JUSTIFICATIFS_REETUDE', $filtres['flag_justificatif_reetude']);
        $this->ss->assign('FILTRE_VALEURS_METADATA', $array_values_metadata);
    }

    /**
     * Fonction permettant de forcer le tri des "colonnes affichées" en utilisant le tableau "colonnes par défaut"
     *
     * @param array $array - Le tableau non trié des colonnes affichées
     * @param array $orderArray - Le tableau trié des colonnes affichées par défaut
     * @return array Le tableau final trié
     */
    private function sortArrayByArray($array, $orderArray)
    {
        $ordered = array();
        foreach ($orderArray as $key => $value) {
            if (array_key_exists($key, $array)) {
                $ordered[$key] = $array[$key];
                unset($array[$key]);
            }
        }
        return $ordered + $array;
    }
}