<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}


class OPS_dossierController extends SugarController
{

    /**
     * Bean that is being handled by the Calendar's current action.
     * @var SugarBean $currentBean
     */
    protected $currentBean = null;

    public function setFiltres($requete)
    {
        if (isset($requete['brouillon'])) {
            $filtres['brouillon'] = $requete['brouillon'];
        }

        if (isset($_REQUEST['flag_justificatif_etude']) && $_REQUEST['flag_justificatif_etude'] == 1 &&
            isset($_REQUEST['flag_justificatif_reetude']) && $_REQUEST['flag_justificatif_reetude'] == 1) 
        {
            $GLOBALS['log']->fatal('OPS_dashlet//OPS_dossierController::setFiltres => flag_justificatif_etude & flag_justificatif_reetude sont cochés');
        }
        else
        {
            if (isset($_REQUEST['flag_justificatif_etude']) && $_REQUEST['flag_justificatif_etude'] == 1) {
                $filtres['flag_justificatif_etude'] = "1";
            }
    
            if (isset($_REQUEST['flag_justificatif_reetude']) && $_REQUEST['flag_justificatif_reetude'] == 1) {
                $filtres['flag_justificatif_reetude'] = "1";
            }
        }


        foreach ($requete as $key => $value) {
            $filtre_nom = '';
            if (strpos($key, '_')) {
                $filtre_select_nom = explode('_', $key)[0];
                switch ($filtre_select_nom) {
                    case 'statut': // Filtre sur les ids des statuts des guides d'instruction 
                        $filtre_nom = 'statut';
                        break;
                    case 'dispositif': // Filtre sur les ids de dispositifs
                        $filtre_nom = 'ops_dispositif_ops_dossier_name';
                        break;
                    case 'thematique': // Filtre sur les noms des thématiques de dispositifs
                        $filtre_nom = 'thematique';
                        break;
                    case 'canal': // Filtre sur les noms de canaux des dossiers (CRM, Internet, ...)
                        $filtre_nom = 'canal';
                        break;
                    case 'territoire': // Filtre sur les noms de territoires des dossiers
                        $filtre_nom = 'territoire';
                        break;
                    default:
                        break;
                }
                if ($filtre_nom) {
                    $filtres[$filtre_nom][] = $value;
                }
            }
        }

        $filtre_metadonnees = '';
        for ($i = 0; $i < count($requete); $i++) {
            if (isset($requete['metadata' . $i]) && !empty($requete['metadata' . $i])) {
                if ($i == 0) {
                    $filtre_metadonnees .= $requete['metadata' . $i] . ';' . $requete['value_metadata' . $i];
                } else {
                    $filtre_metadonnees .= "\n" . $requete['metadata' . $i] . ';' . $requete['value_metadata' . $i];
                }
                $key_filtre = $requete['metadata' . $i];

                $bean = BeanFactory::getBean('OPS_dossier');
                $field_defs = $bean->getFieldDefinitions();

                if (array_key_exists($key_filtre, $field_defs)) {
                    switch ($field_defs[$key_filtre]['type']) {
                        case 'enum':
                        case 'multienum':
                        case 'date':
                            $filtres[$key_filtre][$i] = $requete['value_metadata' . $i];
                            break;
                        default:
                            $filtres[$key_filtre] = $requete['value_metadata' . $i];
                            break;
                    }
                }
            } else {
                $filtre_metadonnees .= "";
            }
        }

        $array_filtres['filtres'] = $filtres;
        $array_filtres['filtres_metadonnees'] = $filtre_metadonnees;

        return $array_filtres;
    }
}
