$( document ).ready(function() {

	$("#treeview").hummingbird();
	if($('#modal-classement').parent().parent().attr('class') === 'subnav'){
		$('#modal-classement').insertBefore($('#modal-classement').parent().parent());
	}

    $( "#classer_classement" ).off().click(function() {
		$('#modal-classement').modal();
	});

	$( "#annuler_modal" ).off().click(function() {
    	
    	$('#treeview').empty();
        $('#classement_recherche').hide();
        $('#modal-classement').hide();
        $('#ext_valeur_type').val('');
		$('#id_niv_one').val('');
		$('#id_niv_two').val('');
		$('#id_niv_three').val('');
		$('#id_niv_four').val('');
		$('#id_type').val('');
		$('#id_classement').val('');

	});

	$( ".close" ).off().click(function() {
    	$('#treeview').empty();
        $('#classement_recherche').hide();
        $('#modal-classement').hide();
        $('#ext_valeur_type').val('');
		$('#id_niv_one').val('');
		$('#id_niv_two').val('');
		$('#id_niv_three').val('');
		$('#id_niv_four').val('');
		$('#id_type').val('');
		$('#id_classement').val('');
	});

	$( "#charger_classement" ).off().click(function() {
    	$('#modal-classement-zone').show();
	});

	$( "#save_classement" ).off().click(function() {

		var id_classement = $("#id_classement").val();
		var id_type_classement = $("#id_type").val();
		var id_niv_one = $("#id_niv_one").val();
		var id_niv_two = $("#id_niv_two").val();
		var id_niv_three = $("#id_niv_three").val();
		var id_niv_four = $("#id_niv_four").val();
		var id_dossier = $('input[name="record"]').val();

		var data_send = {};
		
		data_send['id_classement'] = id_classement;
		data_send['id_type'] = id_type_classement;
		data_send['id_niv_one'] = id_niv_one;
		data_send['id_niv_two'] = id_niv_two;
		data_send['id_niv_three'] = id_niv_three;
		data_send['id_niv_four'] = id_niv_four;
		data_send['id_dossier'] = id_dossier;

		send_data_classement(data_send);
	});

	$( "#filter" ).keyup(function( event ) {
		
		var search_value = $("#filter").val();
		
		$("label").css( "background-color", "#fff" )
		if(search_value != '' && search_value != ' ' && search_value != '  ' && search_value != '   ' && search_value.length >= 3){
			var pop = $( "label:contains("+search_value+")" );
			pop.css( "background-color", "orange" );
			var parent_ul = pop.parents();

			$(parent_ul[1]).show();
			$(parent_ul[3]).show();
			$(parent_ul[5]).show();		
		}
	});

	$("select#ext_valeur_type").change(function(){

        var main_click = $(this).children("option:selected").val();

        $('#treeview').empty();
        $('#classement_recherche').show();

		$('#id_niv_one').val('');
		$('#id_niv_two').val('');
		$('#id_niv_three').val('');
		$('#id_niv_four').val('');
		$('#id_type').val('');
		$('#id_type').val(main_click);

		get_niveaux_for_type(main_click);
    });
});

function modifClassement(id_classement){

	$('#modal-classement').modal();
	$('#classement_recherche').show();
	var data_id = {};
	data_id['id_classement'] = id_classement;
	$('#id_classement').val(id_classement);

	get_classement_by_id(data_id);
}


function get_classement_by_id(data_id){

	$.ajax({
        type:"POST",
        url:'index.php?module=OPS_classement&action=get_classement_by_id',
        async: false,
        dataType: 'json',
        data: {
    	    array_champs: data_id
        }
    })
	.done(function (data) {

		$('#ext_valeur_type').val(data['type']);

		$('#treeview').empty();
        $('#filter').show();
		get_niveaux_for_type(data['type']);
		$('#id_type').val(data['type']);
		$('#id_niv_one').val(data['niv1']);
		$('#id_niv_two').val(data['niv2']);
		$('#id_niv_three').val(data['niv3']);
		$('#id_niv_four').val(data['niv4']);

		if(data['niv1'] != ''){
			let i = 0;
			let interval = setInterval(() => {
				if($('#xnode-'+data['niv1']).length > 0){
					$('#xnode-'+data['niv1']).click();
					clearInterval(interval);
				}
			  i++;
			  if(i === 20) clearInterval(interval);
			}, 100);
		}

		if(data['niv2'] != ''){
			let i2 = 0;
			let interval2 = setInterval(() => {
				if($('#xnode-'+data['niv2']).length > 0){
					$('#i_'+data['niv1']).click();
					$('#xnode-'+data['niv2']).click();
					clearInterval(interval2);
				}
			  i2++;
			  if(i2 === 20) clearInterval(interval2);
			}, 100);
		}

		if(data['niv3'] != ''){
			let i3 = 0;
			let interval3 = setInterval(() => {
				if($('#xnode-'+data['niv3']).length > 0){
					$('#i_'+data['niv2']).click();
					$('#xnode-'+data['niv3']).click();
					clearInterval(interval3);
				}
			  i3++;
			  if(i3 === 20) clearInterval(interval3);
			}, 100);
		}

		if(data['niv4'] != ''){
			let i4 = 0;
			let interval4 = setInterval(() => {
				if($('#xnode-'+data['niv4']).length > 0){
					$('#i_'+data['niv3']).click();
					$('#xnode-'+data['niv4']).click();
					clearInterval(interval4);
				}
			  i4++;
			  if(i4 === 20) clearInterval(interval4);
			}, 100);
		}
	})
    .fail(function (data) {

    });
}

function send_data_classement(send_data){
	$.ajax({
        type:"POST",
        url:'index.php?module=OPS_classement&action=save_classement',
        dataType: 'json',
        data: {
    	    array_champs: send_data
        }
    })
	.done(function (data) {
		if( data == "save" ){
			location.reload();	
		}else{
			alert('Erreur lors de la sauvegarde');
			location.reload();
		}
	})
    .fail(function (data) {
    	alert('Erreur pendant le traitement');
		location.reload();
    });
}

function get_niveaux_for_type(choix_classement_type){
	
	if( choix_classement_type == '' || choix_classement_type == null){
			
	}else{
		var array_champs = {};
		array_champs['id_type'] = choix_classement_type;
		$.ajax({
            type:"POST",
            url:'index.php?module=OPS_classement&action=get_niveaux_list',
            dataType: 'json',
            data: {
                array_champs: array_champs
            }
        })
    	.done(function (data) {
    		
    		//encodage json + base64 des niveaux et des value pour stockage en base64
    		//niveau1
    		if( data['NIV1'] != null ){

    			$('#treeview' ).append("<ul class='classement_niv1' id='classement_niv1_"+choix_classement_type+"'>");
    			$(".classement_niv1").css("display", "block");
    			for (const [key, value] of Object.entries(data['NIV1'])) {
  					var split_value1 = value.split(' ; ');
  					if( split_value1[0] != "" && split_value1[0] != "undefined" ){
  						var span_niv1 = "<span> "+split_value1[0]+" -</span>"; 
  					}else{
  						var span_niv1 = "";
  					}

  					if(data["NIV2"][key] != undefined){
  						var add_i =  "<i class='fa fa-plus classement_fa niv1_i' id='i_"+key+"' data-id='plus'></i>";
  					}else{
  						var add_i = "<i class='empty_i'></i>";
  					}
  					
  					$('.classement_niv1' ).append("<li id='li_"+key+"' data-id='1'>"+add_i+"<input id='xnode-"+key+"' class='groupe2' name='groupe2' data-id='"+key+"' type='radio' value='"+key+"' /><label id='label_"+key+"' class='label_classement_niv1'>" +span_niv1+ " "+split_value1[1]+"</label></li>");
					
					//Niv2
					$('#li_'+key ).append("<ul class='classement_niv2' id='ul_"+key+"'>");

					if(data['NIV2'] != null){

						Object.keys(data['NIV2']).forEach(function(k_id_niv1) {
							if( key ===  k_id_niv1 ){

								for (const [key_2, value_2] of Object.entries(data['NIV2'][k_id_niv1])) {
									var split_value2 = value_2.split(' ; ');

									if( "1" in split_value2){
  										var span_niv2 = "<span style='font-size:15px'> "+split_value2[0]+" -</span>";
  									}else{
  										var span_niv2 = "";
  									}
  									
  									if(data['NIV3'][key_2] != undefined){
  										var add_i_2 =  "<i class='fa fa-plus classement_fa niv2_i' id='i_"+key_2+"' data-id='plus'></i>";
  									}else{
  										var add_i_2 = "<i class='empty_i'></i>";
  									}
  									
									$('#ul_'+k_id_niv1 ).append("<li id='li_"+key_2+"' data-id='2'>"+add_i_2+"<input id='xnode-"+key_2+"' class='groupe3' name='groupe3' data-id='"+key_2+"' type='radio' value='"+key_2+"' /><label id='label_"+key_2+"' class='label_classement_niv2'> "+span_niv2+" "+split_value2[1]+"  </label></li>");
								
									//Niv3
									$('#li_'+key_2 ).append("<ul class='classement_niv3' id='ul_"+key_2+"'>");

									if(data['NIV3'] != null){

										Object.keys(data['NIV3']).forEach(function(k_id_niv2) {
											if( key_2 ===  k_id_niv2 ){

												for (const [key_3, value_3] of Object.entries(data['NIV3'][k_id_niv2])) {
													var split_value3 = value_3.split(' ; ');
													if( "1" in split_value3 ){
  														var span_niv3 = "<span style='font-size:15px'> "+split_value3[0]+" -</span>";
  													}else{
  														var span_niv3 = "";
  													}

  													if(data['NIV4'][key_3] != undefined){
  														var add_i_3 =  "<i class='fa fa-plus classement_fa niv2_i' id='i_"+key_3+"' data-id='plus'></i>";
  													}else{
  														var add_i_3 = "<i class='empty_i'></i>";
  													}

													$('#ul_'+k_id_niv2 ).append("<li id='li_"+key_3+"' data-id='3'>"+add_i_3+"<input id='xnode-"+key_3+"' name='groupe4' data-id='"+key_3+"' type='radio' value='"+key_3+"' /><label id='label_"+key_3+"' class='label_classement_niv3'> "+span_niv3+" "+split_value3[1]+"  </label></li>");
													
													//Niv4
													$('#li_'+key_3 ).append("<ul class='classement_niv4' id='ul_"+key_3+"'>");
													$("#classement_niv3").css("display", "block");

													if(data['NIV3'] != null){

														Object.keys(data['NIV4']).forEach(function(k_id_niv3) {

															if( key_3 ===  k_id_niv3 ){

																for (const [key_4, value_4] of Object.entries(data['NIV4'][k_id_niv3])) {
																	var split_value4 = value_4.split(' ; ');
																	if( "1" in split_value4 ){
  																		var span_niv4 = "<span style='font-size:15px'> "+split_value4[0]+" -</span>";
  																	}else{
  																		var span_niv4 = "";
  																	}

																	$('#ul_'+k_id_niv3 ).append("<li id='li_"+key_4+"' data-id='4'><input id='xnode-"+key_4+"' name='groupe5' data-id='"+key_4+"' type='radio' value='"+key_4+"' /><label id='label_"+key_4+"' class='label_classement_niv4'> "+span_niv4+" "+split_value4[1]+"  </label></li>");									
																}
															}
        												});
													}
									
												}
											}
        								});
									}	
								}
							}
        				});
					}
				}
    		}
    		//click sur le niveau 1
    		$("input[name='groupe2']").on('click', function(){
    			
    			$("label[class='label_classement_niv1']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv2']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv3']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv4']").each(function() {
					$(this).css("font-weight", "normal");
				})

    			var prec_li = $(this).parents();
    			var id_val_one = $(prec_li[0]).attr("id").substr(3);
    			$('#id_niv_one').val(id_val_one);

				$("input[name='groupe3']").each(function() {
					$(this).removeAttr('checked');
				})

				$("input[name='groupe4']").each(function() {
					$(this).removeAttr('checked');
				})

				$("input[name='groupe5']").each(function() {
					$(this).removeAttr('checked');
				})

				$('#id_niv_two').val('');
				$('#id_niv_three').val('');
				$('#id_niv_four').val('');
			});
    		//click sur le niveau 2
    		$("input[name='groupe3']").on('click', function(){

    			$("label[class='label_classement_niv1']").each(function() {
					$(this).css("font-weight", "normal");
				})
    			$("label[class='label_classement_niv2']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv3']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv4']").each(function() {
					$(this).css("font-weight", "normal");
				})

    			var prec_li = $(this).parents();
    			var id_val_two = $(prec_li[0]).attr("id").substr(3);

    			$('#id_niv_two').val(id_val_two);

    			//auto-checked niv 1
				var id_prec_li = $(prec_li[2]).attr("id");
				var id_val =  id_prec_li.substr(3);
				$('#id_niv_one').val(id_val);
				var id_input = 'xnode-'+id_val;
				$("#"+id_input).prop('checked', 'true');

				//mise en gras de la ligne checked
				$("#label_"+id_val).css("font-weight", "bold");
				$("#label_"+id_val_two).css("font-weight", "bold");
				//fin mise en gras de la ligne checked
				
				$("input[name='groupe4']").each(function() {
					$(this).removeAttr('checked');
				})

				$("input[name='groupe5']").each(function() {
					$(this).removeAttr('checked');
				})

				$('#id_niv_three').val('');
				$('#id_niv_four').val('');
			});
    		//click sur le niveau 3
			$("input[name='groupe4']").on('click', function(){
				
    			$("label[class='label_classement_niv1']").each(function() {
					$(this).css("font-weight", "normal");
				})
    			$("label[class='label_classement_niv2']").each(function() {
					$(this).css("font-weight", "normal");
				})
    			$("label[class='label_classement_niv3']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv4']").each(function() {
					$(this).css("font-weight", "normal");
				})

				var text = $(this).attr('id');
				var text_replace = text.replace("xnode-", "label_");
				$("#"+text_replace).css("font-weight", "bold");

				var prec_li = $(this).parents();
    			var id_val_three = $(prec_li[0]).attr("id").substr(3);
    			$('#id_niv_three').val(id_val_three);

				//auto-checked niv 1
				var id_prec_li_2= $(prec_li[4]).attr("id");
				var id_val_2 =  id_prec_li_2.substr(3);
				$('#id_niv_one').val(id_val_2);
				var id_input_2 = 'xnode-'+id_val_2;
				$("#"+id_input_2).prop('checked', 'true');

				//auto-checked niv 2
				var id_prec_li = $(prec_li[2]).attr("id");
				var id_val =  id_prec_li.substr(3);
				$('#id_niv_two').val(id_val);
				var id_input = 'xnode-'+id_val;
				$("#"+id_input).prop('checked', 'true');

				//mise en gras de la ligne checked
				$("#label_"+id_val).css("font-weight", "bold");
				$("#label_"+id_val_2).css("font-weight", "bold");
				$("#label_"+id_val_three).css("font-weight", "bold");
				//fin mise en gras de la ligne checked

				$("input[name='groupe5']").each(function() {
					$(this).removeAttr('checked');
				})

				$('#id_niv_four').val('');
			});
			//click sur le niveau 4
			$("input[name='groupe5']").on('click', function(){

    			$("label[class='label_classement_niv1']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv2']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv3']").each(function() {
					$(this).css("font-weight", "normal");
				})
				$("label[class='label_classement_niv4']").each(function() {
					$(this).css("font-weight", "normal");
				})
				
				var text = $(this).attr('id');
				var text_replace = text.replace("xnode-", "label_");
				$("#"+text_replace).css("font-weight", "bold");

				var prec_li = $(this).parents();
    			var id_val_four = $(prec_li[0]).attr("id").substr(3);
    			$('#id_niv_four').val(id_val_four);

				//auto-checked niv 1
				var id_prec_li= $(prec_li[6]).attr("id");
				var id_val =  id_prec_li.substr(3);
				$('#id_niv_one').val(id_val);
				var id_input = 'xnode-'+id_val;
				$("#"+id_input).prop('checked', 'true');

				//auto-checked niv 2
				var id_prec_li_2 = $(prec_li[3]).attr("id");
				var id_val_2 =  id_prec_li_2.substr(3);
				$('#id_niv_two').val(id_val_2);
				var id_input_2 = 'xnode-'+id_val_2;
				$("#"+id_input_2).prop('checked', 'true');

				//auto-checked niv 3
				var id_prec_li = $(prec_li[2]).attr("id");
				var id_val_3 =  id_prec_li.substr(3);
				$('#id_niv_three').val(id_val_3);
				var id_input_3 = 'xnode-'+id_val_3;
				$("#"+id_input_3).prop('checked', 'true');

				//mise en gras de la ligne checked
				$("#label_"+id_val).css("font-weight", "bold");
				$("#label_"+id_val_2).css("font-weight", "bold");
				$("#label_"+id_val_3).css("font-weight", "bold");
				$("#label_"+id_val_four).css("font-weight", "bold");
				//fin mise en gras de la ligne checked
			});
			$(".label_classement_niv1").on('click', function(){
				var replace = $(this).attr('id').replace("label", "i");
				$("#"+replace).click();
			});

			$(".label_classement_niv2").on('click', function(){
				var replace_2 = $(this).attr('id').replace("label", "i");
				$("#"+replace_2).click();
			});

			$(".label_classement_niv3").on('click', function(){
				var replace_3 = $(this).attr('id').replace("label", "i");
				$("#"+replace_3).click();
			});        	
   		})
    	.fail(function (data) {
        	
    	});
    }
}