<?php

class OPS_classement extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_classement';
    public $object_name = 'OPS_classement';
    public $table_name = 'ops_classement';
    public $importable = false;
    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }
    

    public static function html_modal()
    {

        $classement_list = get_bean_select_array(true, 'OPS_classement_type','name','deleted=0','name');
        $select_classement = get_select_options_with_id($classement_list, "");
        
        $array_size_select = (is_array($select_classement) ? count($select_classement) : 0);
        
        $modale_html = '<div id="modal-classement" class="modal" tabindex="-1" role="dialog">';
        $modale_html .=     '<div class="modal-dialog" style="max-width: 1200px; width: 1000px;">';
        $modale_html .=         '<div class="modal-content">';

        $modale_html .=             '<div class="modal-header">';
        $modale_html .=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modale_html .=                 '<h4 class="modal-title" id="titre_modal_classement">Classement</h4>';
        $modale_html .=                 '</button>';
        $modale_html .=             '</div>';

        $array_size = (is_array($classement_list) ? count($classement_list) : 0);

        if( $array_size >= 2  ){
           
            
            $modale_html .=         '<div id="modal-classement-body" class="modal-body">';
            $modale_html .=         '<div class="modal-box">';

            $modale_html .=             '<div class="list_classement">
                                            <label style="color:black">Type  </label>
                                            <select name="ext_valeur_type" id="ext_valeur_type">' . $select_classement . '</select>
                                        </div>';

            $modale_html .=             '<div class="col-md-8" id="classement_recherche">
                                            <input type="text"  id="filter" placeholder="Rechercher">
                                        </div>';
            $modale_html .=         '</div>';

            $modale_html .=             '<input id="id_classement" name="id_classement" type="hidden" value="">';
            $modale_html .=             '<input id="id_niv_one" name="id_niv_one" type="hidden" value="">';
            $modale_html .=             '<input id="id_niv_two" name="id_niv_two" type="hidden" value="">';
            $modale_html .=             '<input id="id_niv_three" name="id_niv_three" type="hidden" value="">';
            $modale_html .=             '<input id="id_niv_four" name="id_niv_four" type="hidden" value="">';
            $modale_html .=             '<input id="id_type" name="id_type" type="hidden" value="">';
    

    
            $modale_html .=             '<div id="treeview_container" class="hummingbird-treeview" data-scroll="true">';
            $modale_html .=                 '<ul id="treeview" class="hummingbird-base">';

        
            $modale_html .=     '</ul>';
            $modale_html .= '</div>';
            
            $modale_html .=             '</div>';
               
            $modale_html .=             '<div id="modal-classement-error"></div>';
            $modale_html .=             '<div class="modal-footer">';
            $modale_html .=                 '<button type="button" class="button button-modal button_cancel_class" data-dismiss="modal" id="annuler_modal">Annuler</button>';
            $modale_html .=                 '<button type="button" class="button button-modal button_save_class" id="save_classement">Sauvegarder</button>';
    
            $modale_html .=             '</div>';


        }else{
                 $modale_html .= '<h4 style="color: black; margin-top: 20px; margin-bottom: 20px; margin-left: 10px;" >Aucun classement</h4>';
        }
        $modale_html .=         '</div>';
        $modale_html .=     '</div>';
        $modale_html .= '</div>';


        $modale_html .= '<script src="modules/OPS_classement/js/hummingbird/hummingbird-treeview.js?='.time().'"></script>';
        $modale_html .= '<link rel="stylesheet" href="modules/OPS_classement/css/hummingbird-treeview.min.css" type="text/css">';

        return $modale_html;
    }

    public function get_niveau($id_type_niveau){

        global $db;

        $tabs = array();
        $tabs_niv2 = array();
        $tabs_niv3 = array();
        $tabs_niv4 = array();


        #Récupération des niveaux 1
        $objet_type_classement = BeanFactory::getBean('OPS_classement_type', $id_type_niveau);
        $objet_type_classement->load_relationship('ops_niveau_1_ops_classement_type');
        $type_niv1 = $objet_type_classement->ops_niveau_1_ops_classement_type->get();
        
        foreach($type_niv1 as $key_niv1=>$value_niv1){
            $obj_niv1 = BeanFactory::getBean('OPS_niveau_1', $value_niv1);
            if ( !empty($obj_niv1->code) ){   
                $code = $obj_niv1->code . " ; "; 
            } 
            $tabs_niv1[$obj_niv1->id] = $code ."". $obj_niv1->name;
        }

        #Récupération des niveaux 2
        foreach($tabs_niv1 as $key_niv2=>$value_niv2){
            
            $requete = $db->query(
                "SELECT DISTINCT ops_niveau_2.id, ops_niveau_2.name, ops_niveau_2.code 
                 FROM ops_niveau_2
                 INNER JOIN ops_niveau_2_ops_niveau_1 ON ops_niveau_2.id = ops_niveau_2_ops_niveau_1.ops_niveau_2_id
                 WHERE ops_niveau_2_ops_niveau_1.ops_niveau_1_id = '". $key_niv2 ."'
                 AND ops_niveau_2.deleted = 0 ORDER BY name;"
            );

            $tab_niv2 = array();
            if( $requete->num_rows != 0 ){
                while ($row1 = $db->fetchRow($requete)) {
                    if ( !empty($row1['code']) ){   
                        $code1 = $row1['code'] . " ; "; 
                    } 
                    $tab_niv2[$row1['id']] = $code1 . "" . $row1['name'];                     
                }
    
                $tabs_niv2[$key_niv2] = $tab_niv2;
            }
        }

        #Récupération des niveaux 3
        foreach($tabs_niv2 as $first_key_niv3){
            foreach( $first_key_niv3 as $key_niv3 => $value_niv3 ){
               
                $requete = $db->query(
                    "SELECT DISTINCT ops_niveau_3.id, ops_niveau_3.name, ops_niveau_3.code  
                    FROM ops_niveau_3
                    INNER JOIN ops_niveau_3_ops_niveau_2 ON ops_niveau_3.id = ops_niveau_3_ops_niveau_2.ops_niveau_3_id
                    WHERE ops_niveau_3_ops_niveau_2.ops_niveau_2_id = '". $key_niv3 ."'
                    AND ops_niveau_3.deleted = 0 ORDER BY name;"
                );

                $tab_niv3 = array();
                if( $requete->num_rows != 0 ){
                    while ($row2 = $db->fetchRow($requete)) {
                        if ( !empty($row2['code']) ){   
                            $code2 =   $row2['code'] . " ; "; 
                        } 
                        $tab_niv3[$row2['id']] = $code2 . "" . $row2['name'];                     
                    }
                    $tabs_niv3[$key_niv3] = $tab_niv3;
                }    
            }  
        }
        
        #Récupération des niveaux 4
        foreach($tabs_niv3 as $first_key_niv4){
            foreach( $first_key_niv4 as $key_niv4 => $value_niv4 ){
               
                $requete = $db->query(
                    "SELECT DISTINCT ops_niveau_4.id, ops_niveau_4.name, ops_niveau_4.code 
                    FROM ops_niveau_4
                    INNER JOIN ops_niveau_4_ops_niveau_3 ON ops_niveau_4.id = ops_niveau_4_ops_niveau_3.ops_niveau_4_id
                    WHERE ops_niveau_4_ops_niveau_3.ops_niveau_3_id = '". $key_niv4 ."'
                    AND ops_niveau_4.deleted = 0 ORDER BY name;"
                );

                $tab_niv4 = array();
                if( $requete->num_rows != 0 ){
                    while ($row3 = $db->fetchRow($requete)) {
                        if ( !empty($row3['code']) ){   
                            $code3 = $row3['code'] . " ; "; 
                        } 
                        $tab_niv4[$row3['id']] = $code3 . "" . $row3['name'];                     
                    }
                    $tabs_niv4[$key_niv4] = $tab_niv4;
                }
            }    
        }

        asort($tabs_niv1);
        
        //tri niv2
        $new_tabs_niv2 = array();
        foreach($tabs_niv2 as $key => $tab){
            asort($tab);
            $new_tabs_niv2[$key]=$tab;
        }

        //tri niv3
        $new_tabs_niv3 = array();
        foreach($tabs_niv3 as $key => $tab){
            asort($tab);
            $new_tabs_niv3[$key]=$tab;
        }

        //tri niv4
        $new_tabs_niv4 = array();
        foreach($tabs_niv4 as $key => $tab){
            asort($tab);
            $new_tabs_niv4[$key]=$tab;
        }
        
        $tabs['NIV1']   = $tabs_niv1;
        $tabs['NIV2']   = $new_tabs_niv2;
        $tabs['NIV3']   = $new_tabs_niv3;
        $tabs['NIV4']   = $new_tabs_niv4;

        return $tabs;
    }


     public function save_classement($data_send){

        $retour = "error";
        if( !empty($data_send["id_dossier"]) && !empty($data_send["id_type"]) ){
            
            if( empty($data_send['id_classement']) ){

                $obj_type = BeanFactory::getBean("OPS_classement_type", $data_send["id_type"]);

                $obj_classement = BeanFactory::newBean("OPS_classement");
                $obj_classement->name = $obj_type->name;
                $obj_classement->classement_type_id = $data_send["id_type"];
                $obj_classement->niveau_1_id = $data_send["id_niv_one"];
                $obj_classement->niveau_2_id = $data_send["id_niv_two"];
                $obj_classement->niveau_3_id = $data_send["id_niv_three"];
                $obj_classement->niveau_4_id = $data_send["id_niv_four"];
                $classement_id = $obj_classement->save();
                $obj_dossier = BeanFactory::getBean("OPS_dossier", $data_send["id_dossier"]);

                if (!empty($obj_dossier->id)) {

                    $obj_dossier->load_relationship("ops_classement_ops_dossier");
                    $id_validation = $obj_dossier->ops_classement_ops_dossier->add($classement_id);

                    if($id_validation == 1){
                        $retour = "save";
                    }
                }
            }else{
                
                $obj_classement = BeanFactory::getBean("OPS_classement", $data_send["id_classement"]);
                if( isset($obj_classement->id) && $obj_classement->deleted == 0 ){

                    $obj_type = BeanFactory::getBean("OPS_classement_type", $data_send["id_type"]);
                     
                    $obj_classement->name = $obj_type->name;
                    $obj_classement->classement_type_id = $data_send["id_type"];
                    $obj_classement->niveau_1_id = $data_send["id_niv_one"];
                    $obj_classement->niveau_2_id = $data_send["id_niv_two"];
                    $obj_classement->niveau_3_id = $data_send["id_niv_three"];
                    $obj_classement->niveau_4_id = $data_send["id_niv_four"];
                    $obj_classement->save();

                    if( isset( $obj_classement->id ) && strlen( $obj_classement->id ) == 36 ){
                        $retour = "save";
                    }
                }                 
            }
        }
        return $retour;
     }


     public function get_classement_by_id($data_id){
        
        $objet_classement = BeanFactory::getBean('OPS_classement', $data_id['id_classement']);

        $tab_id_niv = array();
        $tab_id_niv['type'] = $objet_classement->classement_type_id;
        $tab_id_niv['niv1'] = $objet_classement->niveau_1_id;
        $tab_id_niv['niv2'] = $objet_classement->niveau_2_id;
        $tab_id_niv['niv3'] = $objet_classement->niveau_3_id;
        $tab_id_niv['niv4'] = $objet_classement->niveau_4_id;

        return $tab_id_niv;
     }

}
