<?php

if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');

class OPS_calendrier_gardeViewDetail extends ViewDetail 
{
    public function __construct()
    {
        parent::__construct();
    }

    function display()
    {
        global $app_strings;

        if(empty($this->bean->id)){
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $family1 = BeanFactory::getBean('OPS_personne_morale_individu', $this->bean->ops_personne_morale_individu_id);
        $family2 = BeanFactory::getBean('OPS_personne_morale_individu', $this->bean->ops_personne_morale_individu_id2);

        $familyHtml1 = '';
        if( !empty($family1) )
        {
            $familyHtml1 = '<input type="hidden" id="famille_1" name="famille_1" value="' . $family1->id . '"><input type="hidden" id="famille_1_couleur" name="famille_1_couleur" value="#1C996C"><input type="hidden" id="famille_1_name" name="famille_1_name" value="' . $family1->ops_personne_morale_ops_personne_morale_individu_name . '">' ;
        }

        $familyHtml2 = '';
        if( !empty($family2) )
        {
            $familyHtml2 = '<input type="hidden" id="famille_2" name="famille_2" value="' . $family2->id . '"><input type="hidden" id="famille_2_couleur" name="famille_2_couleur" value="#ff9f89"><input type="hidden" id="famille_2_name" name="famille_2_name" value="' . $family2->ops_personne_morale_ops_personne_morale_individu_name . '">';
        }

        $this->ss->assign('famille_1',  $familyHtml1);
        $this->ss->assign('famille_2',  $familyHtml2);
        $this->ss->assign('event_list', $this->bean->event_list);

        echo '<link href="custom/include/javascript/fullcalendar/fullcalendar.min.css" rel="stylesheet"/>';
        echo '<link href="custom/include/javascript/fullcalendar/fullcalendar.print.min.css" rel="stylesheet" media="print" />';

        echo '<link href="modules/OPS_calendrier_garde/css/calendrier.css" rel="stylesheet"/>';

        parent::display();
    }

    function preDisplay()
    {    
        global $db;

        if(empty($_REQUEST['record']) && !empty($_REQUEST['relation_id']))
        {
            $bean_relation = BeanFactory::getBean('OPS_personne_morale_individu', $_REQUEST['relation_id']);
            if(!empty($bean_relation->id) && $bean_relation->role == 'enfant' && in_array($bean_relation->mode_garde, ['alternee', 'partagee']))
            {
                $query = 'SELECT DISTINCT ops_calendrier_garde_id
                          FROM ops_personne_morale_individu_ops_calendrier_garde per_mo_cal
                          LEFT JOIN ops_personne_morale_individu per_mo_ind ON per_mo_ind.id = per_mo_cal.ops_personne_morale_individu_id AND per_mo_ind.deleted = 0
                          LEFT JOIN ops_individu_ops_personne_morale_individu indi_per_mo ON indi_per_mo.ops_personne_morale_individu_id = per_mo_ind.id AND indi_per_mo.deleted = 0
                          WHERE 
                          indi_per_mo.ops_individu_id = "' . $bean_relation->ops_individu_id . '" 
                          AND 
                          per_mo_ind.role = "enfant" AND (per_mo_ind.mode_garde = "alternee" OR per_mo_ind.mode_garde = "partagee") AND per_mo_cal.deleted = 0
                          UNION
                          SELECT DISTINCT ops_calendrier_garde_id
                          FROM ops_personne_morale_individu_2_ops_calendrier_garde per_mo_cal
                          LEFT JOIN ops_personne_morale_individu per_mo_ind ON per_mo_ind.id = per_mo_cal.ops_personne_morale_individu_id2 AND per_mo_ind.deleted = 0
                          LEFT JOIN ops_individu_ops_personne_morale_individu indi_per_mo ON indi_per_mo.ops_personne_morale_individu_id = per_mo_ind.id AND indi_per_mo.deleted = 0
                          WHERE 
                          indi_per_mo.ops_individu_id = "' . $bean_relation->ops_individu_id . '" 
                          AND 
                          per_mo_ind.role = "enfant" AND (per_mo_ind.mode_garde = "alternee" OR per_mo_ind.mode_garde = "partagee") AND per_mo_cal.deleted = 0';

                $result = $db->query($query);

                if($result->num_rows == 0)
                {
                    $bean = BeanFactory::newBean('OPS_calendrier_garde');
                    $bean->name = $bean_relation->ops_individu_ops_personne_morale_individu_name;
                    $bean->save();
                    
                    $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
                    $bean->ops_personne_morale_individu_ops_calendrier_garde->add($bean_relation);
                    $bean->ops_personne_morale_individu_id = $bean_relation->id;
                }
                else
                {
                    $result = $db->fetchByAssoc($result);
                    $bean = BeanFactory::getBean('OPS_calendrier_garde', $result['ops_calendrier_garde_id']);
                }
            }
            else
            {
                $GLOBALS['log']->fatal('OPS_calendrier_garde::preDisplay => La relation avec l\'individu n\'est pas un enfant ou n\'a pas de mode de garde égale à Alternée ou Partagée');

                SugarApplication::redirect('index.php?module=OPS_individu&action=index');
            }
        }
        else if(!empty($_REQUEST['record']))
        {
            $bean = BeanFactory::getBean('OPS_calendrier_garde', $_REQUEST['record']);
            if(!empty($bean->ops_personne_morale_individu_id))
            {
                $bean_relation = BeanFactory::getBean('OPS_personne_morale_individu', $bean->ops_personne_morale_individu_id);
            }
            else if(!empty($bean->ops_personne_morale_individu_id2))
            {
                $bean_relation = BeanFactory::getBean('OPS_personne_morale_individu', $bean->ops_personne_morale_individu_id2);
            }
        }

        if(isset($bean_relation) && !empty($bean_relation->id) && (empty($bean->ops_personne_morale_individu_id) || empty($bean->ops_personne_morale_individu_id2)) )
        {
            $query = 'SELECT pmi.id
                      FROM ops_personne_morale_individu pmi
                      LEFT JOIN ops_individu_ops_personne_morale_individu  ipmi ON ipmi.ops_personne_morale_individu_id = pmi.id AND ipmi.deleted = 0
                      JOIN ops_personne_morale_ops_personne_morale_individu pmpmi ON pmpmi.ops_personne_morale_individu_id = ipmi.ops_personne_morale_individu_id AND pmpmi.deleted = 0
                      WHERE role = "enfant" AND (mode_garde = "alternee" OR mode_garde = "partagee")
                      AND 
                      ipmi.ops_individu_id = (SELECT ops_individu_id
                                              FROM ops_individu_ops_personne_morale_individu 
                                              WHERE ops_personne_morale_individu_id = "' . $bean_relation->id . '" AND deleted = 0) 
                      AND 
                      pmpmi.ops_personne_morale_id <> (SELECT ops_personne_morale_id 
                                                       FROM ops_personne_morale_ops_personne_morale_individu 
                                                       WHERE ops_personne_morale_individu_id = "' . $bean_relation->id . '" AND deleted = 0)
                      AND
                      pmi.deleted = 0';

            $result = $db->query($query);

            if($result->num_rows != 0)
            {
                $result = $db->fetchByAssoc($result);

                if(empty($bean->ops_personne_morale_individu_id) && (empty($bean->ops_personne_morale_individu_id2) || $bean->ops_personne_morale_individu_id2 != $result['id']) )
                {
                    $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
                    $bean->ops_personne_morale_individu_ops_calendrier_garde->add($result['id']);
                    $bean->ops_personne_morale_individu_id = $result['id'];
                }
                else if(empty($bean->ops_personne_morale_individu_id2) && (empty($bean->ops_personne_morale_individu_id) || $bean->ops_personne_morale_individu_id != $result['id']) )
                {
                    $bean->load_relationship('ops_personne_morale_individu_2_ops_calendrier_garde');
                    $bean->ops_personne_morale_individu_2_ops_calendrier_garde->add($result['id']);
                    $bean->ops_personne_morale_individu_id2 = $result['id'];
                }
            }
        }
        $this->bean = $bean;

        parent::preDisplay();
    }
}