<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\DocumentResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;

use ODE_API\V8\Param\TiersListParams;
use ODE_API\V8\Param\TiersTypeInfosParams;
use ODE_API\V8\Param\TiersDetailParams;
use ODE_API\V8\Param\TiersEditionParams;
use ODE_API\V8\Param\TiersListIndividusParams;
use ODE_API\V8\Param\TiersIndividuDetailParams;
use ODE_API\V8\Param\TiersIndividuEditionParams;
use ODE_API\V8\Param\TiersRoleUpdateParams;

use ODE_API\V8\Param\TiersPartageDeleteParams;
use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;
use Exception;
use Slim\Http\Request;
use Datetime;
use DateTimeZone;

class TiersService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;
    
    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;
    
    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;
    
    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;
    
    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }
    
    
    /**
     * getTypeTiers
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     * Implémentation #2526
     */
    public function getTypeTiers(Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $requete = $db->query("
            SELECT  ops_type_personne.id,
                    ops_type_personne.name as type_profil,
                    ops_type_personne.libelle_usager,
                    ops_type_personne.couleur,
                    ops_type_personne.icone,
                    ops_type_personne.visible_usager,
                    ops_type_personne.creation_usager,
                    ops_type_personne.api,

                    ops_type_personne.flag_valeur_1,
                    ops_type_personne.flag_valeur_2,
                    ops_type_personne.flag_valeur_3

            FROM ops_type_personne
            WHERE ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_type_personne`.`name` ASC ");
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            $rowResults[$row['id']] = $row;
        }
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $response;
    }
    
    
    /**
     * getTypeTiers
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getRoleTiers(Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $role = $app_list_strings['ops_role_list'];
        
        return $role;
    }
    
    
    /**
     * getTypeTiersInfos
     * @param TiersTypeInfosParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getTypeTiersInfos(TiersTypeInfosParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $id_type = $params->getId();
        
        try {
            $obj_type_tiers = $this->beanManager->getBeanSafe("OPS_type_personne", $id_type);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        $tab_tiers['libelle_usager']          = $obj_type_tiers->libelle_usager;
        $tab_tiers['couleur']                 = $obj_type_tiers->couleur;
        $tab_tiers['icone']                   = $obj_type_tiers->icone;
        $tab_tiers['visible_usager']          = $obj_type_tiers->visible_usager;
        $tab_tiers['creation_usager']         = $obj_type_tiers->creation_usager;
        $tab_tiers['api']                     = $obj_type_tiers->api;
        $tab_tiers['bouton_passer_recherche'] = $obj_type_tiers->bouton_passer_recherche;
        $tab_tiers['agrements_relations']     = $obj_type_tiers->display_relation;
        $tab_tiers['informations_fiscales']   = $obj_type_tiers->display_info_fiscales;

        // Vérification d'activation de l'API BAN
        $tab_tiers["disable_api_ban"] = isset($sugar_config['opensocle']['disable_api_ban']) && !empty($sugar_config['opensocle']['disable_api_ban']) ? $sugar_config['opensocle']['disable_api_ban'] : 0;

        // Implémentation #2526
        $tab_tiers['flag_valeur_1'] = $obj_type_tiers->flag_valeur_1;
        $tab_tiers['flag_valeur_2'] = $obj_type_tiers->flag_valeur_2;
        $tab_tiers['flag_valeur_3'] = $obj_type_tiers->flag_valeur_3;

        $tab_tiers['modification_membre']  = $obj_type_tiers->modification_membre;
        $tab_tiers['modification_usager']  = $obj_type_tiers->modification_usager;

        $tab_tiers['adulte']  = $obj_type_tiers->creation_membre;
        $tab_tiers['enfant']  = $obj_type_tiers->creation_enfant;
        $tab_tiers['contact'] = $obj_type_tiers->creation_contact;
        
        $tab_tiers['champs'] = $obj_type_tiers->getChamps();
        
        $response = new DocumentResponse();
        $response->setData($tab_tiers);
        
        return $response;
    }
    
    /**
     * getListTiers
     * @param TiersListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getListTiers(TiersListParams $params, Request $request)
    {        
        $id_usager = $params->getId();
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $obj_personne_morale = \BeanFactory::newBean("OPS_personne_morale");
        $liste_tiers['profils'] = $obj_personne_morale->get_profil_by_individu($id_usager);


        foreach ($liste_tiers['profils'] as $tier) {
            $obj_type_tier = $this->beanManager->getBeanSafe("OPS_type_personne", $tier['id_type']);

            $liste_tiers['filtres']['types_profils'][$obj_type_tier->id]['name'] = $obj_type_tier->name; 
            $liste_tiers['filtres']['types_profils'][$obj_type_tier->id]['nombre'] += 1;
        }
        
        $response = new DocumentResponse();
        $response->setData($liste_tiers);
        
        return $response;
    }
    
    
    /**
     * getDetailTiers
     * @param TiersDetailParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getDetailTiers(TiersDetailParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        

        $id_objet  = $params->getId(); // ID PROFIL
        $id_usager = $params->getIndividuId();
        $date_time_zone   = new DateTimeZone('Europe/Paris');

        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_objet);
        }
        catch (\Exception $exception) {
            throw new Exception('Profil inconnu', 401);
        }

        // TO DO : ops_type_personne.annuaire as annuaire,
        /// ops_type_personne.annuaire_dispositif_id as annuaire_dispositif_id,

        $requete = $db->query("
            SELECT  ops_personne_morale.id, 
                    ops_personne_morale.name,
                    ops_personne_morale.billing_address_state,
                    ops_personne_morale.billing_address_number,
                    ops_personne_morale.billing_address_street,
                    ops_personne_morale.billing_address_complement,
                    ops_personne_morale.billing_address_complement_lieu,
                    ops_personne_morale.billing_address_city,
                    ops_personne_morale.billing_address_state,
                    ops_personne_morale.billing_address_postalcode,
                    ops_personne_morale.billing_address_country,
                    ops_personne_morale.billing_coordonnees_x,
                    ops_personne_morale.billing_coordonnees_y,
                    ops_personne_morale.phone_office,
                    ops_personne_morale.phone_alternate,
                    ops_personne_morale.website,
                    ops_personne_morale.adresse_date_validite,
                    ops_personne_morale.adresse_hors_commune,
                    ops_personne_morale.shipping_address_number,
                    ops_personne_morale.shipping_address_street,
                    ops_personne_morale.shipping_address_complement,
                    ops_personne_morale.shipping_address_complement_lieu,
                    ops_personne_morale.shipping_address_city,
                    ops_personne_morale.shipping_address_state,
                    ops_personne_morale.shipping_address_postalcode,
                    ops_personne_morale.shipping_address_country,
                    ops_personne_morale.shipping_address_coordonnees_x,
                    ops_personne_morale.shipping_address_coordonnees_y,
                    ops_personne_morale.sigle,
                    ops_personne_morale.tiers_appaire,
                    ops_personne_morale.siret,
                    ops_personne_morale.num_tahiti,
                    ops_personne_morale.reference,
                    ops_personne_morale.numero_rna,
                    ops_personne_morale.date_declaration,
                    ops_personne_morale.numero_rne,
                    ops_personne_morale.statut,
                    ops_personne_morale.ops_individu_id,
                    ops_personne_morale.ops_individu1_id,
                    ops_personne_morale.code_ape,
                    ops_personne_morale.forme_juridique,
                    ops_personne_morale.objet_social,
                    ops_personne_morale.canal,
                    ops_personne_morale.numero_fiscale,
                    ops_personne_morale.regime_allocataire,
                    ops_personne_morale.numero_allocataire,
                    ops_personne_morale.qf_caf_actuel,
                    ops_personne_morale.qf_ville_actuel,
                    ops_personne_morale.date_application,
                    ops_personne_morale.agrement_administratif,
                    ops_personne_morale.detail_agrement,
                    ops_personne_morale.utilite_publique,
                    ops_personne_morale.date_utilite_publique,
                    ops_personne_morale.affiliee_reseau,
                    ops_personne_morale.detail_affiliation,
                    ops_personne_morale.situation_handicap,
                    ops_personne_morale.effectif,
                    ops_personne_morale.secteur_activite,
                    ops_personne_morale.publie,
                    ops_personne_morale.thematique,
                    ops_personne_morale.accroche,
                    ops_personne_morale.description_annuaire,
                    ops_personne_morale.activites,
                    ops_personne_morale.tarifs,
                    ops_personne_morale.public_beneficiaire,
                    ops_personne_morale.image,
                    ops_type_personne.id as type_id,
                    ops_type_personne.name as type_profil,
                    ops_type_personne.libelle_usager,
                    ops_type_personne.date_declaration as date_declaration_visu,
                    ops_type_personne.numero_rna as numero_rna_visu,
                    ops_type_personne.siret as siret_visu,
                    ops_type_personne.num_tahiti as num_tahiti_visu,
                    ops_type_personne.numero_rne as numero_rne_visu,
                    ops_type_personne.code_ape as code_ape_visu,
                    ops_type_personne.objet_social as objet_social_visu,
                    ops_type_personne.sigle as sigle_visu,
                    ops_type_personne.website as website_visu,
                    ops_type_personne.forme_juridique as forme_juridique_visu,
                    ops_type_personne.forme_juridique_liste as forme_juridique_liste,
                    ops_type_personne.couleur,
                    ops_type_personne.icone,
                    ops_type_personne.api,
                    ops_type_personne.creation_membre as adulte,
                    ops_type_personne.creation_enfant as enfant,
                    ops_type_personne.creation_contact as contact,
                    ops_type_personne.modification_usager,
                    ops_type_personne.modification_membre,
                    ops_type_personne.date_modified,
                    ops_type_personne.ops_dispositif_annuaire_id as ops_annuaire_dispositif_id,
                    ops_personne_morale_individu.responsable,
                    ops_personne_morale_individu.role

            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_usager . "'
            AND ops_personne_morale.id =  '" . $id_objet . "'
            AND ops_personne_morale_individu.acces_usager = 1
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` DESC ");
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $row['id']);

            if (!empty($row['forme_juridique'])) {
                $row['forme_juridique'] = $app_list_strings['ops_forme_juridique_list'][$row['forme_juridique']];
            }

            if (!empty($row['effectif'])) {
                $row['effectif'] = $app_list_strings['ops_type_profil_effectif_list'][$row['effectif']];
            }
            
            if (!empty($row['secteur_activite'])) {
                $row['secteur_activite'] = $app_list_strings['ops_profil_secteur_activite_list'][$row['secteur_activite']];
            }

            if (!empty($row['regime_allocataire'])) {
                $row['regime_allocataire'] = $app_list_strings['ops_regime_allocataire_list'][$row['regime_allocataire']];
            }

            if( !empty($row['date_declaration']) ){
                $date_declaration  = new DateTime( $row['date_declaration'] , $date_time_zone);
                $row['date_declaration'] = $date_declaration->format('d/m/Y');
            }

            if( !empty($row['adresse_date_validite']) ){  
                $adresse_date_validite  = new DateTime( $row['adresse_date_validite'] , $date_time_zone);
                $row['adresse_date_validite'] = $adresse_date_validite->format('d/m/Y');
            }

            if( !empty($row['date_utilite_publique']) ){  
                $date_utilite_publique  = new DateTime( $row['date_utilite_publique'] , $date_time_zone);
                $row['date_utilite_publique'] = $date_utilite_publique->format('d/m/Y');
            }

            if( !empty($row['date_application']) ){  
                $date_application  = new DateTime( $row['date_application'] , $date_time_zone);
                $row['date_application'] = $date_application->format('d/m/Y');
            }
            
            $row['email1'] = $obj_module->email1;


            // Implémentation #2526.
            // Permet de venir surcharger plus clairement et proprement les propriétés utiles que de les intégrer dans le SQL.
            // Le retour de tuples impliquerait dans tous les cas un contrôle pour les vides non null (les flags sont potentiellement variants) (impossible à vérifier)
            if( get_class( $obj_module ) == 'OPS_personne_morale' ){
                $obj_module->load_relationship('ops_type_personne_ops_personne_morale');
                $obj_module_type = array_shift( $obj_module->ops_type_personne_ops_personne_morale->getBeans() ); // Array d'Objects (relation OneToMany)
        
                $row['flag_valeur_1'] = $obj_module_type->flag_valeur_1;
                $row['flag_valeur_2'] = $obj_module_type->flag_valeur_2;
                $row['flag_valeur_3'] = $obj_module_type->flag_valeur_3;
            }
            
            $rowResults[$row['id']] = $row;
        }
        
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $response;
    }
    
    
    /**
     * setTiers
     * @param TiersEditionParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function setTiers(TiersEditionParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $creation = false; 
        
        $parametres = $params->getData();
        
        // Paramètres 
        $id_usager   = $parametres["id_usager"];
        $id_objet    = $parametres["datas"]["id_profil"];
        $datas_tiers = $parametres["datas"];
        
        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        // Dans le cadre d'une modification
        if( !empty($id_objet) ){
            try {
                $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_objet);
            }
            catch (\Exception $exception) {
                throw new Exception('Profil inconnu', 401);
            }
        }
        else{
            $obj_module = $this->beanManager->newBeanSafe('OPS_personne_morale');
            $creation = true; 
        }
        
        foreach ($datas_tiers as $key => $value) {
            if( $key == "raison_sociale" ){
                $key = "name";
            }
            $obj_module->$key = stripslashes($value); 
        }

        $verif_unicite = $obj_module->verif_unicite();

        if( empty($verif_unicite) ){

            $obj_module->canal = 'internet'; 
            $retour['id'] = $obj_module->save();

            if( $creation && !empty($retour['id']) ){
                $role = $datas_tiers['role']; 

                $obj_relation = $this->beanManager->newBeanSafe('OPS_personne_morale_individu');
                if (empty($role)) $role = 'membre'; // role par defaut

                $obj_relation->ops_individu_id        = $obj_individu->id;
                $obj_relation->ops_personne_morale_id  = $retour['id'];
                $obj_relation->role                 = $role;
                $obj_relation->acces_usager         = true;
                $obj_relation->responsable          = true;
                $obj_relation->save();

                $template = $sugar_config['opensocle']['notif_usager_profil_creation'];


            }
            else{
                 $template = $sugar_config['opensocle']['notif_usager_profil_modification'];
            }


            if( isset($template) && !empty($template) ){
                $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $retour['id']);

                # On initialise le mailer 
                $mailer = new OdeMailer();

                # On initialise l'email 
                $ode_email = new OdeEmail([
                    'bean_source_id' => $obj_module->id,
                    'bean_source_name' => 'OPS_personne_morale',
                    'bean_historisation_id' => $obj_module->id,
                    'bean_historisation_name' => 'OPS_personne_morale',
                    'email_template_id' => $template,
                    'dest_to' => $obj_module->email1,
                ]);

                # On déclenche l'envoie
                $mailer->send($ode_email);
            }
            else{
                $GLOBALS['log']->fatal( "TiersService - sendNotification : Pas te template mail associé à la création/modification d'un profil" );
            }

        }
        else{
            
            $retour ['erreur'] = $verif_unicite;
            
        }
        $response = new DocumentResponse();
        $response->setData($retour);
        
        return $response;
    }
    



    /**
     * getListIndividuByTiers
     * @param TiersListIndividusParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getListIndividuByTiers(TiersListIndividusParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $id_objet  = $params->getId(); // ID PROFIL
        $id_usager = $params->getIndividuId();
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_objet);
        }
        catch (\Exception $exception) {
            throw new Exception('Profil inconnu', 401);
        }
        
        $requete = $db->query("
            SELECT  ops_personne_morale_individu.id, 
                    ops_personne_morale_individu.name, 
                    ops_personne_morale_individu.role, 
                    ops_personne_morale_individu.statut_clef, 
                    ops_personne_morale_individu.date_expiration, 
                    ops_personne_morale_individu.acces_usager, 
                    ops_personne_morale_individu.clef,
                    ops_individu.id as individu_id,
                    ops_personne_morale_individu.responsable,
                    ops_personne_morale_individu.role
            FROM ops_personne_morale_individu, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu , ops_individu, ops_personne_morale
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_personne_morale_individu.id  = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id
            AND ops_personne_morale_individu.id = ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id =  '" . $id_objet . "'
            AND ops_individu_ops_personne_morale_individu.ops_individu_id = ops_individu.id
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_individu.deleted = 0
            AND ops_personne_morale.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            ORDER BY ops_individu.last_name , ops_individu.first_name ");
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            
            if (!empty($row['statut_cle'])) {
                $row['statut_cle'] = $app_list_strings['ops_statut_clef_list'][$row['statut_cle']];
            }
            
            if (!empty($row['role'])) {
                $row['role'] = $app_list_strings['ops_role_list'][$row['role']];
            }
            
            $obj_individu               = $this->beanManager->getBeanSafe("OPS_individu", $row['individu_id']);
            $row['individu_salutation'] = $app_list_strings['salutation_dom'][$obj_individu->salutation];
            $row['individu_first_name']     = $obj_individu->first_name;
            $row['individu_last_name']      = $obj_individu->last_name;
            $row['individu_etat']           = $obj_individu->etat;
            $row['individu_etat_libelle']   = $app_list_strings['ops_etat_individu_list'][$obj_individu->etat];
            $row['individu_date_naissance'] = $obj_individu->date_naissance;
            $row['individu_email']          = $obj_individu->email1;
            $row['individu_phone_mobile']   = $obj_individu->phone_mobile;
            $row['individu_phone_home']   = $obj_individu->phone_home;
            $row['individu_statut_compte']  = $obj_individu->statut_compte;
            $row['individu_type']           = $obj_individu->type_individu;
            $row['individu_type_label']     = $app_list_strings['ops_type_individu_list'][$obj_individu->type_individu];
            $rowResults[$row['id']]         = $row;
        }
        
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $response;
    }
    
    


    /**
     * getIndividu
     * @param TiersIndividuDetailParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getIndividu(TiersIndividuDetailParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $id_objet  = $params->getId(); // ID Individu 
        $id_usager = $params->getIndividuId();
        $date_time_zone   = new DateTimeZone('Europe/Paris');
        $rowResults = array();
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_objet);
        }
        catch (\Exception $exception) {
            throw new Exception('Individu inconnu', 401);
        }
            
        $relations = $obj_individu->get_linked_beans('ops_individu_ops_personne_morale_individu' , 'OPS_personne_morale_individu');

        $rowResults[$obj_individu->id]['id'] = $obj_individu->id;

        // Généralités
        $rowResults[$obj_individu->id]['type_individu']       = $obj_individu->type_individu;
        $rowResults[$obj_individu->id]['salutation']          = $obj_individu->salutation;
        $rowResults[$obj_individu->id]['sexe']                = $obj_individu->sexe;
        $rowResults[$obj_individu->id]['last_name']           = $obj_individu->last_name;
        $rowResults[$obj_individu->id]['first_name']          = $obj_individu->first_name;
        $rowResults[$obj_individu->id]['nom_usage']           = $obj_individu->nom_usage;
        $rowResults[$obj_individu->id]['situation_familiale'] = $obj_individu->situation_familiale;
        $rowResults[$obj_individu->id]['etat']                = $obj_individu->etat;
        $rowResults[$obj_individu->id]['nationalite']         = $obj_individu->nationalite;
        $rowResults[$obj_individu->id]['date_naissance']      = $obj_individu->date_naissance;
        $rowResults[$obj_individu->id]['lieu_naissance']      = $obj_individu->lieu_naissance;
        $rowResults[$obj_individu->id]['pays_naissance']      = $obj_individu->pays_naissance;
        $rowResults[$obj_individu->id]['representant_parent'] = $obj_individu->representant_parent;

        // Autorisations et attestations
        $rowResults[$obj_individu->id]['production_diffusion_image'] = $obj_individu->production_diffusion_image;
        $rowResults[$obj_individu->id]['diffusion_caf']              = $obj_individu->diffusion_caf;
        $rowResults[$obj_individu->id]['attestation_assurance']      = $obj_individu->attestation_assurance;

        // Fiche santé
        $rowResults[$obj_individu->id]['handicap']                  = $obj_individu->handicap;
        $rowResults[$obj_individu->id]['aide_handicap']             = $obj_individu->aide_handicap;
        $rowResults[$obj_individu->id]['vaccin_a_jour']             = $obj_individu->vaccin_a_jour;
        $rowResults[$obj_individu->id]['medecin_traitant']          = $obj_individu->medecin_traitant;
        $rowResults[$obj_individu->id]['presence_trouble_consigne'] = $obj_individu->presence_trouble_consigne;

        // Moyens de contact
        $rowResults[$obj_individu->id]['email1']                              = $obj_individu->email1;
        $rowResults[$obj_individu->id]['phone_mobile']                        = $obj_individu->phone_mobile;
        $rowResults[$obj_individu->id]['phone_home']                          = $obj_individu->phone_home;
        $rowResults[$obj_individu->id]['phone_work']                          = $obj_individu->phone_work;
        $rowResults[$obj_individu->id]['phone_other']                         = $obj_individu->phone_other;
        $rowResults[$obj_individu->id]['accepte_mail']                        = $obj_individu->accepte_mail;
        $rowResults[$obj_individu->id]['accepte_sms']                         = $obj_individu->accepte_sms;
        $rowResults[$obj_individu->id]['primary_address_number']              = $obj_individu->primary_address_number;
        $rowResults[$obj_individu->id]['primary_address_street']              = $obj_individu->primary_address_street;
        $rowResults[$obj_individu->id]['primary_address_complement_batiment'] = $obj_individu->primary_address_complement_batiment;
        $rowResults[$obj_individu->id]['primary_address_complement_lieu']     = $obj_individu->primary_address_complement_lieu;
        $rowResults[$obj_individu->id]['primary_address_postalcode']          = $obj_individu->primary_address_postalcode;
        $rowResults[$obj_individu->id]['primary_address_city']                = $obj_individu->primary_address_city;

        // Situation professionnelle
        $rowResults[$obj_individu->id]['profession_pcs']              = $obj_individu->profession_pcs;
        $rowResults[$obj_individu->id]['nom_employeur']               = $obj_individu->nom_employeur;
        $rowResults[$obj_individu->id]['adresse_num']                 = $obj_individu->adresse_num;
        $rowResults[$obj_individu->id]['adresse_voie']                = $obj_individu->adresse_voie;
        $rowResults[$obj_individu->id]['adresse_complement_batiment'] = $obj_individu->adresse_complement_batiment;
        $rowResults[$obj_individu->id]['adresse_complement_lieu']     = $obj_individu->adresse_complement_lieu;
        $rowResults[$obj_individu->id]['address_postalcode']          = $obj_individu->address_postalcode;
        $rowResults[$obj_individu->id]['address_city']                = $obj_individu->address_city;

        // Régime alimentaire
        $rowResults[$obj_individu->id]['menu_autorise'] = $obj_individu->menu_autorise;
        $rowResults[$obj_individu->id]['fai']           = $obj_individu->fai;

        $rowResults[$obj_individu->id]['role'] = $relations['0']->role;
        $rowResults[$obj_individu->id]['statut_compte'] = $obj_individu->statut_compte;
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $rowResults;
    }
    
    
    /**
     * setIndividu
     * @param TiersIndividuEditionParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function setIndividu(TiersIndividuEditionParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $creation = false; 
        
        $parametres = $params->getData();
        
        // Paramètres 
        $id_usager   = $parametres["id_usager"];
        $id_tiers    = $parametres["id_profil"];
        $id_objet    = $parametres["datas"]["id_individu"];
        $datas_individus = $parametres["datas"];

        //$GLOBALS['log']->fatal(print_r($datas_individus, true));
        
        try {
            $obj_indi_connecte = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_module_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_tiers);
        }
        catch (\Exception $exception) {
            throw new Exception('Profil inconnu', 401);
        }

        // Dans le cadre d'une modification
        if( !empty($id_objet) ){
            try {
                $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_objet);
            }
            catch (\Exception $exception) {
                throw new Exception('Individu inconnu', 401);
            }
        }
        else{
            $obj_module = $this->beanManager->newBeanSafe('OPS_individu');
            $creation = true; 
        }

        // Vérification qu'il existe un lien entre l'individu connecté et le profil 
        if( $this->verif_liaison_profil( $obj_indi_connecte->id, $id_tiers ) ){

            foreach ($datas_individus as $key => $value) 
            {
                $obj_module->$key = stripslashes($value); 
            }

            $retour['id'] = $obj_module->save();

            // Dans le cadre d'une création, liaison avec le profil
            if( $creation && !empty($retour['id']) ){

                $obj_relation = $this->beanManager->newBeanSafe('OPS_personne_morale_individu');
                if (empty($role)) $role = 'membre'; // role par defaut

                $obj_relation->ops_individu_id        = $retour['id'];
                $obj_relation->ops_personne_morale_id  = $id_tiers;
                $obj_relation->role                 = $datas_individus['role'];
                $obj_relation->acces_usager         = false;
                $obj_relation->responsable          = false;
                $obj_relation->save();
            }
            else{

                $relations = $obj_module->get_linked_beans('ops_individu_ops_personne_morale_individu' , 'OPS_personne_morale_individu');
                $obj_relation = $this->beanManager->getBeanSafe("OPS_personne_morale_individu", $relations['0']->id);
                $obj_relation->role                 = $datas_individus['role'];
                $obj_relation->save();

            }
            
        }
        else{
            $retour['erreur'] = "Vous n'avez pas accès à la modification de cette individu" ; 
        }
       


        $response = new DocumentResponse();
        $response->setData($retour);

        return $response;
    }


    private function verif_liaison_profil( $id_usager, $id_profil ){

        global $db;
        
        
        $requete = $db->query("
            SELECT ops_personne_morale.id,
                   ops_personne_morale_individu.responsable
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_usager . "'
            AND ops_personne_morale.id =  '" . $id_profil . "'
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` DESC ");
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            return true;   
        }

        return false; 

    } 
 

    /**
     * rattacherProfil
     * @param TiersPartageEditionParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function rattacherProfil(TiersIndividuEditionParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;

        $parametres = $params->getData();
        
        // Paramètres 
        $id_usager   = $parametres["id_usager"];
        $code    = $parametres["datas"]["code"];
        $role    = $parametres["datas"]["role"];


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }


        try {
            $obj_relation = $this->beanManager->getBeanByField("OPS_personne_morale_individu",array('clef' => $code ));
        }
        catch (\Exception $exception) {
            throw new Exception('Code inconnu', 401);
        }

        // Vérification que le code existe
        if (!empty($obj_relation->id)) {
            
            switch ($obj_relation->statut_clef) {
                
                // Clé annulé/supprimé
                case 'revoque':
                        $codeRetour = 'code_revoque';
                        return $codeRetour;
                // Clé expiré 
                case 'perime':
                        $codeRetour = 'code_perime';
                        return $codeRetour;
                // Clé utilisé msg_cle_util
                case 'utilise':
                        $codeRetour = 'code_utilise';
                        return $codeRetour;
                case 'nouveau':
                    $relations = $obj_relation->get_linked_beans('ops_personne_morale_ops_personne_morale_individu' , 'OPS_personne_morale');
                    
                    // L'individu n'a pas d'accès à l'entite : création de la relation
                    if( !$this->verif_liaison_profil( $id_usager, $relations['0']->id  ) ){
                        
                        $date = new DateTime( );

                        // Flag de la liaison
                        $obj_relation->role             = 'membre';
                        $obj_relation->statut_clef      = 'utilise';
                        $obj_relation->ops_individu_id  = $obj_individu->id;
                        $obj_relation->acces_usager     = true;
                        $obj_relation->role             = $role;
                        $obj_relation->date_activation  = $date->format('Y-m-d');
                        $obj_relation->save();

                        $codeRetour['id'] = $relations['0']->id ; 
                        $codeRetour['type_id'] = $relations['0']->ops_type_personne_id ; 


                        $template = $sugar_config['opensocle']['notif_usager_partage_activation'];

                        if( isset($template) && !empty($template) ){

                            $obj_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $relations['0']->id );

                            # On initialise le mailer 
                            $mailer = new OdeMailer();

                            # On initialise l'email 
                            $ode_email = new OdeEmail([
                                'bean_source_id' => $obj_profil->id,
                                'bean_source_name' => 'OPS_personne_morale',
                                'bean_historisation_id' => $obj_profil->id,
                                'bean_historisation_name' => 'OPS_personne_morale',
                                'email_template_id' => $template,
                                'dest_to' => $obj_profil->email1,
                            ]);

                            # On déclenche l'envoie
                            $mailer->send($ode_email);
                        }
                        else{
                            $GLOBALS['log']->fatal( "TiersService - sendNotification : Pas te template mail associé à l'activation d'une clef " );
                        }
                      
                    } else {
                        // L'individu a déjà accès à l'entité donc pas de relation 
                        $codeRetour  ='individu_rattache';
                    }
               }      
        } 
        else
        {
            // Clé inxestante 
            $codeRetour = 'code_inconnu';
        }

        $response = new DocumentResponse();
        $response->setData($codeRetour);

        return $response;
        
    }
    
    
    /**
     * setCode
     * @param DocumentsListParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function setCode(TiersIndividuEditionParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        $date_time_zone   = new DateTimeZone('Europe/Paris');

        $retour = false; 
        $parametres = $params->getData();

        $id_usager    = $parametres["id_usager"];
        $id_tiers    = $parametres["id_profil"];
        
        try {
            $obj_indi_connecte = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_module_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_tiers);
        }
        catch (\Exception $exception) {
            throw new Exception('Profil inconnu', 401);
        }

        // Vérification que l'individu a les droits sur le profil 
        if( $this->verif_liaison_profil( $obj_indi_connecte->id, $id_tiers ) ){


            // Création d'un code 
            $chars  = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $code = '';
            for ($i = 0; $i < 12; $i++) {
                $code .= $chars[rand(0, strlen($chars) - 1)];
            }
            

            $obj_relation = $this->beanManager->newBeanSafe('OPS_personne_morale_individu');

            $obj_relation->ops_personne_morale_id  = $id_tiers;

            $obj_relation->clef                 = $code;
            $obj_relation->statut_clef          = 'nouveau';
            $obj_relation->acces_usager         = false;
            $obj_relation->responsable          = false;
            $id = $obj_relation->save();

            
            if (!empty($id)) {
                $date_creation  = new DateTime( $row['date_entered'] , $date_time_zone);
                $retour['id'] = $id;

                $retour['statut_clef'] = $app_list_strings['ops_statut_clef_list'][$obj_relation->statut_clef]; 
                $retour['date_creation'] = $date_creation->format('d/m/Y');
                $retour['code'] = $code;
            }


        }


        $response = new DocumentResponse();
        $response->setData($retour);

        return $response;
        
    }

   /**
     * getCodes
     * @param TiersListIndividusParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function getCodes(TiersListIndividusParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
        
        $id_objet  = $params->getId(); // ID PROFIL
        $id_usager = $params->getIndividuId();
        $date_time_zone   = new DateTimeZone('Europe/Paris');
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }
        
        try {
            $obj_module = $this->beanManager->getBeanSafe("OPS_personne_morale", $id_objet);
        }
        catch (\Exception $exception) {
            throw new Exception('Profil inconnu', 401);
        }
        
        $requete = $db->query("
            SELECT  ops_personne_morale_individu.id,
                    ops_personne_morale_individu.name,
                    ops_personne_morale_individu.role,
                    ops_personne_morale_individu.statut_clef,
                    ops_personne_morale_individu.date_expiration,
                    ops_personne_morale_individu.date_revocation,
                    ops_personne_morale_individu.acces_usager,
                    ops_personne_morale_individu.clef,
                    ops_personne_morale_individu.date_activation,
                    ops_personne_morale_individu.responsable,
                    ops_personne_morale_individu.date_entered,
                    ops_personne_morale_individu.date_modified
            FROM ops_personne_morale_individu,  ops_personne_morale_ops_personne_morale_individu , ops_personne_morale
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id
            AND ops_personne_morale_individu.id  = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id =  '" . $id_objet . "'
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            and ( ops_personne_morale_individu.clef IS NOT NULL  AND  ops_personne_morale_individu.clef != '' )
            ORDER BY ops_personne_morale_individu.statut_clef ASC, ops_personne_morale_individu.date_entered ");
        
        $rowResults = array();

        while ($row = $db->fetchRow($requete)) {

            $obj_relation = $this->beanManager->getBeanSafe("OPS_personne_morale_individu", $row['id']);

            $rowResults[$row['id']]['individu'] = $obj_relation->individu_rattache ;
             
            if (!empty($row['statut_clef'])) {
                $rowResults[$row['id']]['statut_clef'] = $app_list_strings['ops_statut_clef_list'][$row['statut_clef']];
            }
            
            $rowResults[$row['id']]['clef'] = $row['clef'];
            $rowResults[$row['id']]['individu_type'] = 'partage';
            $rowResults[$row['id']]['individu_type_label'] = "Accès au profil";
        
            $date_creation  = new DateTime( $row['date_entered'] , $date_time_zone);
            $rowResults[$row['id']]['date_creation'] = $date_creation->format('d/m/Y');

            $rowResults[$row['id']]['date_expiration'] = ""; 
            if(!empty($row['date_expiration'])) {
                $date_expiration  = new DateTime( $row['date_expiration'] , $date_time_zone);
                $rowResults[$row['id']]['date_expiration'] = $date_expiration->format('d/m/Y');            
            }

            $rowResults[$row['id']]['date_revocation'] = ""; 
            if(!empty($row['date_revocation'])) {
                $date_revocation  = new DateTime( $row['date_revocation'] , $date_time_zone);
                $rowResults[$row['id']]['date_revocation'] = $date_revocation->format('d/m/Y');
            }

            $rowResults[$row['id']]['date_activation'] = ""; 
            if( !empty( $row['date_activation'] ) ){
                $date_activation  = new DateTime( $row['date_activation'] , $date_time_zone);
                $rowResults[$row['id']]['date_activation'] = $date_activation->format('d/m/Y');
            }
        }
        
        $response = new DocumentResponse();
        $response->setData($rowResults);
        
        return $response;
    }
    

    /**
     * deleteCode
     * @param TiersPartageDeleteParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function deleteCode(TiersPartageDeleteParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;

        $id_objet  = $params->getId(); // ID PROFIL
        $retour['delete'] = false;

        try {
            $obj_relation = $this->beanManager->getBeanSafe("OPS_personne_morale_individu", $id_objet);
        }
        catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $retour['id_individu'] = $obj_relation->ops_individu_id;

        if( $obj_relation->statut_clef == "utilise" || $obj_relation->statut_clef == 'nouveau' ){
            $obj_relation->ops_individu_id = null ; 
            $obj_relation->statut_clef = 'revoque';
            $obj_relation->acces_usager = false;
            $obj_relation->date_revocation = date('Y-m-d');
            $obj_relation->save();

            $template = $sugar_config['opensocle']['notif_usager_partage_revocation'];

            if( isset($template) && !empty($template) ){
                $obj_profil = $this->beanManager->getBeanSafe("OPS_personne_morale", $obj_relation->ops_personne_morale_id );

                # On initialise le mailer 
                $mailer = new OdeMailer();

                # On initialise l'email 
                $ode_email = new OdeEmail([
                    'bean_source_id' => $obj_profil->id,
                    'bean_source_name' => 'OPS_personne_morale',
                    'bean_historisation_id' => $obj_profil->id,
                    'bean_historisation_name' => 'OPS_personne_morale',
                    'email_template_id' => $template,
                    'dest_to' => $obj_profil->email1,
                ]);

                # On déclenche l'envoie
                $mailer->send($ode_email);
            }
            else{
                $GLOBALS['log']->fatal( "TiersService - sendNotification : Pas te template mail associé à la revocation d'une clef " );
            }

            $retour['delete'] = true;
        }
     
        $retour['id'] = $id_objet;

        $response = new DocumentResponse();
        $response->setData($retour);

        return $response;
        
    }
    
    
    /**
     * setIndividu
     * @param TiersIndividuEditionParams $params
     * @param $path
     * @return DocumentResponse
     * @throws AccessDeniedException
     */
    public function UpdateRoleTier(TiersRoleUpdateParams $params, Request $request)
    {
        global $sugar_config, $db, $app_list_strings;
                
        $parametres = $params->getData();
        
        // Paramètres 
        $id_individu    = $parametres["id_individu"];
        $role           = $parametres["role"];
        $result = 0;

        $requete = $db->query("UPDATE ops_personne_morale_individu
                    SET role = '". $role . "'
                    WHERE id = '". $id_individu . "';");

        if( $requete != '1' ){
            $result = 1;
        }
        
        return $result;
    }
    
}