<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\NotificationResponse;
use ODE\Model\DemandeurModel;
use ODE_API\V8\JsonApi\Response\MetaResponse;
use ODE_API\V8\Param\NotificationListParams;
use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Generateur\Factory\OdeViewFactory;
use Exception;
use Slim\Http\Request;


class NotificationService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }
    //$GLOBALS['log']->fatal("ICI tableau_justificatifs" . print_r($tableau_justificatifs, true));


    /**
     * getListNotifications
     * @param NotificationListParams $params
     * @param $path
     * @return NotificationResponse
     * @throws AccessDeniedException
     */
    public function getListNotifications(NotificationListParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config, $app_list_strings;

        $type_entite = 'OPS_individu';
        $id_demandeur = $params->getId();

        if (empty($id_demandeur)) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }

        try {
            $obj_module = $this->beanManager->getBeanSafe($type_entite, $id_demandeur);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        #Récupération des dossiers individu Incomplet
        $tab_dossiers = $obj_module->get_linked_beans(
            'ops_individu_ops_dossier',
            'ops_dossier',
            'num_dossier DESC',
            0,
            -1,
            0,
            ' (ops_dossier.ops_personne_morale IS NULL OR ops_dossier.ops_personne_morale = "") '
        );

        $dossiers = array();
        $list_statut    = $app_list_strings['ops_statut_j_list'];
        foreach ($tab_dossiers as $key => $un_dossier) {

            #récupération des dossiers d'un individu
            if( $un_dossier->incomplet == 1 ){
                $module_dispositif = 'OPS_dispositif';
                $id_dispositif = $un_dossier->ops_dispositif_id;
    
                if (!empty($un_dossier->ops_dispositif_id)) {
                    $obj_dispositif = $this->beanManager->getBeanSafe($module_dispositif, $id_dispositif);
                  
                    $dossiers['incomplet'][$un_dossier->num_dossier] = [
    
                        'id_dossier'            => $un_dossier->id,
                        'numero'                => $un_dossier->num_dossier,
                        'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                        'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                        'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                        'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                        'profil'                => $un_dossier->type_tiers,
                        'id_profil'             => 'particulier',
                        'name_profil'           => 'Particulier',
                        'entite'                => 'particulier',
                        'dispositif_id'         => $id_dispositif,
                        'incomplet'             => $un_dossier->incomplet,
                        'type_notification'     => 'Dossier'
                    ]; 
                }
            }


            #Récupération des conversations non lues pour un dossier appratenant (messages usager non lus provenant de agent CRM).
            $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau';";

            try {
                
                $result_messages = $db->query($SQL_Notification);
                while ($row_messages = $db->fetchByAssoc($result_messages)) {
                    $Message = (object) $row_messages;

                    if( $Message->nouveaux_messages > 0 ){

                        $dossiers['conversation'][$un_dossier->num_dossier] = [
                            'id_dossier'            => $un_dossier->id,
                            'numero'                => $un_dossier->num_dossier,
                            'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                            'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                            // 'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                            // 'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                            // 'profil'                => $profil['libelle_usager'],
                            // 'id_profil'             => $id,
                            // 'name_profil'           => $profil['name'],
                            'dispositif_id'         => $id_dispositif,
                            'nouveaux_messages'     => $Message->nouveaux_messages,
                            'type_notification'     => 'Conversation'
                        ];

                    }

                }

            } catch (Exception $e) {}

            #récuppération des pj d'un dossier individu
            $obj_dossier = $this->beanManager->getBeanSafe('OPS_dossier', $un_dossier->id);
            $tab_justificatif = $obj_dossier->get_linked_beans('ops_dossier_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');
    
            foreach ($tab_justificatif as $key => $un_justificatif) {

                if($un_justificatif->obligatoire == false) continue;

                if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                    
                    $module_justificatif = 'OPS_justificatif';
                    $id_justificatif = $un_justificatif->id;
    
                    $obj_justificatif = $this->beanManager->getBeanSafe($module_justificatif, $id_justificatif);
                    $tab_type_document = $obj_justificatif->get_linked_beans('ops_type_document_ops_justificatif', 'ops_type_document');
                
                    foreach ($tab_type_document as $key => $un_type_document) {
    
                        foreach ($list_statut as $key => $le_statut){                    
                     
                            if( $un_justificatif->statut == $key ){
                                $statut_pj = $le_statut;
                            }
                        }
                    
                        $dossiers['justificatif'][$un_justificatif->id] = [
                            'id_justificatif'       => $un_justificatif->id,
                            'id_dossier'            => $un_dossier->id,
                            'numero'                => $un_dossier->num_dossier,
                            'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                            'dispositif_id'         => $id_dispositif,
                            'id_profil'             => 'particulier',
                            'obligatoire'           => $un_justificatif->obligatoire,
                            'commentaire'           => $un_justificatif->description,
                            'id_type_document'      => $un_type_document->id,
                            'name_type_document'    => $un_type_document->name,
                            'justificatif_dossier'  => 'justificatif_dossier',
                            'type_notification'     => 'justificatif'
                        
                        ];
                    }
                }
            }
        }
       


        // Récupération de tous les profils liés à l'individu connecté 
        $obj_personne_morale = \BeanFactory::newBean("OPS_personne_morale");
        $liste_tiers = $obj_personne_morale->get_profil_by_individu($id_demandeur);
        


        // On boucle sur tous les profils pour récupérer les dossiers 
        foreach ($liste_tiers as $id => $profil) {
            
            $obj_dossier = \BeanFactory::newBean("OPS_dossier");
            $liste_dossiers = $obj_dossier->get_full_list('num_dossier', "ops_dossier.ops_personne_morale = '" . $id . "'");

            foreach ($liste_dossiers as $key => $un_dossier) {

                if( $un_dossier->incomplet == 1 ){

                    $un_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $un_dossier->id);
    
                    $module_dispositif = 'OPS_dispositif';
                    $id_dispositif = $un_dossier->ops_dispositif_id;
    
                    if (!empty($un_dossier->ops_dispositif_id)) {
                       
                        // Récupération du demandeur 
                        $demandeur = $un_dossier->get_linked_beans('ops_individu_ops_dossier', 'ops_individu');
                        $beneficiaire = ""; 
    
                        // Récupération du bénéficiaire
                        if (!empty($un_dossier->beneficiaire_id && $un_dossier->beneficiaire_id != 'undefined')) {
                            $obj_indi = $this->beanManager->getBeanSafe("OPS_individu", $un_dossier->beneficiaire_id);
                            $beneficiaire = $obj_indi->full_name;
                        }
    
                        $dossiers['incomplet'][$un_dossier->num_dossier] = [
                            'id_dossier'            => $un_dossier->id,
                            'numero'                => $un_dossier->num_dossier,
                            'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                            'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                            'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                            'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                            'profil'                => $profil['libelle_usager'],
                            'id_profil'             => $id,
                            'name_profil'           => $profil['name'],
                            'incomplet'             => $un_dossier->incomplet,
                            'dispositif_id'         => $id_dispositif,
                            'type_notification'     => 'Dossier'
                        ];
                    }
                }





                #Récupération des PJ des dossiers lié a une personne morale
                $tab_justificatif = $un_dossier->get_linked_beans('ops_dossier_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');
    /* ?? */    $un_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $un_dossier->id);
                foreach ($tab_justificatif as $key => $un_justificatif) {

                    if($un_justificatif->obligatoire == false) continue;

                    if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                        
                        $module_justificatif = 'OPS_justificatif';
                        $id_justificatif = $un_justificatif->id;
    
                        $obj_justificatif = $this->beanManager->getBeanSafe($module_justificatif, $id_justificatif);
                        $tab_type_document = $obj_justificatif->get_linked_beans('ops_type_document_ops_justificatif', 'ops_type_document');
                
                        foreach ($tab_type_document as $key => $un_type_document) {
    
                            foreach ($list_statut as $key => $le_statut){                    
                     
                                if( $un_justificatif->statut == $key ){
                                    $statut_pj = $le_statut;
                                }
                            }
                        
                            $dossiers['justificatif'][$un_justificatif->id] = [
                                'id_justificatif'       => $un_justificatif->id,
                                'id_dossier'            => $un_dossier->id,
                                'numero'                => $un_dossier->num_dossier,
                                'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                                'dispositif_id'         => $id_dispositif,
                                'id_profil'             => $id,
                                'name_profil'           => $profil['name'],
                                'obligatoire'           => $un_justificatif->obligatoire,
                                'commentaire'           => $un_justificatif->description,
                                'id_type_document'      => $un_type_document->id,
                                'name_type_document'    => $un_type_document->name,
                                'justificatif_dossier'  => 'justificatif_dossier',
                                'type_notification'     => 'justificatif'
                            ];
                        }
                    }
                }



                #Récupération des conversations non lues pour un dossier appratenant (messages usager non lus provenant de agent CRM).
                $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau';";

                try {
                    
                    $result_messages = $db->query($SQL_Notification);
                    while ($row_messages = $db->fetchByAssoc($result_messages)) {
                        $Message = (object) $row_messages;

                        if( $Message->nouveaux_messages > 0 ){

                            $dossiers['conversation'][$un_dossier->num_dossier] = [
                                'id_dossier'            => $un_dossier->id,
                                'numero'                => $un_dossier->num_dossier,
                                'nom_demande'           => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                                'demandeur'             => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                                'beneficiaire'          => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                                'beneficiaire_id'       => $un_dossier->beneficiaire_id,
                                'profil'                => $profil['libelle_usager'],
                                'id_profil'             => $id,
                                'name_profil'           => $profil['name'],
                                'dispositif_id'         => $id_dispositif,
                                'nouveaux_messages'     => $Message->nouveaux_messages,
                                'type_notification'     => 'Conversation'
                            ];

                        }

                    }

                } catch (Exception $e) {}



            }



            #Récupération des PJ d'une personne morale
            $obj_profil = $this->beanManager->getBeanSafe('OPS_personne_morale', $id);
            $tab_justificatif = $obj_profil->get_linked_beans('ops_personne_morale_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');
            
            foreach ($tab_justificatif as $key => $un_justificatif) {

                if($un_justificatif->obligatoire == false) continue;

                if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                        
                    $module_justificatif = 'OPS_justificatif';
                    $id_justificatif = $un_justificatif->id;
    
                    $obj_justificatif = $this->beanManager->getBeanSafe($module_justificatif, $id_justificatif);
                    $tab_type_document = $obj_justificatif->get_linked_beans('ops_type_document_ops_justificatif', 'ops_type_document');
                
                    foreach ($tab_type_document as $key => $un_type_document) {
    
                        foreach ($list_statut as $key => $le_statut){                    
                     
                            if( $un_justificatif->statut == $key ){
                                $statut_pj = $le_statut;
                            }
                        }
                    
                        $dossiers['justificatif'][$un_justificatif->id] = [
                            'id_justificatif'       => $un_justificatif->id,
                            'id_profil'             => $id,
                            'id_type_profil'        => $obj_profil->ops_type_personne_id,
                            'name_profil'           => $profil['name'],
                            'obligatoire'           => $un_justificatif->obligatoire,
                            'commentaire'           => $un_justificatif->description,
                            'id_type_document'      => $un_type_document->id,
                            'name_type_document'    => $un_type_document->name,
                            'justificatif_dossier'  => 'justificatif_personne_morale',
                            'type_notification'     => 'justificatif'
                        ];
                    }
                }
            }
        }



        return $dossiers;
    }


    /**
     * getListIndicateurs
     * @param NotificationListParams $params
     * @param $path
     * @return Indicateurs
     * @throws AccessDeniedException
     */
    public function getListIndicateurs(NotificationListParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config, $app_list_strings;


        $type_entite = 'OPS_individu';
        $id_demandeur = $params->getId();
        $tab_retour = array();

        if (empty($id_demandeur)) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }

        try {
            $obj_module = $this->beanManager->getBeanSafe($type_entite, $id_demandeur);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        // Gestion de la tuile mes dossiers 

        #Récupération des dossiers individu 
        $tab_dossiers = $obj_module->get_linked_beans(
            'ops_individu_ops_dossier',
            'ops_dossier',
            'num_dossier DESC',
            0,
            -1,
            0,
            ' (ops_dossier.ops_personne_morale IS NULL OR ops_dossier.ops_personne_morale = "") '
        );


        $indicateurs_dossiers = array();
        $indicateurs_profils = array();
        $indicateurs_messages = array();
        $indicateurs_documents = array();
        $list_statut    = $app_list_strings['ops_statut_j_list'];

        foreach ($tab_dossiers as $key => $un_dossier) {

            if( $un_dossier->name != "TEMP" ){
                $indicateurs_dossiers["count"] += 1;
            }

            // A REVOIR 
            if( $un_dossier->incomplet == 1 ){
    
                if (!empty($un_dossier->ops_dispositif_id)) {
                    $indicateurs_dossiers['notifications']['incomplet']['url'] = "/mes-dossiers/#incomplet"; 
                    $indicateurs_dossiers['notifications']['incomplet']["count"] += 1; 
                    $texte = " dossier";
                    if( $indicateurs_dossiers['notifications']['incomplet']["count"] > 1 ){
                        $texte = "dossiers";
                    }
                    $indicateurs_dossiers['notifications']['incomplet']["nombres"] =  $indicateurs_dossiers['notifications']['incomplet']["count"] . " " . $texte ; 
                    $indicateurs_dossiers['notifications']['incomplet']["texte"] = " à compléter" ; 
                }
            }


            #Récupération des conversations non lues pour un dossier appratenant (messages usager non lus provenant de agent CRM).
            $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau';";

            try {
                
                $result_messages = $db->query($SQL_Notification);
                while ($row_messages = $db->fetchByAssoc($result_messages)) {
                    $Message = (object) $row_messages;

                    if( $Message->nouveaux_messages > 0 ){

                        $indicateurs_dossiers['notifications']['conversation']['url'] = "/mes-dossiers/#conversation"; 
                        $indicateurs_dossiers['notifications']['conversation']["count"] += 1; 
                        $texte = " message";
                        if( $indicateurs_dossiers['notifications']['conversation']["count"] > 1 ){
                            $texte = " messages";
                        }
                        $indicateurs_dossiers['notifications']['conversation']["nombres"] =  $indicateurs_dossiers['notifications']['conversation']["count"] . " " . $texte ; 
                        $indicateurs_dossiers['notifications']['conversation']["texte"] = " à traiter" ; 

                    }

                }

            } catch (Exception $e) {}

            #récuppération des pj d'un dossier individu
            $obj_dossier = $this->beanManager->getBeanSafe('OPS_dossier', $un_dossier->id);
            $tab_justificatif = $obj_dossier->get_linked_beans('ops_dossier_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');
    
            foreach ($tab_justificatif as $key => $un_justificatif) {

                // GUID DE CONSERVATION OU NON ? ? ? 
                if($un_justificatif->obligatoire == false) continue;

                if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                    
                    $indicateurs_dossiers['notifications']['justificatif']['url'] = "/mes-dossiers/#justificatif"; 
                    $indicateurs_dossiers['notifications']['justificatif']["count"] += 1; 
                    $texte = " justificatif";
                    if( $indicateurs_dossiers['notifications']['justificatif']["count"] > 1 ){
                        $texte = "justificatifs";
                    }
                    $indicateurs_dossiers['notifications']['justificatif']["nombres"] =  $indicateurs_dossiers['notifications']['justificatif']["count"] . " " . $texte ; 
                    $indicateurs_dossiers['notifications']['justificatif']["texte"] = " à fournir" ; 
                }
            }

            // Récupération des documents reçus 
            $liste_documents = $obj_dossier->get_linked_beans('ops_dossier_documents', 'documents', 'date_entered DESC'); 
            $document_array = array();
            
            foreach ($liste_documents as $doc_key => $un_doc) {
                
                if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1 ){

                    $indicateurs_documents["count"] += 1;

                    if( $un_doc->status_id == "a_signer" ){

                        $indicateurs_documents['notifications']['signature']['url'] = "/mes-documents/#signature"; 
                        $indicateurs_documents['notifications']['signature']["count"] += 1; 
                        $texte = " document";
                        if( $indicateurs_documents['notifications']['signature']["count"] > 1 ){
                            $texte = "documents";
                        }
                        $indicateurs_documents['notifications']['signature']["nombres"] =  $indicateurs_dossiers['notifications']['signature']["count"] . " " . $texte ; 
                        $indicateurs_documents['notifications']['signature']["texte"] = " à signer" ; 

                    }

                }
            } 

        }
       


        // Récupération de tous les profils liés à l'individu connecté 
        $obj_personne_morale = \BeanFactory::newBean("OPS_personne_morale");
        $liste_tiers = $obj_personne_morale->get_profil_by_individu($id_demandeur);

        // On boucle sur tous les profils pour récupérer les dossiers 
        foreach ($liste_tiers as $id => $profil) {
            
            $indicateurs_profils["count"] += 1;
            $obj_dossier = \BeanFactory::newBean("OPS_dossier");
            $liste_dossiers = $obj_dossier->get_full_list('num_dossier', "ops_dossier.ops_personne_morale = '" . $id . "'");

            foreach ($liste_dossiers as $key => $un_dossier) {

                if( $un_dossier->name != "TEMP" ){
                    $indicateurs_dossiers["count"] += 1;
                }

                // A REVOIR 
                if( $un_dossier->incomplet == 1 ){

                    $indicateurs_dossiers['notifications']['incomplet']['url'] = "/mes-dossiers/#incomplet"; 
                    $indicateurs_dossiers['notifications']['incomplet']["count"] += 1; 
                    $texte = " dossier";
                    if( $indicateurs_dossiers['notifications']['incomplet']["count"] > 1 ){
                        $texte = "dossiers";
                    }
                    $indicateurs_dossiers['notifications']['incomplet']["nombres"] =  $indicateurs_dossiers['notifications']['incomplet']["count"] . " " . $texte ; 
                    $indicateurs_dossiers['notifications']['incomplet']["texte"] = " à compléter" ; 

                }

                #Récupération des PJ des dossiers lié a une personne morale
                $tab_justificatif = $un_dossier->get_linked_beans('ops_dossier_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');

                foreach ($tab_justificatif as $key => $un_justificatif) {

                    // GUID DE CONSERVATION OU NON ? ? ? 
                    if($un_justificatif->obligatoire == false) continue;

                    if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                        
                        $indicateurs_dossiers['notifications']['justificatif']['url'] = "/mes-dossiers/#justificatif"; 
                        $indicateurs_dossiers['notifications']['justificatif']["count"] += 1; 
                        $texte = " justificatif";
                        if( $indicateurs_dossiers['notifications']['justificatif']["count"] > 1 ){
                            $texte = "justificatifs";
                        }
                        $indicateurs_dossiers['notifications']['justificatif']["nombres"] =  $indicateurs_dossiers['notifications']['justificatif']["count"] . " " . $texte ; 
                        $indicateurs_dossiers['notifications']['justificatif']["texte"] = " à fournir" ; 

                    }
                }


                #Récupération des conversations non lues pour un dossier appratenant (messages usager non lus provenant de agent CRM).
                $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau';";

                try {
                    
                    $result_messages = $db->query($SQL_Notification);
                    while ($row_messages = $db->fetchByAssoc($result_messages)) {
                        $Message = (object) $row_messages;

                        if( $Message->nouveaux_messages > 0 ){

                            $indicateurs_dossiers['notifications']['conversation']['url'] = "/mes-dossiers/#conversation"; 
                            $indicateurs_dossiers['notifications']['conversation']["count"] += 1; 
                            $texte = " message";
                            if( $indicateurs_dossiers['notifications']['conversation']["count"] > 1 ){
                                $texte = " messages";
                            }
                            $indicateurs_dossiers['notifications']['conversation']["nombres"] =  $indicateurs_dossiers['notifications']['conversation']["count"] . " " . $texte ; 
                            $indicateurs_dossiers['notifications']['conversation']["texte"] = " à traiter" ; 

                        }

                    }

                } catch (Exception $e) {}


                // Récupération des documents reçus 
                $liste_documents = $un_dossier->get_linked_beans('ops_dossier_documents', 'documents', 'date_entered DESC'); 
                $document_array = array();
                
                foreach ($liste_documents as $doc_key => $un_doc) {
                    
                    if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1 ){

                        $indicateurs_documents["count"] += 1;

                        if( $un_doc->status_id == "a_signer" ){

                            $indicateurs_documents['notifications']['signature']['url'] = "/mes-documents/#signature"; 
                            $indicateurs_documents['notifications']['signature']["count"] += 1; 
                            $texte = " document";
                            if( $indicateurs_documents['notifications']['signature']["count"] > 1 ){
                                $texte = "documents";
                            }
                            $indicateurs_documents['notifications']['signature']["nombres"] =  $indicateurs_dossiers['notifications']['signature']["count"] . " " . $texte ; 
                            $indicateurs_documents['notifications']['signature']["texte"] = " à signer" ; 

                        }

                    }
                }
            }

            #Récupération des PJ d'une personne morale
            $obj_profil = $this->beanManager->getBeanSafe('OPS_personne_morale', $id);
            $tab_justificatif = $obj_profil->get_linked_beans('ops_personne_morale_ops_justificatif', 'ops_justificatif', 'depot ASC, date_entered DESC');
            
            foreach ($tab_justificatif as $key => $un_justificatif) {

                if($un_justificatif->obligatoire == false) continue;

                if( $un_justificatif->statut == "rejete"  || $un_justificatif->statut == "non_fourni"  ){
                        
                    // GUID DE CONSERVATION OU NON ? ? ? 
                    $indicateurs_profils['notifications']['justificatif']['url'] = "/mes-profils/#justificatif"; 
                    $indicateurs_profils['notifications']['justificatif']["count"] += 1; 
                    $texte = " justificatif";
                    if( $indicateurs_profils['notifications']['justificatif']["count"] > 1 ){
                        $texte = "justificatifs";
                    }
                    $indicateurs_profils['notifications']['justificatif']["nombres"] =  $indicateurs_profils['notifications']['justificatif']["count"] . " " . $texte ; 
                    $indicateurs_profils['notifications']['justificatif']["texte"] = " à fournir" ; 
                }
            }

            //Récupération des documents lié aux profils
            $liste_documents = $obj_profil->get_linked_beans('ops_personne_morale_documents', 'documents', 'date_entered DESC'); 
            foreach ($liste_documents as $doc_key => $un_doc) {
                        
                if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1 ){

                    $indicateurs_documents["count"] += 1;

                    if( $un_doc->status_id == "a_signer" ){

                        $indicateurs_documents['notifications']['signature']['url'] = "/mes-documents/#signature"; 
                        $indicateurs_documents['notifications']['signature']["count"] += 1; 
                        $texte = " document";
                        if( $indicateurs_documents['notifications']['signature']["count"] > 1 ){
                            $texte = "documents";
                        }
                        $indicateurs_documents['notifications']['signature']["nombres"] =  $indicateurs_dossiers['notifications']['signature']["count"] . " " . $texte ; 
                        $indicateurs_documents['notifications']['signature']["texte"] = " à signer" ; 

                    }

                }
            }
        }


        //Récupération des document lié a l'individu
        $individu_documents = $obj_module->get_linked_beans('ops_individu_documents', 'documents', 'date_entered DESC'); 
        foreach ($individu_documents as $doc_key => $un_doc) {
                    
            if ( !empty($un_doc->id ) && $un_doc->fetched_row['importable'] == 1 ){

                $indicateurs_documents["count"] += 1;

                if( $un_doc->status_id == "a_signer" ){

                    $indicateurs_documents['notifications']['signature']['url'] = "/mes-documents/#signature"; 
                    $indicateurs_documents['notifications']['signature']["count"] += 1; 
                    $texte = " document";
                    if( $indicateurs_documents['notifications']['signature']["count"] > 1 ){
                        $texte = "documents";
                    }
                    $indicateurs_documents['notifications']['signature']["nombres"] =  $indicateurs_dossiers['notifications']['signature']["count"] . " " . $texte ; 
                    $indicateurs_documents['notifications']['signature']["texte"] = " à signer" ; 

                }

            }
        }

        // Nombre de messages
        $requeteMessages = "
        SELECT count(emails.id) as nombre
        FROM emails
        INNER JOIN emails_text ON emails_text.email_id = emails.id AND emails_text.deleted = 0
        WHERE emails.id IN ( SELECT DISTINCT emails.id
                            FROM ops_individu      
                            INNER JOIN email_addr_bean_rel ON email_addr_bean_rel.bean_id = ops_individu.id AND email_addr_bean_rel.deleted = 0
                            INNER JOIN email_addresses ON email_addresses.id = email_addr_bean_rel.email_address_id AND email_addresses.deleted = 0
                            INNER JOIN emails_email_addr_rel ON emails_email_addr_rel.email_address_id = email_addresses.id AND emails_email_addr_rel.deleted = 0
                            INNER JOIN emails ON emails.id = emails_email_addr_rel.email_id AND emails.deleted = 0
                            INNER JOIN emails_text ON emails_text.email_id = emails.id AND emails_text.deleted = 0
                            WHERE ops_individu.id = '$id_demandeur' AND emails_email_addr_rel.address_type = 'to' AND emails.parent_type = 'OPS_dossier')
        OR
        emails.id IN ( SELECT DISTINCT ema.id
                     FROM ops_individu ind      
                     INNER JOIN emails ema ON ema.parent_id = ind.id AND ema.deleted = 0
                     INNER JOIN emails_text ema2 ON ema2.email_id = ema.id AND ema2.deleted = 0
                     WHERE ind.id = '$id_demandeur' )";

        $resultRequete = $db->query($requeteMessages);

        while ($row = $db->fetchByAssoc($resultRequete)) 
        {         
                $indicateurs_messages["count"] = $row['nombre'];
        }
        

        $tab_retour['dossiers'] = $indicateurs_dossiers ; 
        $tab_retour['profils'] = $indicateurs_profils ; 
        $tab_retour['messages'] = $indicateurs_messages ; 
        $tab_retour['documents'] = $indicateurs_documents ; 

        $liens_autres_modules = 'custom/include/Ode/Portail/Indicateurs/';

        if (is_dir($liens_autres_modules)) {
            $files = array_diff(scandir($liens_autres_modules), ['.', '..']);
            foreach ($files as $file_name) {
            $GLOBALS['log']->fatal(" IndicateursListe ::file_name ".print_r($file_name,true));
                if( end( explode('.', $file_name) ) == 'php')
                {

                    include $liens_autres_modules.$file_name;
                    $class_name = str_replace('.php', '', $file_name);
                    $notifications = new $class_name($id_demandeur);
                    $array_to_add = $notifications->getIndicateurs();
                    $tab_retour = array_merge($tab_retour, $array_to_add);
                }
            }
        } else {
            $GLOBALS['log']->fatal(" IndicateursListe :: Aucun autre module");
        }

        return $tab_retour;
    }


}
