<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\DossierResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;

use ODE_API\V8\Param\DossierSetParams;

use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Generateur\Factory\OdeViewFactory;

use BeanFactory;

use Exception;
use Slim\Http\Request;

use UploadFile;

use Datetime;
use DateTimeZone;

use SuiteCRM\Exception\MalwareFoundException;
use SuiteCRM\Utility\AntiMalware\AntiMalwareTrait;


class DossierJustificatifService
{
    use AntiMalwareTrait;

    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
     public function __construct(BeanManager $beanManager,AttributeObjectHelper $attributeHelper,RelationshipObjectHelper $relationshipHelper,PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }

    ////////////////////////////////    PORTAIL API /////////////////////////////////////////////////////////

    /**
     * createJustificatif
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
     public function createJustificatif(DossierSetParams $params, Request $request)
    {
        global $sugar_config ; 

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie qu'il y ait bien des justificatifs '
        if (!isset( $donnees['files'] )) {
            $response = new DossierResponse();
            $response->setData([
                "erreur" => "Une erreur s'est produite, veuillez vérifier le nom de votre document",
                "attache" => $donnees['attache'], 
                "name" => $donnees["name"], 
            ]);
            return $response;
        }

        // Récupération du dossier pour mettre à jour le champ 
        try {
            $objDossier = $this->beanManager->getBeanSafe("OPS_dossier", $donnees["dossier_id"]);
        } catch (\Exception $exception) {
            throw new Exception('Dossier inconnu', 401);
        }

        // Récupération de l'usager connecté  
        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $donnees["user_id"]);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // Si l'usager connecté n'est pas le partenaire => On vérifie s'il est demandeur
        // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
        if (DossierService::verif_liaison_avis($obj_individu->id, $objDossier->id) || ($obj_individu->id == $objDossier->ops_individu_id && $objDossier->flag_partenaire)) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $objDossier->ops_statut_id);
            if ($obj_statut->visible_partenaire == 0) {
                $response = new DossierResponse();
                $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                return $response;
            }
        } elseif ($obj_individu->id != $objDossier->ops_individu_id) {
            if (!DossierJustificatifService::verif_liaison_profil($obj_individu->id, $objDossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData([
                    "erreur" => "Vous n'avez pas accès à ce dossier",
                    "attache" => $donnees['attache'], 
                    "name" => $donnees["name"], 
                ]);
                return $response;
            }
        }

        // Si l'id du justificatif est passé en paramètre alors c'est une modification 
        if (!empty($donnees["justificatif_id"])) {
            try {
                $objJustificatif = $this->beanManager->getBeanSafe("OPS_justificatif", $donnees["justificatif_id"] );
            } catch (\Exception $exception) {
                //TODO : A voir le traitement de modification de l'usager
                throw new Exception('Justificatif inconnu', 401);
            }

            // On vide le champ également 
            $customChamp = (array) json_decode( base64_decode( $objDossier->champs_custom) );
            $customChamp[$donnees["name"]] = [];

        } 
        else{
            $objJustificatif = \BeanFactory::newBean("OPS_justificatif");
            // Ici on le sauvegarde pour initialiser l'id
            $objJustificatif->save();
        }

        $files = $donnees['files'] ; 
        $id_type_document  = $donnees['attache'] ; 

        $objTypeDocument = BeanFactory::getBean('OPS_type_document', $id_type_document);

        $types_authorize = explode(",", str_replace("^", "", $objTypeDocument->format) ) ; 

        $mo = 5;
        if(!empty($objTypeDocument->taille_limite))
        {
            $mo = intval($objTypeDocument->taille_limite);
        }
        $max_size = $mo * pow(1024, 2);

        $nb_fichiers = count( $files ) ;

        // Vérification que l'usager n'a pas déposé plusieurs fichiers dans le cas d'un champ de fichier simple 
        if( $objTypeDocument->multiple == true && $nb_fichiers > 1 ){
            $objJustificatif->mark_deleted($objJustificatif->id);
            $response = new DossierResponse();
            $response->setData([
                "erreur" => "Il n'est pas possible de mettre plusieurs fichiers sur ce champ",
                "attache" => $donnees['attache'], 
                "name" => $donnees["name"], 
            ]);
            return $response;
        }

        // Vérification si le document doit être stocké sur le dossier ou la personne morale 
        if ($objTypeDocument->objet == 'tiers' && empty($objDossier->ops_personne_morale)) {
            // Réaffecte l'objet au dossier afin de ne pas perdre le justificatif.
            $objTypeDocument->objet = 'dossier';
        }

        // On détermine le chemin de sauvegarde du document 
        // Si tiers -> alors on associe le justificatif à la personne morale...
        if ($objTypeDocument->objet == 'tiers') {
            // On tente de récupérer le profil associé au dossier 
            try {
                $obj_personne_morale = $this->beanManager->getBeanSafe("OPS_personne_morale", $objDossier->ops_personne_morale);
            } catch (\Exception $exception) {
                $objJustificatif->mark_deleted($objJustificatif->id);
                throw new Exception('Dossier inconnu', 401);
            }

            $chemin = $sugar_config['ops_justificatif']['chemin'] . "/" . $obj_personne_morale->id;
        }
        // Sinon on associe le justificatif au dossier...
        else {
            $chemin = $sugar_config['ops_justificatif']['chemin'] . "/" . $objDossier->id;
        }

        if( $nb_fichiers > 1 ){ // Dans le cas d'un multifichiers 

            $uuid = rand();


            foreach ($files as $file) {

                // Vérification du type : si un type de document ne correspond pas au champ, on ne sauvegarde rien :
                if( !in_array($file['type'] , $types_authorize)){
                    $response = new DossierResponse();
                    $response->setData([
                        "erreur" => "Le type du document n'est pas conforme",
                        "attache" => $donnees['attache'], 
                        "name" => $donnees["name"], 
                    ]);
                    return $response;
                }

                // Vérification de la taille : si un type de document ne correspond pas au champ, on ne sauvegarde rien :
                if( $max_size < $file['size']){
                    $response = new DossierResponse();
                    $response->setData([
                        "erreur" => "Le taille du document est incorrecte",
                        "attache" => $donnees['attache'], 
                        "name" => $donnees["name"], 
                    ]);
                    return $response;
                }

                $file = (array) $file;
             
                // Before conversion, we store physically the file.
                $tmp_name = $uuid .'_'. md5( $file['name'] ) . date('YmdHis');
                $chemin_source = $sugar_config['upload_dir'].$tmp_name ; 
        
                if( file_put_contents( $chemin_source, base64_decode( $file['content'] ) ) ){

                    // Sécurité - Scan 
                    $chemin_verif = $_SERVER['DOCUMENT_ROOT'] .'/'. $chemin_source ; 
                    $retour_verif = $this->scanPathForMalware( $chemin_verif );

                    if( strtolower($file['type']) === 'application/pdf' ){ // Pas de convertion pour un PDF 
                        rename( $chemin_source , $chemin_source.'.pdf' );
                        $piece_justificative_pdf_files[] = $chemin_source.'.pdf';
                    }else{
                        switch ( strtolower($file['type']) ) {
                            case 'image/jpeg':
                                shell_exec('convert '.$chemin_source.' '.$chemin_source.'.png');
                                shell_exec('convert '.$chemin_source.'.png '.$chemin_source.'.pdf'); 
                                if (file_exists($chemin_source.'.png')) { unlink( $chemin_source.'.png' ); }      
                                break;
                            case 'image/png':
                                shell_exec('convert '.$chemin_source.' '.$chemin_source.'.pdf');
                                break;

                            default:
                                break;
                        }

                        // Is conversion success?
                        if (file_exists($chemin_source.'.pdf')) {
                            $piece_justificative_pdf_files[] = $chemin_source.'.pdf';
                        }else{
                            $response = new DossierResponse();
                            $response->setData([
                                "erreur" => "Erreur a la conversion de l'image en PDF", // TODO : Revoir le message d'erreur pour l'usager 
                                "attache" => $donnees['attache'], 
                                "name" => $donnees["name"], 
                            ]);
                            return $response;
                        }

                        // Remove the image(s) from 'upload_dir' used for conversion.
                        if (file_exists($chemin_source)) { unlink( $chemin_source ); }      
                        
                    }


                }else{ // Erreur à la sauvegarde de la pj 
                    $response = new DossierResponse();
                    $response->setData([
                        "erreur" => "Une erreur technique s'est produite, veuillez recommencer à déposer vos documents", // TODO : Revoir le message d'erreur pour l'usager 
                        "attache" => $donnees['attache'], 
                        "name" => $donnees["name"], 
                    ]);
                    return $response;
                }

            }

            $final_pdf_list  = join( " ",$piece_justificative_pdf_files );
            $tmp_file_chemin = $sugar_config['upload_dir'].$uuid .'_'. date('YmdHis').".pdf";

            // $shell_exec_cmd  ="gs -dPDFA=1 -dBATCH -dNOPAUSE -dUseCIEColor -sProcessColorModel=DeviceCMYK -sDEVICE=pdfwrite -sPDFACompatibilityPolicy=1  -r300 -dDetectDuplicateImages -sOutputFile=".$tmp_file_chemin." ".$final_pdf_list;
            $shell_exec_cmd  ="gs -dPDFA=1 -dSAFER -dBATCH -dNOPAUSE -dNOTRANSPARENCY -sProcessColorModel=DeviceGray -sDEVICE=pdfwrite -sPDFACompatibilityPolicy=1  -r150 -dDetectDuplicateImages -sOutputFile=".$tmp_file_chemin." ".$final_pdf_list;

            $shell_exec_result = shell_exec($shell_exec_cmd);

            if (file_exists($tmp_file_chemin)) {

                # Tentative de créer le chemin de destination qui accueillira la PJ.
                @mkdir($chemin, 0755);
                if (is_dir($chemin)) {

                    $chemin_file_source = $chemin . '/' . $objJustificatif->id ;        
                    file_put_contents( $chemin_file_source , file_get_contents($tmp_file_chemin) )   ;         
                }

                $pdf_size =filesize( $chemin_file_source  );
                unlink($tmp_file_chemin);

                if( $pdf_size === 0 ){
                    unlink($chemin_file_source);
                    
                    $response = new DossierResponse();
                    $response->setData([
                        "erreur" => "Une erreur technique s'est produite, veuillez recommencer à déposer vos documents", // TODO : Revoir le message d'erreur pour l'usager 
                        "attache" => $donnees['attache'], 
                        "name" => $donnees["name"], 
                    ]);
                    return $response;
                }

            }
            else{ // Erreur à l'assemblage du multifichier
                $response = new DossierResponse();
                $response->setData([
                    "erreur" => "Une erreur technique s'est produite, veuillez recommencer à déposer vos documents", // TODO : Revoir le message d'erreur pour l'usager 
                    "attache" => $donnees['attache'], 
                    "name" => $donnees["name"], 
                ]);
                return $response;
             
            }
         
            $nom_document = str_replace(' ', '_', $objTypeDocument->name) . '.pdf'; // Création du nom final basé sur le nom du type de document.
            $taille_document = $pdf_size;
            $type_mime = 'application/pdf';

            if( isset($piece_justificative_pdf_files) ){
                // Cleanup the store generated (temp) PDF.
                foreach ( $piece_justificative_pdf_files as $key => $tmp_file ) {
                    unlink( $tmp_file );
                }
            }

        }
        else{ // Un seul fichier pas de compression 

            $file = $files[0];

            // Vérification du type : si un type de document ne correspond pas au champ, on ne sauvegarde rien :
            if( !in_array($file['type'] , $types_authorize)){
                $response = new DossierResponse();
                $response->setData([
                    "erreur" => "Le type du document n'est pas conforme",
                    "attache" => $donnees['attache'], 
                    "name" => $donnees["name"], 
                ]);
                return $response;
            }
            
            if( $max_size < $file['size']){
                $response = new DossierResponse();
                $response->setData([
                    "erreur" => "Le taille du document est incorrecte",
                    "attache" => $donnees['attache'], 
                    "name" => $donnees["name"], 
                ]);
                return $response;
            }

            $file = (array) $file;
         
            # Tentative de créer le chemin de destination qui accueillira la PJ.
            @mkdir($chemin, 0755);
            if (is_dir($chemin)) {

                $chemin_file_source = $chemin . '/' . $objJustificatif->id ; 

                file_put_contents( $chemin_file_source , base64_decode( $file['content'] ) );
                // Sécurité - Scan 
                $chemin_verif = $_SERVER['DOCUMENT_ROOT'] .'/'. $chemin_file_source ; 
                $retour_verif = $this->scanPathForMalware( $chemin_verif );

                $pdf_size =filesize( $chemin_file_source  );
                unlink($tmp_file_chemin);

                if( $pdf_size === 0 ){
                    unlink($chemin_file_source);

                    $response = new DossierResponse();
                    $response->setData([
                        "erreur" => "Une erreur technique s'est produite, veuillez recommencer à déposer vos documents", // TODO : Revoir le message d'erreur pour l'usager 
                        "attache" => $donnees['attache'], 
                        "name" => $donnees["name"], 
                    ]);
                    return $response;
                }


                
            }
         
            $nom_document = $file['name'];
            $taille_document = $file['size'];
            $type_mime = $file['type'];

        }

        $ext = explode(".", $nom_document);

        $objJustificatif->document_name = $nom_document;
        $objJustificatif->filename = $nom_document;
        $objJustificatif->file_ext = end($ext);
        $objJustificatif->file_mime_type = $type_mime;
        $objJustificatif->obligatoire = ($donnees['required'] == 'required' || $donnees['required'] == 'true') ? 1 : 0;
        $objJustificatif->visible_partenaire = $objTypeDocument->visible_partenaire;
        $objJustificatif->save();

        $objJustificatif->load_relationship('ops_type_document_ops_justificatif');
        $objJustificatif->ops_type_document_ops_justificatif->add($objTypeDocument);

        // Si tiers -> alors on associe le justificatif à la personne morale...
        if ($objTypeDocument->objet == 'tiers') {
            $obj_personne_morale->load_relationship("ops_personne_morale_ops_justificatif");
            $obj_personne_morale->ops_personne_morale_ops_justificatif->add($objJustificatif->id);
        }
        // Sinon on associe le justificatif au dossier...
        else {
            $objDossier->load_relationship("ops_dossier_ops_justificatif");
            $objDossier->ops_dossier_ops_justificatif->add($objJustificatif->id);
        }

        // On remplis le champ du dossier 
        $customChamp = (array) json_decode( base64_decode( $objDossier->champs_custom) );
        $customChamp[$donnees["name"]] = []; // Reinit le champ sous forme de tableau vide pour peuplement correct des data.
        $customChamp[$donnees["name"]]['content'] = $chemin_file_source;
        $customChamp[$donnees["name"]]['name']    = $nom_document;
        $customChamp[$donnees["name"]]['size']    = $taille_document;
        $customChamp[$donnees["name"]]['type']    = $type_mime;
        $customChamp[$donnees["name"]]['attache'] = $id_type_document;
        $objDossier->champs_custom = base64_encode( json_encode( $customChamp ) );
        $objDossier->flag_justificatif_etude = 1;
        $objDossier->save();

        $response = new DossierResponse();
        $response->setData([
            "justificatif_id" => $objJustificatif->id,
            "name" => $donnees["name"],
            "attache" => $donnees["attache"],
            "file_name" => $nom_document,
            "type" => $type_mime,
            "size" => $taille_document,
        ]);
        return $response;
    }


    /**
     * deleteDossier
     * @param DossierListParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function deleteJustificatif(DossierSetParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie que l'id du dossier n'est pas vide
        if (empty($donnees["justificatif_id"])) {
            throw new Exception("L'id du justificatif est obligatoire", 401);
        } 

        try {
            $obj_justificatif = $this->beanManager->getBeanSafe("OPS_justificatif", $donnees["justificatif_id"] );
        } catch (\Exception $exception) {
            throw new Exception('Justificatif inconnu', 401);
        }

        // Récupération du dossier pour mettre à jour le champ 
        try {
            $objDossier = $this->beanManager->getBeanSafe("OPS_dossier", $donnees["dossier_id"]);
        } catch (\Exception $exception) {
            throw new Exception('Dossier inconnu', 401);
        }

        // Récupération de l'usager connecté  
        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $donnees["user_id"]);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // Si l'usager connecté n'est pas le partenaire => On vérifie s'il est demandeur
        // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
        if (DossierService::verif_liaison_avis($obj_individu->id, $objDossier->id) || ($obj_individu->id == $objDossier->ops_individu_id && $objDossier->flag_partenaire)) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $objDossier->ops_statut_id);
            if ($obj_statut->visible_partenaire == 0) {
                $response = new DossierResponse();
                $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                return $response;
            }
        } elseif ($obj_individu->id != $objDossier->ops_individu_id) {
            if (!DossierJustificatifService::verif_liaison_profil($obj_individu->id, $objDossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }
        }

        // On vide le champ du justificatif
        $customChamp = (array) json_decode( base64_decode( $objDossier->champs_custom) );
        $customChamp[$donnees["name"]] = "";
        $objDossier->champs_custom = base64_encode( json_encode( $customChamp ) );
        $objDossier->save();


        $obj_justificatif->mark_deleted($donnees["justificatif_id"]);

        $response = new DossierResponse();
        $response->setData([
            "justificatif_id" => $obj_justificatif->id,
            "name" => $donnees["name"],
            "attache" => $donnees["attache"],
        ]);
        return $response;
    }


     public static function verif_liaison_profil($id_usager, $id_profil)
    {
        global $db;

        $requete = $db->query(
            "
            SELECT ops_personne_morale.id,
                   ops_personne_morale_individu.responsable
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_usager . "'
            AND ops_personne_morale.id =  '" . $id_profil . "'
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` DESC "
        );
        
        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            return true;
        }

        return false;
    } 
}
