<?php

namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\AjaxPointsResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;
use ODE_API\V8\Param\AjaxPointsParams;
use Configurator;

use Exception;
use Slim\Http\Request;

class AjaxPointsService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager        = $beanManager;
        $this->attributeHelper    = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper   = $paginationHelper;
    }


    /**
     * getInfoFiscaleByNumRef
     * @param IndividuInfoParams $params
     * @param $path
     * @return IndividuResponse
     * @throws AccessDeniedException
     * @see Documentation : https://www.oecd.org/tax/automatic-exchange/crs-implementation-and-assistance/tax-identification-numbers/France-TIN-Fr.pdf
     */
    public function getInfoFiscaleByNumRef(AjaxPointsParams $params, Request $request)
    {

        $numeroFiscal = $params->getNumeroFiscal();
        $referenceAvis = $params->getReferenceAvis();

        $data = array();

        try {
            

            if( !isset($numeroFiscal) || empty($numeroFiscal)
             || !isset($referenceAvis) || empty($referenceAvis)
             || !preg_match( "/^[0-9]{13,13}$/" , strtoupper(trim($numeroFiscal)), $matches)
             || !preg_match( "/^[0-9A-Z]{13,14}$/" , strtoupper(trim($referenceAvis)), $matches)
            ){
                $data = array(
                    'error' => 403,
                    'message' => 'Refus de traitement de la requête - Paramètre manquant ou invalide'
                );
            }else{

                $result = [];

                $configuratorObj   = new Configurator();
                $gouvApiServiceUrl = $configuratorObj->config['api_particulier']['url'];
                $gouvApiServiceKey = $configuratorObj->config['api_particulier']['jeton'];

                $endpointGouvApiUrl = $gouvApiServiceUrl.'?numeroFiscal='.$numeroFiscal.'&referenceAvis='.$referenceAvis;

                $hndCurl = curl_init();

                curl_setopt_array($hndCurl, array(
                    CURLOPT_URL            => $endpointGouvApiUrl,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING       => '',
                    CURLOPT_MAXREDIRS      => 10,
                    CURLOPT_TIMEOUT        => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST  => 'GET',
                    CURLOPT_HTTPHEADER     => array(
                        'X-Api-Key: '.$gouvApiServiceKey
                    ),
                ));

                $result = curl_exec($hndCurl);
                curl_close($curl);

                $response = json_decode( $result );
                $response->numeroFiscal  = $numeroFiscal;
                $response->referenceAvis = $referenceAvis;
                
                /*
                $response->gouvApiServiceUrl = $gouvApiServiceUrl;
                $response->endpointGouvApiUrl = $endpointGouvApiUrl;
                $response->gouvApiServiceKey = $gouvApiServiceKey;
                /**/

                $data = $response;

            }


        } catch (\Exception $exception) {
            $data = array(
                'error' => 401,
                'message' => 'Informations fiscales inconues'
            );
            throw new Exception('Informations fiscales inconues', 401);
        }
        //$GLOBALS['log']->fatal( "data : " . print_r($data, true) );




        $response = new AjaxPointsResponse();
        $response->setData($data);

        return $response;

    }

}
