<?php
namespace ODE_API\V8\Param\Options;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class ReferenceAvis extends BaseOption
{
    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('referenceAvis')
            ->setAllowedTypes('referenceAvis', 'string')
            ->setAllowedValues('referenceAvis', $this->validatorFactory->createClosure([
                new Assert\Regex('/^[0-9A-Z]{13,14}$/i')
            ]));
    }
}

