<?php
namespace ODE_API\V8\Param\Options;

use ODE_API\V8\Param\Options\BaseOption;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class ParentId extends BaseOption
{
    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('parentId')
            ->setAllowedTypes('parentId', 'string')
            ->setAllowedValues('parentId', $this->validatorFactory->createClosure([
                new Assert\Regex('/^(\d+|[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})$/i')
            ]));
    }
}
