<?php
namespace ODE_API\V8\Param\Options;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class NumeroFiscal extends BaseOption
{
    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('numeroFiscal')
            ->setAllowedTypes('numeroFiscal', 'string')
            ->setAllowedValues('numeroFiscal', $this->validatorFactory->createClosure([
                new Assert\Regex('/^[0-9]{13,13}$/i')
            ]));
    }
}
