<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Param\GetOAuthIdentityParams;
use ODE_API\V8\Param\GetOAuthIndividuParams;
use ODE_API\V8\Param\SetOAuthIndividuParams;
use ODE_API\V8\Param\SetOAuthHistoryCnxParams;

use ODE_API\V8\Service\OAuthCRMService;

use Slim\Http\Request;
use Slim\Http\Response;

/**
     * OAuthCRMController
*/
class OAuthCRMController extends BaseController
{
    /**
     * @var OAuthCRMController
     */
    protected $oauthcrmService;

    /**
     * @param DocumentsService $documentsService
     */
    public function __construct(OAuthCRMService $oauthcrmService)
    {
        $this->oauthcrmService = $oauthcrmService;
    }

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param GetOAuthIdentityParams $params
     *
     * @return Response
     */
    public function getIdentity(Request $request, Response $response, array $args, GetOAuthIdentityParams $params)
    {
        try {
            $jsonResponse = $this->oauthcrmService->getIdentity($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param GetOAuthIndividuParams $params
     *
     * @return Response
     */
    public function getIndividu(Request $request, Response $response, array $args, GetOAuthIndividuParams $params)
    {
        try {
            $jsonResponse = $this->oauthcrmService->getIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param SetOAuthIndividuParams $params
     *
     * @return Response
     */
    public function setIndividu(Request $request, Response $response, array $args, SetOAuthIndividuParams $params)
    {
        try {
            $jsonResponse = $this->oauthcrmService->setIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param SetOAuthIndividuParams $params
     *
     * @return Response
     */
    public function updateIndividu(Request $request, Response $response, array $args, SetOAuthIndividuParams $params)
    {
        try {
            $jsonResponse = $this->oauthcrmService->updateIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param SetOAuthHistoryCnxParams $params
     *
     * @return Response
     */
    public function updateHistoryConnexion(Request $request, Response $response, array $args, SetOAuthHistoryCnxParams $params)
    {
        try {
            $jsonResponse = $this->oauthcrmService->updateHistoryConnexion($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

}
