<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\JustificatifService;
use ODE_API\V8\Param\JustificatifListeParams;
use ODE_API\V8\Param\JustificatifUpdateParams;
use ODE_API\V8\Param\JustificatifTelechargerParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
* DispositifController
*/
class JustificatifController extends BaseController
{


    /**
    * @var JustificatifController
    */
    protected $JustificatifService;

    /**
    * @param JustificatifService $justificatifService
    */
    public function __construct(JustificatifService $justificatifService)
    {
        $this->justificatifService = $justificatifService;
    }



    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param JustificatifListeParams $params
    *
    * @return Response
    */
    public function getListeJustificatifs(Request $request, Response $response, array $args, JustificatifListeParams $params)
    {
        try {

            $jsonResponse = $this->justificatifService->getListeJustificatifs($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param JustificatifUpdateParams $params
    *
    * @return Response
    */
    public function updateJustificatifs(Request $request, Response $response, array $args, JustificatifUpdateParams $params)
    {
        try {

            $jsonResponse = $this->justificatifService->updateJustificatifs($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 


	/**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param JustificatifTelechargerParams $params
    *
    * @return Response
    */
    public function telechargerJustificatif(Request $request, Response $response, array $args, JustificatifTelechargerParams $params)
    {
        try {

            $jsonResponse = $this->justificatifService->telechargerJustificatif($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 
	
	
	
}

