<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\HorsCompteService;

use ODE_API\V8\Param\DossierSetParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
 * HorsCompteController
 */
class HorsCompteController extends BaseController
{
    /**
     * @var HorsCompteController
     */
    protected $horsCompteService;

    /**
     * @param HorsCompteService $HorsCompteService
     */
    public function __construct(HorsCompteService $horsCompteService)
    {
        $this->horsCompteService = $horsCompteService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param ListeDispositifParams $params
     *
     * @return Response
     */
    public function getListDispositif(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->horsCompteService->getListDispositif($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function getFormByEtape(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->horsCompteService->getFormByEtape($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function updateDossierByEtape(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->horsCompteService->updateDossierByEtape($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function sendCodeValidationHc(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->horsCompteService->sendCodeValidationHc($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function verifCodeValidationHc(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->horsCompteService->verifCodeValidationHc($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function getInfosDossierHc(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->horsCompteService->getInfosDossierHc($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
}
