<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\AppairageService;

use ODE_API\V8\Param\DossierSetParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
 * AppairageController
 */
class AppairageController extends BaseController
{
    /**
     * @var AppairageController
     */
    protected $appairageService;

    /**
     * @param AppairageService $appairageService
     */
    public function __construct(AppairageService $appairageService)
    {
        $this->appairageService = $appairageService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function createAppairage(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->appairageService->createAppairage($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function getAppairageByObject(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->appairageService->getAppairageByObject($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
}
