<?php

use ODE_API\V8\Controller;
use ODE_API\V8\Service\ListViewSearchService;
use ODE_API\V8\Service\ListViewService;
use ODE_API\V8\Service\LogoutService;
use ODE_API\V8\Service\MetaService;
use ODE_API\V8\Service\ModuleService;
use ODE_API\V8\Service\RelationshipService;
use ODE_API\V8\Service\UserPreferencesService;
use ODE_API\V8\Service\UserService;
use Psr\Container\ContainerInterface as Container;
use League\OAuth2\Server\ResourceServer;
use ODE_API\V8\Service\DocumentsService;
use ODE_API\V8\Service\DispositifService;
use ODE_API\V8\Service\IndividuService;
use ODE_API\V8\Service\DossierService;
use ODE_API\V8\Service\DossierJustificatifService;
use ODE_API\V8\Service\AppairageService;
use ODE_API\V8\Service\TiersService;
use ODE_API\V8\Service\JustificatifService;
use ODE_API\V8\Service\NotificationService;
use ODE_API\V8\Service\OAuthCRMService;
use ODE_API\V8\Service\RepertoireEntrepriseService;
use ODE_API\V8\Service\AjaxPointsService;
use ODE_API\V8\Service\HorsCompteService;
use ODE_API\V8\Service\ConversationService;

use ODE_API\Core\Loader\CustomLoader;

return CustomLoader::mergeCustomArray([
    // CUSTOM 
    Controller\TiersController::class => function (Container $container) {
        return new Controller\TiersController(
            $container->get(TiersService::class)
        );
    },
    Controller\ConversationController::class => function (Container $container) {
        return new Controller\ConversationController(
            $container->get(ConversationService::class)
        );
    },
    Controller\AppairageController::class => function (Container $container) {
        return new Controller\AppairageController(
            $container->get(AppairageService::class)
        );
    },
    Controller\JustificatifController::class => function (Container $container) {
        return new Controller\JustificatifController(
            $container->get(JustificatifService::class)
        );
    },
	Controller\NotificationController::class => function (Container $container) {
        return new Controller\NotificationController(
            $container->get(NotificationService::class)
        );
    },
    Controller\DossierController::class => function (Container $container) {
        return new Controller\DossierController(
            $container->get(DossierService::class)
        );
    },
    Controller\DossierJustificatifController::class => function (Container $container) {
        return new Controller\DossierJustificatifController(
            $container->get(DossierJustificatifService::class)
        );
    },
    Controller\IndividuController::class => function (Container $container) {
        return new Controller\IndividuController(
            $container->get(IndividuService::class)
        );
    },
    Controller\DispositifController::class => function (Container $container) {
        return new Controller\DispositifController(
            $container->get(DispositifService::class)
        );
    },
    Controller\DocumentsController::class => function (Container $container) {
        return new Controller\DocumentsController(
            $container->get(DocumentsService::class)
        );
    },
    Controller\ListViewSearchController::class => function (Container $container) {
        return new Controller\ListViewSearchController(
            $container->get(ListViewSearchService::class)
        );
    },
    Controller\UserPreferencesController::class => function (Container $container) {
        return new Controller\UserPreferencesController(
            $container->get(UserPreferencesService::class)
        );
    },
    Controller\UserController::class => function (Container $container) {
        return new Controller\UserController(
            $container->get(UserService::class)
        );
    },
    Controller\MetaController::class => function (Container $container) {
        return new Controller\MetaController(
            $container->get(MetaService::class)
        );
    },
    Controller\ListViewController::class => function (Container $container) {
        return new Controller\ListViewController(
            $container->get(ListViewService::class)
        );
    },
    Controller\ModuleController::class => function (Container $container) {
        return new Controller\ModuleController(
            $container->get(ModuleService::class)
        );
    },
    Controller\LogoutController::class => function (Container $container) {
        return new Controller\LogoutController(
            $container->get(LogoutService::class),
            $container->get(ResourceServer::class)
        );
    },
    Controller\RelationshipController::class => function (Container $container) {
        return new Controller\RelationshipController(
            $container->get(RelationshipService::class)
        );
    },
    Controller\OAuthCRMController::class => function (Container $container) {
        return new Controller\OAuthCRMController(
            $container->get(OAuthCRMService::class)
        );
    },
    Controller\RepertoireEntrepriseController::class => function (Container $container) {
        return new Controller\RepertoireEntrepriseController(
            $container->get(RepertoireEntrepriseService::class)
        );
    },
    Controller\AjaxPointsController::class => function (Container $container) {
        return new Controller\AjaxPointsController(
            $container->get(AjaxPointsService::class)
        );
    },
    Controller\HorsCompteController::class => function (Container $container) {
        return new Controller\HorsCompteController(
            $container->get(HorsCompteService::class)
        );
    },
], basename(__FILE__));
