<?php 
 $GLOBALS["dictionary"]["OPS_justificatif_historisation"]=array (
  'table' => 'ops_justificatif_historisation',
  'audited' => true,
  'inline_edit' => false,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'source' => 'non-db',
      'type' => 'varchar',
      'db_concat_fields' => 
      array (
        0 => 'document_name',
      ),
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'ops_justificatif_historisation_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'ops_justificatif_historisation_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'ops_justificatif_historisation_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_ops_justificatif_historisation',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'document_name' => 
    array (
      'name' => 'document_name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => '255',
      'required' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
    ),
    'filename' => 
    array (
      'name' => 'filename',
      'vname' => 'LBL_FILENAME',
      'type' => 'varchar',
      'required' => true,
      'importable' => 'required',
      'len' => '255',
      'studio' => 'false',
    ),
    'file_ext' => 
    array (
      'name' => 'file_ext',
      'vname' => 'LBL_FILE_EXTENSION',
      'type' => 'varchar',
      'len' => 100,
    ),
    'file_mime_type' => 
    array (
      'name' => 'file_mime_type',
      'vname' => 'LBL_MIME',
      'type' => 'varchar',
      'len' => '100',
    ),
    'uploadfile' => 
    array (
      'name' => 'uploadfile',
      'vname' => 'LBL_FILE_UPLOAD',
      'type' => 'file',
      'source' => 'non-db',
    ),
    'active_date' => 
    array (
      'name' => 'active_date',
      'vname' => 'LBL_DOC_ACTIVE_DATE',
      'type' => 'date',
      'required' => true,
      'importable' => 'required',
      'display_default' => 'now',
    ),
    'exp_date' => 
    array (
      'name' => 'exp_date',
      'vname' => 'LBL_DOC_EXP_DATE',
      'type' => 'date',
    ),
    'category_id' => 
    array (
      'name' => 'category_id',
      'vname' => 'LBL_SF_CATEGORY',
      'type' => 'enum',
      'len' => 100,
      'options' => 'document_category_dom',
      'reportable' => false,
    ),
    'subcategory_id' => 
    array (
      'name' => 'subcategory_id',
      'vname' => 'LBL_SF_SUBCATEGORY',
      'type' => 'enum',
      'len' => 100,
      'options' => 'document_subcategory_dom',
      'reportable' => false,
    ),
    'status_id' => 
    array (
      'name' => 'status_id',
      'vname' => 'LBL_DOC_STATUS',
      'type' => 'enum',
      'len' => 100,
      'options' => 'document_status_dom',
      'reportable' => false,
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_DOC_STATUS',
      'type' => 'varchar',
      'source' => 'non-db',
      'Comment' => 'Document status for Meta-Data framework',
    ),
    'show_preview' => 
    array (
      'name' => 'show_preview',
      'type' => 'bool',
      'source' => 'non-db',
      'reportable' => false,
    ),
    'depot' => 
    array (
      'required' => false,
      'name' => 'depot',
      'vname' => 'LBL_DEPOT',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'initial',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_depot_j_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'obligatoire' => 
    array (
      'required' => false,
      'name' => 'obligatoire',
      'vname' => 'LBL_OBLIGATOIRE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'statut' => 
    array (
      'required' => false,
      'name' => 'statut',
      'vname' => 'LBL_STATUT',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'etude',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_statut_j_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'ordre' => 
    array (
      'required' => false,
      'name' => 'ordre',
      'vname' => 'LBL_ORDRE',
      'type' => 'int',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'default' => '1',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'notification' => 
    array (
      'required' => false,
      'name' => 'notification',
      'vname' => 'LBL_NOTIFICATION',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'visible_internet' => 
    array (
      'required' => false,
      'name' => 'visible_internet',
      'vname' => 'LBL_VISIBLE_INTERNET',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'visible_partenaire' => 
    array (
      'required' => false,
      'name' => 'visible_partenaire',
      'vname' => 'LBL_VISIBLE_PARTENAIRE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'commentaire_usager' => 
    array (
      'required' => false,
      'name' => 'commentaire_usager',
      'vname' => 'LBL_COMMENTAIRE_USAGER',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'ops_type_document_ops_justificatif_historisation' => 
    array (
      'name' => 'ops_type_document_ops_justificatif_historisation',
      'type' => 'link',
      'relationship' => 'ops_type_document_ops_justificatif_historisation',
      'source' => 'non-db',
      'module' => 'OPS_type_document',
      'bean_name' => false,
      'vname' => 'LBL_OPS_TYPE_DOCUMENT_OPS_JUSTIFICATIF_HISTORISATION_FROM_OPS_TYPE_DOCUMENT_TITLE',
      'id_name' => 'ops_type_document_id',
    ),
    'ops_type_document_ops_justificatif_historisation_name' => 
    array (
      'name' => 'ops_type_document_ops_justificatif_historisation_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_TYPE_DOCUMENT_OPS_JUSTIFICATIF_HISTORISATION_FROM_OPS_TYPE_DOCUMENT_TITLE',
      'save' => true,
      'id_name' => 'ops_type_document_id',
      'link' => 'ops_type_document_ops_justificatif_historisation',
      'table' => 'ops_type_document',
      'module' => 'OPS_type_document',
      'rname' => 'name',
    ),
    'ops_type_document_id' => 
    array (
      'name' => 'ops_type_document_id',
      'type' => 'link',
      'relationship' => 'ops_type_document_ops_justificatif_historisation',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_TYPE_DOCUMENT_OPS_JUSTIFICATIF_HISTORISATION_FROM_OPS_JUSTIFICATIF_HISTORISATION_TITLE',
    ),
    'ops_justificatif_historisation_ops_justificatif' => 
    array (
      'name' => 'ops_justificatif_historisation_ops_justificatif',
      'type' => 'link',
      'relationship' => 'ops_justificatif_historisation_ops_justificatif',
      'source' => 'non-db',
      'module' => 'OPS_justificatif',
      'bean_name' => 'OPS_justificatif',
      'vname' => 'LBL_OPS_JUSTIFICATIF_HISTORISATION_OPS_JUSTIFICATIF_FROM_OPS_JUSTIFICATIF_TITLE',
      'id_name' => 'ops_justificatif_id',
    ),
    'ops_justificatif_historisation_ops_justificatif_name' => 
    array (
      'name' => 'ops_justificatif_historisation_ops_justificatif_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_JUSTIFICATIF_HISTORISATION_OPS_JUSTIFICATIF_FROM_OPS_JUSTIFICATIF_TITLE',
      'save' => true,
      'id_name' => 'ops_justificatif_id',
      'link' => 'ops_justificatif_historisation_ops_justificatif',
      'table' => 'ops_justificatif',
      'module' => 'OPS_justificatif',
      'rname' => 'name',
    ),
    'ops_justificatif_id' => 
    array (
      'name' => 'ops_justificatif_id',
      'type' => 'link',
      'relationship' => 'ops_justificatif_historisation_ops_justificatif',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_JUSTIFICATIF_HISTORISATION_OPS_JUSTIFICATIF_FROM_OPS_JUSTIFICATIF_HISTORISATION_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'ops_justificatif_historisation_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_justificatif_historisation',
      'rhs_table' => 'ops_justificatif_historisation',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'ops_justificatif_historisation_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_justificatif_historisation',
      'rhs_table' => 'ops_justificatif_historisation',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'ops_justificatif_historisation_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_justificatif_historisation',
      'rhs_table' => 'ops_justificatif_historisation',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_ops_justificatif_historisation' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_justificatif_historisation',
      'rhs_table' => 'ops_justificatif_historisation',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'OPS_justificatif_historisation',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'ops_justificatif_historisationpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'file' => 'file',
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);