<?php 
 $GLOBALS["dictionary"]["OPS_individu"]=array (
  'table' => 'ops_individu',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'rname' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'sort_on' => 'last_name',
      'source' => 'non-db',
      'group' => 'last_name',
      'len' => '255',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'importable' => 'false',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'ops_individu_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'ops_individu_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'group' => 'assigned_user_name',
      'massupdate' => true,
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'ops_individu_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_ops_individu',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'salutation' => 
    array (
      'name' => 'salutation',
      'vname' => 'LBL_SALUTATION',
      'type' => 'enum',
      'options' => 'salutation_dom',
      'massupdate' => false,
      'len' => '255',
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'first_name' => 
    array (
      'name' => 'first_name',
      'vname' => 'LBL_FIRST_NAME',
      'type' => 'varchar',
      'len' => '100',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'merge_filter' => 'selected',
      'audited' => true,
    ),
    'last_name' => 
    array (
      'name' => 'last_name',
      'vname' => 'LBL_LAST_NAME',
      'type' => 'varchar',
      'len' => '100',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
      'audited' => true,
    ),
    'full_name' => 
    array (
      'name' => 'full_name',
      'rname' => 'full_name',
      'vname' => 'LBL_NAME',
      'type' => 'fullname',
      'fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'sort_on' => 'last_name',
      'source' => 'non-db',
      'group' => 'last_name',
      'len' => '510',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'studio' => 
      array (
        'listview' => false,
      ),
    ),
    'title' => 
    array (
      'name' => 'title',
      'vname' => 'LBL_TITLE',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The title of the contact',
    ),
    'photo' => 
    array (
      'name' => 'photo',
      'vname' => 'LBL_PHOTO',
      'type' => 'image',
      'massupdate' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'reportable' => true,
      'len' => 255,
      'dbType' => 'varchar',
      'width' => '160',
      'height' => '160',
      'studio' => 
      array (
        'listview' => true,
      ),
    ),
    'department' => 
    array (
      'name' => 'department',
      'vname' => 'LBL_DEPARTMENT',
      'type' => 'varchar',
      'len' => '255',
      'comment' => 'The department of the contact',
      'merge_filter' => 'enabled',
    ),
    'do_not_call' => 
    array (
      'name' => 'do_not_call',
      'vname' => 'LBL_DO_NOT_CALL',
      'type' => 'bool',
      'massupdate' => false,
      'default' => '0',
      'audited' => true,
    ),
    'phone_home' => 
    array (
      'name' => 'phone_home',
      'vname' => 'LBL_HOME_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'merge_filter' => 'enabled',
      'audited' => true,
    ),
    'email' => 
    array (
      'name' => 'email',
      'type' => 'email',
      'query_type' => 'default',
      'source' => 'non-db',
      'operator' => 'subquery',
      'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
      'db_field' => 
      array (
        0 => 'id',
      ),
      'vname' => 'LBL_ANY_EMAIL',
      'studio' => 
      array (
        'visible' => false,
        'searchview' => true,
      ),
      'importable' => false,
      'duplicate_merge' => 'enabled',
    ),
    'phone_mobile' => 
    array (
      'name' => 'phone_mobile',
      'vname' => 'LBL_MOBILE_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'merge_filter' => 'enabled',
      'audited' => true,
    ),
    'phone_work' => 
    array (
      'name' => 'phone_work',
      'vname' => 'LBL_OFFICE_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'merge_filter' => 'enabled',
    ),
    'phone_other' => 
    array (
      'name' => 'phone_other',
      'vname' => 'LBL_OTHER_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Other phone number for the contact',
      'merge_filter' => 'enabled',
    ),
    'phone_fax' => 
    array (
      'name' => 'phone_fax',
      'vname' => 'LBL_FAX_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Contact fax number',
      'merge_filter' => 'enabled',
    ),
    'email1' => 
    array (
      'name' => 'email1',
      'vname' => 'LBL_EMAIL_ADDRESS',
      'type' => 'varchar',
      'unified_search' => true,
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'source' => 'non-db',
      'group' => 'email1',
      'merge_filter' => 'enabled',
      'full_text_search' => 
      array (
        'boost' => 3,
        'analyzer' => 'whitespace',
      ),
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'email2' => 
    array (
      'name' => 'email2',
      'vname' => 'LBL_OTHER_EMAIL_ADDRESS',
      'type' => 'varchar',
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'source' => 'non-db',
      'group' => 'email2',
      'merge_filter' => 'enabled',
      'studio' => 'false',
    ),
    'invalid_email' => 
    array (
      'name' => 'invalid_email',
      'vname' => 'LBL_INVALID_EMAIL',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'email_opt_out' => 
    array (
      'name' => 'email_opt_out',
      'vname' => 'LBL_EMAIL_OPT_OUT',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'lawful_basis' => 
    array (
      'name' => 'lawful_basis',
      'vname' => 'LBL_LAWFUL_BASIS',
      'type' => 'multienum',
      'massupdate' => false,
      'no_default' => false,
      'comments' => '',
      'inline_edit' => false,
      'reportable' => false,
      'merge_filter' => 'enabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lawful_basis_dom',
      'audited' => false,
      'importable' => false,
      'default' => '',
    ),
    'date_reviewed' => 
    array (
      'name' => 'date_reviewed',
      'vname' => 'LBL_DATE_REVIEWED',
      'type' => 'date',
      'massupdate' => false,
      'audited' => true,
      'importable' => true,
    ),
    'lawful_basis_source' => 
    array (
      'name' => 'lawful_basis_source',
      'vname' => 'LBL_LAWFUL_BASIS_SOURCE',
      'type' => 'enum',
      'massupdate' => false,
      'no_default' => false,
      'comments' => '',
      'inline_edit' => false,
      'reportable' => false,
      'merge_filter' => 'enabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lawful_basis_source_dom',
      'audited' => false,
      'importable' => true,
    ),
    'primary_address_street' => 
    array (
      'name' => 'primary_address_street',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '200',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_street_2' => 
    array (
      'name' => 'primary_address_street_2',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '38',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_street_3' => 
    array (
      'name' => 'primary_address_street_3',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '38',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_city' => 
    array (
      'name' => 'primary_address_city',
      'vname' => 'LBL_PRIMARY_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '30',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'massupdate' => true,
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_state' => 
    array (
      'name' => 'primary_address_state',
      'vname' => 'LBL_PRIMARY_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_postalcode' => 
    array (
      'name' => 'primary_address_postalcode',
      'vname' => 'LBL_PRIMARY_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '10',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'massupdate' => true,
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_country' => 
    array (
      'name' => 'primary_address_country',
      'vname' => 'LBL_PRIMARY_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
      'duplicate_merge' => 'enabled',
    ),
    'alt_address_street' => 
    array (
      'name' => 'alt_address_street',
      'vname' => 'LBL_ALT_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'group' => 'alt_address',
      'comment' => 'Street address for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_street_2' => 
    array (
      'name' => 'alt_address_street_2',
      'vname' => 'LBL_ALT_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'alt_address_street_3' => 
    array (
      'name' => 'alt_address_street_3',
      'vname' => 'LBL_ALT_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'alt_address_city' => 
    array (
      'name' => 'alt_address_city',
      'vname' => 'LBL_ALT_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'alt_address',
      'comment' => 'City for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_state' => 
    array (
      'name' => 'alt_address_state',
      'vname' => 'LBL_ALT_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'alt_address',
      'comment' => 'State for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_postalcode' => 
    array (
      'name' => 'alt_address_postalcode',
      'vname' => 'LBL_ALT_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'alt_address',
      'comment' => 'Postal code for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_country' => 
    array (
      'name' => 'alt_address_country',
      'vname' => 'LBL_ALT_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'alt_address',
      'comment' => 'Country for alternate address',
      'merge_filter' => 'enabled',
    ),
    'assistant' => 
    array (
      'name' => 'assistant',
      'vname' => 'LBL_ASSISTANT',
      'type' => 'varchar',
      'len' => '75',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 2,
      ),
      'comment' => 'Name of the assistant of the contact',
      'merge_filter' => 'enabled',
    ),
    'assistant_phone' => 
    array (
      'name' => 'assistant_phone',
      'vname' => 'LBL_ASSISTANT_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'group' => 'assistant',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Phone number of the assistant of the contact',
      'merge_filter' => 'enabled',
    ),
    'email_addresses_primary' => 
    array (
      'name' => 'email_addresses_primary',
      'type' => 'link',
      'relationship' => 'ops_individu_email_addresses_primary',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESS_PRIMARY',
      'duplicate_merge' => 'disabled',
    ),
    'email_addresses' => 
    array (
      'name' => 'email_addresses',
      'type' => 'link',
      'relationship' => 'ops_individu_email_addresses',
      'module' => 'EmailAddress',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESSES',
      'reportable' => false,
      'unified_search' => true,
      'rel_fields' => 
      array (
        'primary_address' => 
        array (
          'type' => 'bool',
        ),
      ),
    ),
    'email_addresses_non_primary' => 
    array (
      'name' => 'email_addresses_non_primary',
      'type' => 'email',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_NON_PRIMARY',
      'studio' => false,
      'reportable' => false,
      'massupdate' => false,
    ),
    'date_naissance' => 
    array (
      'required' => false,
      'name' => 'date_naissance',
      'vname' => 'LBL_DATE_NAISSANCE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'duplicate_merge' => 'enabled',
    ),
    'lieu_naissance' => 
    array (
      'required' => false,
      'name' => 'lieu_naissance',
      'vname' => 'LBL_LIEU_NAISSANCE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'nationalite' => 
    array (
      'required' => false,
      'name' => 'nationalite',
      'vname' => 'LBL_NATIONALITE',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_nationalite_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'reference' => 
    array (
      'required' => false,
      'name' => 'reference',
      'vname' => 'LBL_REFERENCE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'tiers_financier' => 
    array (
      'required' => false,
      'name' => 'tiers_financier',
      'vname' => 'LBL_TIERS_FINANCIER',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'financeur' => 
    array (
      'required' => false,
      'name' => 'financeur',
      'vname' => 'LBL_FINANCEUR',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'num_individu' => 
    array (
      'required' => false,
      'name' => 'num_individu',
      'vname' => 'LBL_NUM_INDIVIDU',
      'type' => 'int',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '1',
      'min' => 1,
      'max' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => false,
      ),
    ),
    'type_individu' => 
    array (
      'required' => false,
      'name' => 'type_individu',
      'vname' => 'LBL_TYPE_INDIVIDU',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_type_individu_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'situation_familiale' => 
    array (
      'required' => false,
      'name' => 'situation_familiale',
      'vname' => 'LBL_SITUATION_FAMILIALE',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_situation_familiale_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_number' => 
    array (
      'name' => 'primary_address_number',
      'vname' => 'LBL_PRIMARY_ADDRESS_NUMBER',
      'type' => 'varchar',
      'len' => '200',
      'group' => 'primary_address',
      'merge_filter' => 'enabled',
      'audited' => true,
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_street_1' => 
    array (
      'name' => 'primary_address_street_1',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET_1',
      'type' => 'varchar',
      'len' => '38',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_complement_batiment' => 
    array (
      'name' => 'primary_address_complement_batiment',
      'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_BATIMENT',
      'type' => 'varchar',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
      'duplicate_merge' => 'enabled',
    ),
    'primary_address_complement_lieu' => 
    array (
      'name' => 'primary_address_complement_lieu',
      'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_LIEU',
      'type' => 'varchar',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
      'duplicate_merge' => 'enabled',
    ),
    'connexion_internet' => 
    array (
      'required' => false,
      'name' => 'connexion_internet',
      'vname' => 'LBL_CONNEXION_INTERNET',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'statut_compte' => 
    array (
      'required' => false,
      'name' => 'statut_compte',
      'vname' => 'LBL_STATUT_COMPTE',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_statut_compte_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'canal' => 
    array (
      'required' => false,
      'name' => 'canal',
      'vname' => 'LBL_CANAL',
      'type' => 'enum',
      'default' => 'crm',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_canal_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'nom_usage' => 
    array (
      'required' => false,
      'name' => 'nom_usage',
      'vname' => 'LBL_NOM_USAGE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'etat' => 
    array (
      'required' => false,
      'name' => 'etat',
      'vname' => 'LBL_ETAT',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_etat_individu_list',
      'default' => 'vivant',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'pays_naissance' => 
    array (
      'required' => false,
      'name' => 'pays_naissance',
      'vname' => 'LBL_PAYS_NAISSANCE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'representant_parent' => 
    array (
      'required' => false,
      'name' => 'representant_parent',
      'vname' => 'LBL_REPRESENTANT_PARENT',
      'type' => 'bool',
      'massupdate' => true,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'accepte_mail' => 
    array (
      'required' => false,
      'name' => 'accepte_mail',
      'vname' => 'LBL_ACCEPTE_MAIL',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'accepte_sms' => 
    array (
      'required' => false,
      'name' => 'accepte_sms',
      'vname' => 'LBL_ACCEPTE_SMS',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'profession_pcs' => 
    array (
      'required' => false,
      'name' => 'profession_pcs',
      'vname' => 'LBL_PROFESSION_PCS',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_pcs_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'nom_employeur' => 
    array (
      'required' => false,
      'name' => 'nom_employeur',
      'vname' => 'LBL_NOM_EMPLOYEUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'adresse_num' => 
    array (
      'required' => false,
      'name' => 'adresse_num',
      'vname' => 'LBL_PRIMARY_ADDRESS_NUMBER',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'adresse_voie' => 
    array (
      'required' => false,
      'name' => 'adresse_voie',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'adresse_complement_lieu' => 
    array (
      'required' => false,
      'name' => 'adresse_complement_lieu',
      'vname' => 'LBL_ADRESSE_COMPLEMENT_LIEU',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'adresse_complement_batiment' => 
    array (
      'required' => false,
      'name' => 'adresse_complement_batiment',
      'vname' => 'LBL_ADRESSE_COMPLEMENT_BATIMENT',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'address_postalcode' => 
    array (
      'required' => false,
      'name' => 'address_postalcode',
      'vname' => 'LBL_ADRESSE_CODE_POSTAL',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'address_city' => 
    array (
      'required' => false,
      'name' => 'address_city',
      'vname' => 'LBL_ADRESSE_VILLE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'handicap' => 
    array (
      'required' => false,
      'name' => 'handicap',
      'vname' => 'LBL_HANDICAP',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'non',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_handicap_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'aide_handicap' => 
    array (
      'required' => false,
      'name' => 'aide_handicap',
      'vname' => 'LBL_AIDE_HANDICAP',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'vaccin_a_jour' => 
    array (
      'required' => false,
      'name' => 'vaccin_a_jour',
      'vname' => 'LBL_VACCIN_A_JOUR',
      'type' => 'bool',
      'massupdate' => true,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'medecin_traitant' => 
    array (
      'required' => false,
      'name' => 'medecin_traitant',
      'vname' => 'LBL_MEDECIN_TRAITANT',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'presence_trouble_consigne' => 
    array (
      'required' => false,
      'name' => 'presence_trouble_consigne',
      'vname' => 'LBL_PRESENCE_TROUBLE_CONSIGNE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '80',
      'duplicate_merge' => 'enabled',
    ),
    'menu_autorise' => 
    array (
      'required' => false,
      'name' => 'menu_autorise',
      'vname' => 'LBL_MENU_AUTORISE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_menu_autorise_list',
      'studio' => 'visible',
      'dependency' => false,
      'duplicate_merge' => 'enabled',
    ),
    'fai' => 
    array (
      'required' => false,
      'name' => 'fai',
      'vname' => 'LBL_FAI',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'production_diffusion_image' => 
    array (
      'required' => false,
      'name' => 'production_diffusion_image',
      'vname' => 'LBL_PRODUCTION_DIFFUSION_IMAGE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'diffusion_caf' => 
    array (
      'required' => false,
      'name' => 'diffusion_caf',
      'vname' => 'LBL_DIFFUSION_CAF',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'attestation_assurance' => 
    array (
      'required' => false,
      'name' => 'attestation_assurance',
      'vname' => 'LBL_ATTESTATION_ASSURANCE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'sexe' => 
    array (
      'required' => false,
      'name' => 'sexe',
      'vname' => 'LBL_SEXE',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_sexe_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'inactif_notification' => 
    array (
      'required' => false,
      'name' => 'inactif_notification',
      'vname' => 'LBL_INACTIF_NOTIFICATION',
      'type' => 'bool',
      'massupdate' => true,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'duplicate_merge' => 'enabled',
    ),
    'ops_individu_ops_appairage' => 
    array (
      'name' => 'ops_individu_ops_appairage',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_appairage',
      'source' => 'non-db',
      'module' => 'OPS_appairage',
      'bean_name' => false,
      'vname' => 'LBL_OPS_INDIVIDU_OPS_APPAIRAGE_FROM_OPS_APPAIRAGE_TITLE',
    ),
    'ops_individu_activities_calls' => 
    array (
      'name' => 'ops_individu_activities_calls',
      'type' => 'link',
      'relationship' => 'ops_individu_activities_calls',
      'source' => 'non-db',
      'module' => 'Calls',
      'bean_name' => 'Call',
      'vname' => 'LBL_OPS_INDIVIDU_ACTIVITIES_CALLS_FROM_CALLS_TITLE',
    ),
    'ops_individu_activities_meetings' => 
    array (
      'name' => 'ops_individu_activities_meetings',
      'type' => 'link',
      'relationship' => 'ops_individu_activities_meetings',
      'source' => 'non-db',
      'module' => 'Meetings',
      'bean_name' => 'Meeting',
      'vname' => 'LBL_OPS_INDIVIDU_ACTIVITIES_MEETINGS_FROM_MEETINGS_TITLE',
    ),
    'ops_individu_activities_notes' => 
    array (
      'name' => 'ops_individu_activities_notes',
      'type' => 'link',
      'relationship' => 'ops_individu_activities_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'vname' => 'LBL_OPS_INDIVIDU_ACTIVITIES_NOTES_FROM_NOTES_TITLE',
    ),
    'ops_individu_activities_tasks' => 
    array (
      'name' => 'ops_individu_activities_tasks',
      'type' => 'link',
      'relationship' => 'ops_individu_activities_tasks',
      'source' => 'non-db',
      'module' => 'Tasks',
      'bean_name' => 'Task',
      'vname' => 'LBL_OPS_INDIVIDU_ACTIVITIES_TASKS_FROM_TASKS_TITLE',
    ),
    'ops_individu_activities_emails' => 
    array (
      'name' => 'ops_individu_activities_emails',
      'type' => 'link',
      'relationship' => 'ops_individu_activities_emails',
      'source' => 'non-db',
      'module' => 'Emails',
      'bean_name' => 'Email',
      'vname' => 'LBL_OPS_INDIVIDU_ACTIVITIES_EMAILS_FROM_EMAILS_TITLE',
    ),
    'ops_individu_documents' => 
    array (
      'name' => 'ops_individu_documents',
      'type' => 'link',
      'relationship' => 'ops_individu_documents',
      'source' => 'non-db',
      'module' => 'Documents',
      'bean_name' => 'Document',
      'side' => 'right',
      'vname' => 'LBL_OPS_INDIVIDU_DOCUMENTS_FROM_DOCUMENTS_TITLE',
    ),
    'ops_individu_ops_dossier' => 
    array (
      'name' => 'ops_individu_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_dossier',
      'bean_name' => 'OPS_dossier',
      'side' => 'right',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_historique_connexion_ops_individu' => 
    array (
      'name' => 'ops_historique_connexion_ops_individu',
      'type' => 'link',
      'relationship' => 'ops_historique_connexion_ops_individu',
      'source' => 'non-db',
      'module' => 'OPS_historique_connexion',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_HISTORIQUE_CONNEXION_OPS_INDIVIDU_FROM_OPS_HISTORIQUE_CONNEXION_TITLE',
    ),
    'ops_type_personne_ops_individu' => 
    array (
      'name' => 'ops_type_personne_ops_individu',
      'type' => 'link',
      'relationship' => 'ops_type_personne_ops_individu',
      'source' => 'non-db',
      'module' => 'OPS_type_personne',
      'bean_name' => false,
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_INDIVIDU_FROM_OPS_TYPE_PERSONNE_TITLE',
      'id_name' => 'ops_type_personne_id',
    ),
    'ops_type_personne_ops_individu_name' => 
    array (
      'name' => 'ops_type_personne_ops_individu_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_INDIVIDU_FROM_OPS_TYPE_PERSONNE_TITLE',
      'save' => true,
      'id_name' => 'ops_type_personne_id',
      'link' => 'ops_type_personne_ops_individu',
      'table' => 'ops_type_personne',
      'module' => 'OPS_type_personne',
      'rname' => 'name',
    ),
    'ops_type_personne_id' => 
    array (
      'name' => 'ops_type_personne_id',
      'type' => 'link',
      'relationship' => 'ops_type_personne_ops_individu',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_INDIVIDU_FROM_OPS_INDIVIDU_TITLE',
    ),
    'ops_individu_ops_personne_morale_individu' => 
    array (
      'name' => 'ops_individu_ops_personne_morale_individu',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_personne_morale_individu',
      'source' => 'non-db',
      'module' => 'OPS_personne_morale_individu',
      'bean_name' => 'OPS_personne_morale_individu',
      'side' => 'right',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_PERSONNE_MORALE_INDIVIDU_FROM_OPS_PERSONNE_MORALE_INDIVIDU_TITLE',
    ),
    'ops_lien_parente_ops_individu' => 
    array (
      'name' => 'ops_lien_parente_ops_individu',
      'type' => 'link',
      'relationship' => 'ops_lien_parente_ops_individu',
      'source' => 'non-db',
      'module' => 'OPS_lien_parente',
      'bean_name' => 'OPS_lien_parente',
      'side' => 'right',
      'vname' => 'LBL_OPS_LIEN_PARENTE_OPS_INDIVIDU_FROM_OPS_LIEN_PARENTE_TITLE',
    ),
    'ops_lien_parente_ops_individu_2' => 
    array (
      'name' => 'ops_lien_parente_ops_individu_2',
      'type' => 'link',
      'relationship' => 'ops_lien_parente_ops_individu_2',
      'source' => 'non-db',
      'module' => 'OPS_lien_parente',
      'bean_name' => 'OPS_lien_parente',
      'side' => 'right',
      'vname' => 'LBL_OPS_LIEN_PARENTE_OPS_INDIVIDU_2_FROM_OPS_LIEN_PARENTE_TITLE',
    ),
    'ops_individu_ops_domiciliation' => 
    array (
      'name' => 'ops_individu_ops_domiciliation',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_domiciliation',
      'source' => 'non-db',
      'module' => 'OPS_domiciliation',
      'bean_name' => 'OPS_domiciliation',
      'side' => 'right',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_DOMICILIATION_FROM_OPS_DOMICILIATION_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'ops_individu_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_individu',
      'rhs_table' => 'ops_individu',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'ops_individu_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_individu',
      'rhs_table' => 'ops_individu',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'ops_individu_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_individu',
      'rhs_table' => 'ops_individu',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_ops_individu' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_individu',
      'rhs_table' => 'ops_individu',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'OPS_individu',
    ),
    'ops_individu_email_addresses' => 
    array (
      'lhs_module' => 'OPS_individu',
      'lhs_table' => 'ops_individu',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'bean_module',
      'relationship_role_column_value' => 'OPS_individu',
    ),
    'ops_individu_email_addresses_primary' => 
    array (
      'lhs_module' => 'OPS_individu',
      'lhs_table' => 'ops_individu',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'primary_address',
      'relationship_role_column_value' => '1',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'ops_individupk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'person' => 'person',
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);